/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import hex.quantile.Quantile;
import hex.quantile.QuantileModel;
import water.DKV;
import water.fvec.Frame;
import water.fvec.Vec;
import water.rapids.AST;
import water.rapids.ASTNumList;
import water.rapids.ASTPrim;
import water.rapids.Env;
import water.rapids.Val;
import water.rapids.ValFrame;

class ASTQtile
extends ASTPrim {
    ASTQtile() {
    }

    @Override
    public String[] args() {
        return new String[]{"ary", "probs", "interpolationMethod"};
    }

    @Override
    int nargs() {
        return 4;
    }

    @Override
    public String str() {
        return "quantile";
    }

    @Override
    Val apply(Env env, Env.StackHelp stk, AST[] asts) {
        QuantileModel.QuantileParameters parms = new QuantileModel.QuantileParameters();
        Frame fr = stk.track(asts[1].exec(env)).getFrame();
        Frame fr_wkey = new Frame(fr);
        DKV.put(fr_wkey);
        parms._train = fr_wkey._key;
        for (double d : parms._probs = ((ASTNumList)asts[2]).expand()) {
            if (!(d < 0.0) && !(d > 1.0)) continue;
            throw new IllegalArgumentException("Probability must be between 0 and 1: " + d);
        }
        String inter = asts[3].exec(env).getStr();
        parms._combine_method = QuantileModel.CombineMethod.valueOf(inter.toUpperCase());
        QuantileModel q = (QuantileModel)new Quantile(parms).trainModel().get();
        DKV.remove(fr_wkey._key);
        Vec[] vecs = new Vec[1 + fr.numCols()];
        String[] names = new String[vecs.length];
        vecs[0] = Vec.makeCon(null, parms._probs);
        names[0] = "Probs";
        for (int i = 0; i < fr.numCols(); ++i) {
            vecs[i + 1] = Vec.makeCon(null, ((QuantileModel.QuantileOutput)q._output)._quantiles[i]);
            names[i + 1] = fr._names[i] + "Quantiles";
        }
        q.delete();
        return new ValFrame(new Frame(names, vecs));
    }
}

