/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import jsr166y.CountedCompleter;
import water.DKV;
import water.H2O;
import water.Key;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.rapids.AST;
import water.rapids.ASTPrim;
import water.rapids.Env;
import water.rapids.Val;
import water.rapids.ValFrame;

class ASTRBind
extends ASTPrim {
    ASTRBind() {
    }

    @Override
    public String[] args() {
        return new String[]{"..."};
    }

    @Override
    int nargs() {
        return -1;
    }

    @Override
    public String str() {
        return "rbind";
    }

    @Override
    ValFrame apply(Env env, Env.StackHelp stk, AST[] asts) {
        Frame fr = null;
        int nchks = 0;
        Val[] vals = new Val[asts.length];
        for (int i = 1; i < asts.length; ++i) {
            vals[i] = stk.track(asts[i].exec(env));
            if (vals[i].isFrame()) {
                fr = vals[i].getFrame();
                nchks += fr.anyVec().nChunks();
                continue;
            }
            ++nchks;
        }
        Vec zz = null;
        if (fr == null) {
            fr = new Frame(new String[]{Frame.defaultColName(0)}, new Vec[]{zz = Vec.makeZero(0L)});
            if (asts.length == 1) {
                return new ValFrame(fr);
            }
        }
        Frame[] frs = new Frame[asts.length];
        byte[] types = fr.types();
        long[] espc = new long[nchks + 1];
        int coffset = 0;
        Frame[] tmp_frs = new Frame[asts.length];
        for (int i = 1; i < asts.length; ++i) {
            Frame fr0;
            Val val = vals[i];
            Frame frame = fr0 = val.isFrame() ? val.getFrame() : new Frame(fr._names, Vec.makeCons(val.getNum(), 1L, fr.numCols()));
            if (fr.numCols() != fr0.numCols()) {
                throw new IllegalArgumentException("rbind frames must have all the same columns, found " + fr.numCols() + " and " + fr0.numCols() + " columns.");
            }
            if (!Arrays.deepEquals(fr._names, fr0._names)) {
                throw new IllegalArgumentException("rbind frames must have all the same column names, found " + Arrays.toString(fr._names) + " and " + Arrays.toString(fr0._names));
            }
            if (!Arrays.equals(types, fr0.types())) {
                throw new IllegalArgumentException("rbind frames must have all the same column types, found " + Arrays.toString(types) + " and " + Arrays.toString(fr0.types()));
            }
            frs[i] = fr0;
            long roffset = espc[coffset];
            long[] espc2 = fr0.anyVec().espc();
            for (int j = 1; j < espc2.length; ++j) {
                espc[coffset + j] = roffset + espc2[j];
            }
            coffset += espc2.length - 1;
        }
        if (zz != null) {
            zz.remove();
        }
        HashMap[] dmap = new HashMap[types.length];
        String[][] domains = new String[types.length][];
        int[][][] cmaps = new int[types.length][][];
        for (int k = 0; k < types.length; ++k) {
            dmap[k] = new HashMap();
            int c = 0;
            byte t = types[k];
            if (t == 4) {
                int[][] maps = new int[frs.length][];
                for (int i = 1; i < frs.length; ++i) {
                    maps[i] = new int[frs[i].vec(k).domain().length];
                    for (int j = 0; j < maps[i].length; ++j) {
                        String s = frs[i].vec(k).domain()[j];
                        if (!dmap[k].containsKey(s)) {
                            int n = c++;
                            maps[i][j] = n;
                            dmap[k].put(s, n);
                            continue;
                        }
                        maps[i][j] = (Integer)dmap[k].get(s);
                    }
                }
                cmaps[k] = maps;
            } else {
                cmaps[k] = new int[frs.length][];
            }
            domains[k] = c == 0 ? null : new String[c];
            for (Map.Entry e : dmap[k].entrySet()) {
                domains[k][((Integer)e.getValue()).intValue()] = (String)e.getKey();
            }
        }
        Key<Vec>[] keys = fr.anyVec().group().addVecs(fr.numCols());
        Vec[] vecs = new Vec[fr.numCols()];
        int rowLayout = Vec.ESPC.rowLayout(keys[0], espc);
        for (int i = 0; i < vecs.length; ++i) {
            vecs[i] = new Vec(keys[i], rowLayout, domains[i], types[i]);
        }
        ParallelRbinds t = new ParallelRbinds(frs, espc, vecs, cmaps);
        H2O.submitTask(t).join();
        for (Frame tfr : tmp_frs) {
            if (tfr == null) continue;
            tfr.delete();
        }
        return new ValFrame(new Frame(fr.names(), t._vecs));
    }

    private static class RbindMRTask
    extends MRTask<RbindMRTask> {
        private final int[] _cmap;
        private final int _chunkOffset;
        private final Vec _v;

        RbindMRTask(H2O.H2OCountedCompleter hc, int[] cmap, Vec v, int offset) {
            super(hc);
            this._cmap = cmap;
            this._v = v;
            this._chunkOffset = offset;
        }

        @Override
        public void map(Chunk cs) {
            int idx = this._chunkOffset + cs.cidx();
            Key ckey = Vec.chunkKey(this._v._key, idx);
            if (this._cmap != null) {
                assert (!cs.hasFloat()) : "Input chunk (" + cs.getClass() + ") has float, but is expected to be categorical";
                NewChunk nc = new NewChunk(this._v, idx);
                for (int r = 0; r < cs._len; ++r) {
                    if (cs.isNA(r)) {
                        nc.addNA();
                        continue;
                    }
                    nc.addNum(this._cmap[(int)cs.at8(r)], 0);
                }
                nc.close(this._fs);
            } else {
                DKV.put(ckey, cs.deepCopy(), this._fs, true);
            }
        }
    }

    private static class RbindTask
    extends H2O.H2OCountedCompleter<RbindTask> {
        final Vec[] _vecs;
        final Vec _v;
        final long[] _espc;
        int[][] _cmaps;

        RbindTask(H2O.H2OCountedCompleter cc, Vec[] vecs, Vec v, long[] espc, int[][] cmaps) {
            super(cc);
            this._vecs = vecs;
            this._v = v;
            this._espc = espc;
            this._cmaps = cmaps;
        }

        @Override
        protected void compute2() {
            this.addToPendingCount(this._vecs.length - 1 - 1);
            int offset = 0;
            for (int i = 1; i < this._vecs.length; ++i) {
                new RbindMRTask(this, this._cmaps[i], this._v, offset).asyncExec(this._vecs[i]);
                offset += this._vecs[i].nChunks();
            }
        }

        @Override
        public void onCompletion(CountedCompleter cc) {
            DKV.put(this._v);
        }
    }

    private static class ParallelRbinds
    extends H2O.H2OCountedCompleter {
        private final AtomicInteger _ctr;
        private static int MAXP = 100;
        private Frame[] _frs;
        private int[][][] _cmaps;
        private long[] _espc;
        private Vec[] _vecs;

        ParallelRbinds(Frame[] frs, long[] espc, Vec[] vecs, int[][][] cmaps) {
            this._frs = frs;
            this._espc = espc;
            this._vecs = vecs;
            this._cmaps = cmaps;
            this._ctr = new AtomicInteger(MAXP - 1);
        }

        @Override
        protected void compute2() {
            int ncols = this._frs[1].numCols();
            this.addToPendingCount(ncols - 1);
            for (int i = 0; i < Math.min(MAXP, ncols); ++i) {
                this.forkVecTask(i);
            }
        }

        private void forkVecTask(int colnum) {
            Vec[] vecs = new Vec[this._frs.length];
            for (int i = 1; i < this._frs.length; ++i) {
                vecs[i] = this._frs[i].vec(colnum);
            }
            new RbindTask(new Callback(), vecs, this._vecs[colnum], this._espc, this._cmaps[colnum]).fork();
        }

        private class Callback
        extends H2O.H2OCallback {
            public Callback() {
                super(ParallelRbinds.this);
            }

            public void callback(H2O.H2OCountedCompleter h2OCountedCompleter) {
                int i = ParallelRbinds.this._ctr.incrementAndGet();
                if (i < ParallelRbinds.this._vecs.length) {
                    ParallelRbinds.this.forkVecTask(i);
                }
            }
        }
    }
}

