/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import water.DKV;
import water.H2O;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.Vec;
import water.rapids.AST;
import water.rapids.ASTColSlice;
import water.rapids.ASTNum;
import water.rapids.ASTNumList;
import water.rapids.ASTPrim;
import water.rapids.Env;
import water.rapids.Session;
import water.rapids.Val;
import water.rapids.ValFrame;

class ASTRectangleAssign
extends ASTPrim {
    ASTRectangleAssign() {
    }

    @Override
    public String[] args() {
        return new String[]{"dst", "src", "col_expr", "row_expr"};
    }

    @Override
    int nargs() {
        return 5;
    }

    @Override
    public String str() {
        return ":=";
    }

    @Override
    Val apply(Env env, Env.StackHelp stk, AST[] asts) {
        Frame dst = stk.track(asts[1].exec(env)).getFrame();
        Val vsrc = stk.track(asts[2].exec(env));
        ASTNumList cols_numlist = new ASTNumList(asts[3].columns(dst.names()));
        if (cols_numlist.isEmpty()) {
            cols_numlist = new ASTNumList(0L, dst.numCols());
        }
        int[] cols = ASTColSlice.col_select(dst.names(), cols_numlist);
        dst = new Frame(dst._names, (Vec[])dst.vecs().clone());
        if (asts[4] instanceof ASTNum || asts[4] instanceof ASTNumList) {
            ASTNumList rows;
            ASTNumList aSTNumList = rows = asts[4] instanceof ASTNum ? new ASTNumList(((ASTNum)asts[4])._v.getNum()) : (ASTNumList)asts[4];
            if (rows.isEmpty()) {
                rows = new ASTNumList(0L, dst.numRows());
            }
            switch (vsrc.type()) {
                case 1: {
                    this.assign_frame_scalar(dst, cols, rows, vsrc.getNum(), env._ses);
                    break;
                }
                case 3: {
                    this.assign_frame_scalar(dst, cols, rows, vsrc.getStr(), env._ses);
                    break;
                }
                case 5: {
                    this.assign_frame_frame(dst, cols, rows, vsrc.getFrame(), env._ses);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Source must be a Frame or Number, but found a " + vsrc.getClass());
                }
            }
        } else {
            Frame rows = stk.track(asts[4].exec(env)).getFrame();
            switch (vsrc.type()) {
                case 1: {
                    this.assign_frame_scalar(dst, cols, rows, vsrc.getNum(), env._ses);
                    break;
                }
                case 3: {
                    throw H2O.unimpl();
                }
                case 5: {
                    throw H2O.unimpl();
                }
                default: {
                    throw new IllegalArgumentException("Source must be a Frame or Number, but found a " + vsrc.getClass());
                }
            }
        }
        return new ValFrame(dst);
    }

    private void assign_frame_frame(Frame dst, int[] cols, ASTNumList rows, Frame src, Session ses) {
        if (cols.length != src.numCols()) {
            throw new IllegalArgumentException("Source and destination frames must have the same count of columns");
        }
        long nrows = rows.cnt();
        if (src.numRows() != nrows) {
            throw new IllegalArgumentException("Requires same count of rows in the number-list (" + nrows + ") as in the source (" + src.numRows() + ")");
        }
        if (dst.numRows() == nrows && rows.isDense()) {
            for (int i = 0; i < cols.length; ++i) {
                dst.replace(cols[i], src.vecs()[i]);
            }
            if (dst._key != null) {
                DKV.put(dst);
            }
            return;
        }
        Vec[] dvecs = dst.vecs();
        Vec[] svecs = src.vecs();
        for (int col = 0; col < cols.length; ++col) {
            if (dvecs[cols[col]].get_type() == svecs[col].get_type()) continue;
            throw new IllegalArgumentException("Columns must be the same type; column " + col + ", '" + dst._names[cols[col]] + "', is of type " + dvecs[cols[col]].get_type_str() + " and the source is " + svecs[col].get_type_str());
        }
        if (nrows <= 1L || (long)cols.length * nrows <= 1000L) {
            dvecs = ses.copyOnWrite(dst, cols);
            long[] rownums = rows.expand8();
            for (int col = 0; col < svecs.length; ++col) {
                for (int ridx = 0; ridx < rownums.length; ++ridx) {
                    dvecs[cols[col]].set(rownums[ridx], svecs[col].at(ridx));
                }
            }
            return;
        }
        throw H2O.unimpl();
    }

    private void assign_frame_scalar(Frame dst, int[] cols, final ASTNumList rows, final double src, Session ses) {
        long nrows = rows.cnt();
        if (nrows == 1L) {
            Vec[] vecs = ses.copyOnWrite(dst, cols);
            long drow = (long)rows._bases[0];
            for (int i = 0; i < cols.length; ++i) {
                vecs[cols[i]].set(drow, src);
            }
            return;
        }
        if (dst.numRows() == nrows && rows.isDense()) {
            Vec vsrc = dst.anyVec().makeCon(src);
            for (int i = 0; i < cols.length; ++i) {
                dst.replace(cols[i], vsrc);
            }
            if (dst._key != null) {
                DKV.put(dst);
            }
            return;
        }
        Vec[] vecs = ses.copyOnWrite(dst, cols);
        Vec[] vecs2 = new Vec[cols.length];
        for (int i = 0; i < cols.length; ++i) {
            vecs2[i] = vecs[cols[i]];
        }
        rows.sort();
        new MRTask(){

            @Override
            public void map(Chunk[] cs) {
                long start = cs[0].start();
                long end = start + (long)cs[0]._len;
                long min = (long)rows.min();
                long max = (long)rows.max() - 1L;
                if (max >= start && min <= end) {
                    int startOffset;
                    for (int i = startOffset = (int)(min > start ? min : start); i < cs[0]._len; ++i) {
                        if (!rows.has(start + (long)i)) continue;
                        for (Chunk chk : cs) {
                            chk.set(i, src);
                        }
                    }
                }
            }
        }.doAll(vecs2);
    }

    private void assign_frame_scalar(Frame dst, int[] cols, ASTNumList rows, String src, Session ses) {
        throw H2O.unimpl();
    }

    private void assign_frame_scalar(Frame dst, int[] cols, Frame rows, double src, Session ses) {
        throw H2O.unimpl();
    }
}

