/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.Vec;
import water.rapids.AST;
import water.rapids.ASTPrim;
import water.rapids.Env;
import water.rapids.Val;
import water.rapids.ValFrame;

class ASTRepLen
extends ASTPrim {
    ASTRepLen() {
    }

    @Override
    public String[] args() {
        return new String[]{"ary", "length"};
    }

    @Override
    int nargs() {
        return 3;
    }

    @Override
    public String str() {
        return "rep_len";
    }

    @Override
    ValFrame apply(Env env, Env.StackHelp stk, AST[] asts) {
        Val v = asts[1].exec(env);
        long length = (long)asts[2].exec(env).getNum();
        if (!(v instanceof ValFrame)) {
            return new ValFrame(new Frame(Vec.makeCon(v.getNum(), length)));
        }
        Frame ff = stk.track(v).getFrame();
        final Frame fr = ff;
        if (fr.numCols() == 1) {
            Vec vec = Vec.makeRepSeq(length, fr.numRows());
            new MRTask(){

                @Override
                public void map(Chunk c) {
                    for (int i = 0; i < c._len; ++i) {
                        c.set(i, fr.anyVec().at((long)c.atd(i)));
                    }
                }
            }.doAll(vec);
            vec.setDomain(fr.anyVec().domain());
            return new ValFrame(new Frame(vec));
        }
        Frame f = new Frame(new Vec[0]);
        int i = 0;
        while ((long)i < length) {
            f.add(Frame.defaultColName(f.numCols()), fr.vec(i % fr.numCols()));
            ++i;
        }
        return new ValFrame(f);
    }
}

