/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import java.util.Locale;
import water.MRTask;
import water.fvec.C0DChunk;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.parser.BufferedString;
import water.rapids.AST;
import water.rapids.ASTPrim;
import water.rapids.Env;
import water.rapids.Val;
import water.rapids.ValFrame;

class ASTReplaceAll
extends ASTPrim {
    ASTReplaceAll() {
    }

    @Override
    public String[] args() {
        return new String[]{"ary", "pattern", "replacement", "ignore_case"};
    }

    @Override
    int nargs() {
        return 5;
    }

    @Override
    public String str() {
        return "replaceall";
    }

    @Override
    Val apply(Env env, Env.StackHelp stk, AST[] asts) {
        String pattern = asts[2].exec(env).getStr();
        String replacement = asts[3].exec(env).getStr();
        Frame fr = stk.track(asts[1].exec(env)).getFrame();
        boolean ignoreCase = asts[4].exec(env).getNum() == 1.0;
        for (Vec v : fr.vecs()) {
            if (v.isCategorical() || v.isString()) continue;
            throw new IllegalArgumentException("replaceall() requires a string or categorical column. Received " + fr.anyVec().get_type_str() + ". Please convert column to a string or categorical first.");
        }
        Vec[] nvs = new Vec[fr.numCols()];
        int i = 0;
        for (Vec v : fr.vecs()) {
            nvs[i] = v.isCategorical() ? this.replaceAllCategoricalCol(v, pattern, replacement, ignoreCase) : this.replaceAllStringCol(v, pattern, replacement, ignoreCase);
            ++i;
        }
        return new ValFrame(new Frame(nvs));
    }

    private Vec replaceAllCategoricalCol(Vec vec, String pattern, String replacement, boolean ignoreCase) {
        String[] doms = vec.domain();
        for (int i = 0; i < doms.length; ++i) {
            doms[i] = ignoreCase ? doms[i].toLowerCase(Locale.ENGLISH).replaceAll(pattern, replacement) : doms[i].replaceAll(pattern, replacement);
        }
        return vec.makeCopy(doms);
    }

    private Vec replaceAllStringCol(Vec vec, String pat, String rep, boolean ic) {
        final String pattern = pat;
        final String replacement = rep;
        final boolean ignoreCase = ic;
        return ((MRTask)new MRTask(){

            @Override
            public void map(Chunk chk, NewChunk newChk) {
                if (chk instanceof C0DChunk) {
                    for (int i = 0; i < chk.len(); ++i) {
                        newChk.addNA();
                    }
                } else {
                    BufferedString tmpStr = new BufferedString();
                    for (int i = 0; i < chk._len; ++i) {
                        if (chk.isNA(i)) {
                            newChk.addNA();
                            continue;
                        }
                        if (ignoreCase) {
                            newChk.addStr(chk.atStr(tmpStr, i).toString().toLowerCase(Locale.ENGLISH).replaceAll(pattern, replacement));
                            continue;
                        }
                        newChk.addStr(chk.atStr(tmpStr, i).toString().replaceAll(pattern, replacement));
                    }
                }
            }
        }.doAll(new byte[]{2}, vec)).outputFrame().anyVec();
    }
}

