/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import java.util.Arrays;
import java.util.BitSet;
import water.MRTask;
import water.fvec.C16Chunk;
import water.fvec.CStrChunk;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.rapids.AST;
import water.rapids.ASTExec;
import water.rapids.ASTId;
import water.rapids.ASTNum;
import water.rapids.ASTNumList;
import water.rapids.ASTPrim;
import water.rapids.Env;
import water.rapids.Val;
import water.rapids.ValFrame;

class ASTRowSlice
extends ASTPrim {
    ASTRowSlice() {
    }

    @Override
    public String[] args() {
        return new String[]{"ary", "rows"};
    }

    @Override
    int nargs() {
        return 3;
    }

    @Override
    public String str() {
        return "rows";
    }

    @Override
    Val apply(Env env, Env.StackHelp stk, AST[] asts) {
        Frame returningFrame;
        Frame fr = stk.track(asts[1].exec(env)).getFrame();
        long nrows = fr.numRows();
        if (asts[2] instanceof ASTNumList) {
            long[] rows;
            final ASTNumList nums = (ASTNumList)asts[2];
            Object object = rows = (Object)(nums._isList || nums.min() < 0.0 ? nums.expand8Sort() : null);
            if (rows != null && rows.length != 0) {
                if (rows[0] >= 0L) {
                    if (rows[rows.length - 1] > nrows) {
                        throw new IllegalArgumentException("Row must be an integer from 0 to " + (nrows - 1L));
                    }
                } else {
                    int i;
                    if (rows[rows.length - 1] >= 0L) {
                        throw new IllegalArgumentException("Cannot mix negative and postive row selection");
                    }
                    BitSet bs = new BitSet((int)nrows);
                    for (i = 0; i < rows.length; ++i) {
                        int idx = (int)(-rows[i] - 1L);
                        if (idx < 0 || (long)idx >= nrows) continue;
                        bs.set(idx);
                    }
                    rows = new long[(int)nrows - bs.cardinality()];
                    i = bs.nextClearBit(0);
                    int j = 0;
                    while ((long)i < nrows) {
                        rows[j++] = i;
                        i = bs.nextClearBit(i + 1);
                    }
                }
            }
            final long[] ls = rows;
            returningFrame = ((MRTask)new MRTask(){

                @Override
                public void map(Chunk[] cs, NewChunk[] ncs) {
                    long max;
                    if (nums.cnt() == 0L) {
                        return;
                    }
                    if (ls != null && ls.length == 0) {
                        return;
                    }
                    long start = cs[0].start();
                    long end = start + (long)cs[0]._len;
                    long min = ls == null ? (long)nums.min() : ls[0];
                    long l = max = ls == null ? (long)nums.max() - 1L : ls[ls.length - 1];
                    if (max >= start && min <= end) {
                        long startOffset = min > start ? min : start;
                        for (int i = (int)(startOffset - start); i < cs[0]._len; ++i) {
                            if ((ls != null || !nums.has(start + (long)i)) && (ls == null || Arrays.binarySearch(ls, start + (long)i) < 0)) continue;
                            for (int c = 0; c < cs.length; ++c) {
                                if (cs[c] instanceof CStrChunk) {
                                    ncs[c].addStr(cs[c], i);
                                    continue;
                                }
                                if (cs[c] instanceof C16Chunk) {
                                    ncs[c].addUUID(cs[c], i);
                                    continue;
                                }
                                if (cs[c].isNA(i)) {
                                    ncs[c].addNA();
                                    continue;
                                }
                                ncs[c].addNum(cs[c].atd(i));
                            }
                        }
                    }
                }
            }.doAll(fr.types(), fr)).outputFrame(fr.names(), fr.domains());
        } else if (asts[2] instanceof ASTNum) {
            long[] rows = new long[]{(long)((ASTNum)asts[2])._v.getNum()};
            returningFrame = fr.deepSlice(rows, null);
        } else if (asts[2] instanceof ASTExec || asts[2] instanceof ASTId) {
            Frame predVec = stk.track(asts[2].exec(env)).getFrame();
            if (predVec.numCols() != 1) {
                throw new IllegalArgumentException("Conditional Row Slicing Expression evaluated to " + predVec.numCols() + " columns.  Must be a boolean Vec.");
            }
            returningFrame = fr.deepSlice(predVec, null);
        } else {
            throw new IllegalArgumentException("Row slicing requires a number-list as the last argument, but found a " + asts[2].getClass());
        }
        return new ValFrame(returningFrame);
    }
}

