/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import java.util.Random;
import water.fvec.Frame;
import water.fvec.Vec;
import water.rapids.AST;
import water.rapids.ASTPrim;
import water.rapids.Env;
import water.rapids.Val;
import water.rapids.ValFrame;

class ASTRunif
extends ASTPrim {
    ASTRunif() {
    }

    @Override
    public String[] args() {
        return new String[]{"ary", "seed"};
    }

    @Override
    int nargs() {
        return 3;
    }

    @Override
    public String str() {
        return "h2o.runif";
    }

    @Override
    Val apply(Env env, Env.StackHelp stk, AST[] asts) {
        Frame fr = stk.track(asts[1].exec(env)).getFrame();
        long seed = (long)asts[2].exec(env).getNum();
        if (seed == -1L) {
            seed = new Random().nextLong();
        }
        return new ValFrame(new Frame(new String[]{"rnd"}, new Vec[]{fr.anyVec().makeRand(seed)}));
    }
}

