/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import java.util.Arrays;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.Vec;
import water.rapids.AST;
import water.rapids.ASTNumList;
import water.rapids.ASTPrim;
import water.rapids.Env;
import water.rapids.Val;
import water.rapids.ValFrame;

class ASTScale
extends ASTPrim {
    ASTScale() {
    }

    @Override
    public String[] args() {
        return new String[]{"ary", "center", "scale"};
    }

    @Override
    int nargs() {
        return 4;
    }

    @Override
    public String str() {
        return "scale";
    }

    @Override
    Val apply(Env env, Env.StackHelp stk, AST[] asts) {
        double[] mults;
        double[] means;
        Frame fr = stk.track(asts[1].exec(env)).getFrame();
        int ncols = fr.numCols();
        if (asts[2] instanceof ASTNumList) {
            means = ((ASTNumList)asts[2]).expand();
            if (means.length != ncols) {
                throw new IllegalArgumentException("Numlist must be the same length as the columns of the Frame");
            }
        } else {
            double d = asts[2].exec(env).getNum();
            if (d == 0.0) {
                means = new double[ncols];
            } else if (d == 1.0) {
                means = fr.means();
            } else {
                throw new IllegalArgumentException("Only true or false allowed");
            }
        }
        if (asts[3] instanceof ASTNumList) {
            mults = ((ASTNumList)asts[3]).expand();
            if (mults.length != ncols) {
                throw new IllegalArgumentException("Numlist must be the same length as the columns of the Frame");
            }
        } else {
            Val v = asts[3].exec(env);
            if (v instanceof ValFrame) {
                mults = ASTScale.toArray(v.getFrame().anyVec());
            } else {
                double d = v.getNum();
                if (d == 0.0) {
                    mults = new double[ncols];
                    Arrays.fill(mults, 1.0);
                } else if (d == 1.0) {
                    mults = fr.mults();
                } else {
                    throw new IllegalArgumentException("Only true or false allowed");
                }
            }
        }
        final double[] fmeans = means;
        final double[] fmults = mults;
        new MRTask(){

            @Override
            public void map(Chunk[] cs) {
                for (int i = 0; i < cs.length; ++i) {
                    for (int row = 0; row < cs[i]._len; ++row) {
                        cs[i].set(row, (cs[i].atd(row) - fmeans[i]) * fmults[i]);
                    }
                }
            }
        }.doAll(fr);
        return new ValFrame(fr);
    }

    private static double[] toArray(Vec v) {
        double[] res = new double[(int)v.length()];
        for (int i = 0; i < res.length; ++i) {
            res[i] = v.at(i);
        }
        return res;
    }
}

