/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import water.Futures;
import water.fvec.AppendableVec;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.rapids.AST;
import water.rapids.ASTPrim;
import water.rapids.Env;
import water.rapids.Val;
import water.rapids.ValFrame;

class ASTSeq
extends ASTPrim {
    ASTSeq() {
    }

    @Override
    public String[] args() {
        return new String[]{"from", "to", "by"};
    }

    @Override
    int nargs() {
        return 4;
    }

    @Override
    public String str() {
        return "seq";
    }

    @Override
    Val apply(Env env, Env.StackHelp stk, AST[] asts) {
        double from = asts[1].exec(env).getNum();
        double to = asts[2].exec(env).getNum();
        double by = asts[3].exec(env).getNum();
        double delta = to - from;
        if (delta == 0.0 && to == 0.0) {
            throw new IllegalArgumentException("Expected `to` and `from` to have nonzero difference.");
        }
        double n = delta / by;
        if (n < 0.0) {
            throw new IllegalArgumentException("wrong sign in 'by' argument");
        }
        if (n > Double.MAX_VALUE) {
            throw new IllegalArgumentException("'by' argument is much too small");
        }
        Futures fs = new Futures();
        AppendableVec av = new AppendableVec(Vec.newKey(), 3);
        NewChunk nc = new NewChunk(av, 0);
        int len = (int)n + 1;
        for (int r = 0; r < len; ++r) {
            nc.addNum(from + (double)r * by);
        }
        nc.close(0, fs);
        Vec vec = av.layout_and_close(fs);
        fs.blockForPending();
        return new ValFrame(new Frame(vec));
    }
}

