/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import water.fvec.Frame;
import water.fvec.Vec;
import water.rapids.AST;
import water.rapids.ASTPrim;
import water.rapids.Env;
import water.rapids.Val;
import water.rapids.ValFrame;

class ASTSeqLen
extends ASTPrim {
    ASTSeqLen() {
    }

    @Override
    public String[] args() {
        return new String[]{"length"};
    }

    @Override
    int nargs() {
        return 2;
    }

    @Override
    public String str() {
        return "seq_len";
    }

    @Override
    Val apply(Env env, Env.StackHelp stk, AST[] asts) {
        int len = (int)Math.ceil(asts[1].exec(env).getNum());
        if (len <= 0) {
            throw new IllegalArgumentException("Error in seq_len(" + len + "): argument must be coercible to positive integer");
        }
        return new ValFrame(new Frame(Vec.makeSeq((long)len, true)));
    }
}

