/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import java.util.Arrays;
import water.DKV;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.Vec;
import water.rapids.AST;
import water.rapids.ASTPrim;
import water.rapids.ASTStrList;
import water.rapids.Env;
import water.rapids.ValFrame;
import water.util.VecUtils;

class ASTSetDomain
extends ASTPrim {
    ASTSetDomain() {
    }

    @Override
    public String[] args() {
        return new String[]{"ary", "newDomains"};
    }

    @Override
    int nargs() {
        return 3;
    }

    @Override
    public String str() {
        return "setDomain";
    }

    @Override
    ValFrame apply(Env env, Env.StackHelp stk, AST[] asts) {
        Frame f = stk.track(asts[1].exec(env)).getFrame();
        String[] _domains = ((ASTStrList)asts[2])._strs;
        if (f.numCols() != 1) {
            throw new IllegalArgumentException("Must be a single column. Got: " + f.numCols() + " columns.");
        }
        Vec v = f.anyVec();
        if (!v.isCategorical()) {
            throw new IllegalArgumentException("Vector must be a factor column. Got: " + v.get_type_str());
        }
        if (_domains != null && _domains.length != v.domain().length) {
            VecUtils.CollectDomainFast t = new VecUtils.CollectDomainFast((int)v.max());
            t.doAll(v);
            final long[] dom = t.domain();
            if (dom.length != _domains.length) {
                throw new IllegalArgumentException("Number of replacement factors must equal current number of levels. Current number of levels: " + dom.length + " != " + _domains.length);
            }
            new MRTask(){

                @Override
                public void map(Chunk c) {
                    for (int i = 0; i < c._len; ++i) {
                        if (c.isNA(i)) continue;
                        long num = Arrays.binarySearch(dom, c.at8(i));
                        if (num < 0L) {
                            throw new IllegalArgumentException("Could not find the categorical value!");
                        }
                        c.set(i, num);
                    }
                }
            }.doAll(v);
        }
        v.setDomain(_domains);
        DKV.put(v);
        return new ValFrame(f);
    }
}

