/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import java.util.Set;
import org.joda.time.DateTimeZone;
import water.MRTask;
import water.parser.ParseTime;
import water.rapids.AST;
import water.rapids.ASTPrim;
import water.rapids.Env;
import water.rapids.ValNum;

class ASTSetTimeZone
extends ASTPrim {
    ASTSetTimeZone() {
    }

    @Override
    public String[] args() {
        return new String[]{"tz"};
    }

    @Override
    int nargs() {
        return 2;
    }

    @Override
    public String str() {
        return "setTimeZone";
    }

    @Override
    ValNum apply(Env env, Env.StackHelp stk, AST[] asts) {
        final String tz = asts[1].exec(env).getStr();
        Set idSet = DateTimeZone.getAvailableIDs();
        if (!idSet.contains(tz)) {
            throw new IllegalArgumentException("Unacceptable timezone " + tz + " given.  For a list of acceptable names, use listTimezone().");
        }
        new MRTask(){

            @Override
            public void setupLocal() {
                ParseTime.setTimezone(tz);
            }
        }.doAllNodes();
        return new ValNum(Double.NaN);
    }
}

