/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import java.util.Random;
import water.fvec.Frame;
import water.fvec.Vec;
import water.rapids.AST;
import water.rapids.ASTKFold;
import water.rapids.ASTPrim;
import water.rapids.Env;
import water.rapids.ValFrame;

class ASTStratifiedKFold
extends ASTPrim {
    ASTStratifiedKFold() {
    }

    @Override
    public String[] args() {
        return new String[]{"ary", "nfolds", "seed"};
    }

    @Override
    public int nargs() {
        return 4;
    }

    @Override
    public String str() {
        return "stratified_kfold_column";
    }

    @Override
    ValFrame apply(Env env, Env.StackHelp stk, AST[] asts) {
        Vec foldVec = stk.track(asts[1].exec(env)).getFrame().anyVec().makeZero();
        int nfolds = (int)asts[2].exec(env).getNum();
        long seed = (long)asts[3].exec(env).getNum();
        return new ValFrame(new Frame(ASTKFold.stratifiedKFoldColumn(foldVec, nfolds, seed == -1L ? new Random().nextLong() : seed)));
    }
}

