/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import water.Key;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.Vec;
import water.rapids.AST;
import water.rapids.ASTPrim;
import water.rapids.Env;
import water.rapids.Val;
import water.rapids.ValFrame;
import water.rapids.ValNum;
import water.util.ArrayUtils;

class ASTVariance
extends ASTPrim {
    ASTVariance() {
    }

    @Override
    public String[] args() {
        return new String[]{"ary", "x", "y", "use"};
    }

    @Override
    int nargs() {
        return 4;
    }

    @Override
    public String str() {
        return "var";
    }

    @Override
    Val apply(Env env, Env.StackHelp stk, AST[] asts) {
        Mode mode;
        String use;
        Frame frx = stk.track(asts[1].exec(env)).getFrame();
        Frame fry = stk.track(asts[2].exec(env)).getFrame();
        if (frx.numRows() != fry.numRows()) {
            throw new IllegalArgumentException("Frames must have the same number of rows, found " + frx.numRows() + " and " + fry.numRows());
        }
        if (frx.numCols() != fry.numCols()) {
            throw new IllegalArgumentException("Frames must have the same number of columns, found " + frx.numCols() + " and " + fry.numCols());
        }
        String string = use = stk.track(asts[3].exec(env)).getStr();
        int n = -1;
        switch (string.hashCode()) {
            case 401590963: {
                if (!string.equals("everything")) break;
                n = 0;
                break;
            }
            case -913287373: {
                if (!string.equals("all.obs")) break;
                n = 1;
                break;
            }
            case -411139381: {
                if (!string.equals("complete.obs")) break;
                n = 2;
            }
        }
        switch (n) {
            case 0: {
                mode = Mode.Everything;
                break;
            }
            case 1: {
                mode = Mode.AllObs;
                break;
            }
            case 2: {
                mode = Mode.CompleteObs;
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown use mode, found: " + use);
            }
        }
        return frx.numRows() == 1L ? this.scalar(frx, fry, mode) : this.array(frx, fry, mode);
    }

    private ValNum scalar(Frame frx, Frame fry, Mode mode) {
        Vec[] vecxs = frx.vecs();
        Vec[] vecys = fry.vecs();
        double xmean = 0.0;
        double ymean = 0.0;
        double ncols = frx.numCols();
        for (Vec v : vecxs) {
            xmean += v.at(0L);
        }
        for (Vec v : vecys) {
            ymean += v.at(0L);
        }
        xmean /= ncols;
        ymean /= ncols;
        double ss = 0.0;
        int r = 0;
        while ((double)r < ncols) {
            ss += (vecxs[r].at(0L) - xmean) * (vecys[r].at(0L) - ymean);
            ++r;
        }
        if (Double.isNaN(ss) && mode.equals((Object)Mode.AllObs)) {
            throw new IllegalArgumentException("Mode is 'all.obs' but NAs are present");
        }
        return new ValNum(ss / (ncols - 1.0));
    }

    private Val array(Frame frx, Frame fry, Mode mode) {
        Vec[] vecxs = frx.vecs();
        int ncolx = vecxs.length;
        Vec[] vecys = fry.vecs();
        int ncoly = vecys.length;
        double[] ymeans = new double[ncoly];
        for (int y = 0; y < ncoly; ++y) {
            ymeans[y] = vecys[y].mean();
        }
        CoVarTask[] cvts = new CoVarTask[ncolx];
        for (int x = 0; x < ncolx; ++x) {
            cvts[x] = (CoVarTask)new CoVarTask(vecxs[x].mean(), ymeans).dfork(new Frame(vecxs[x]).add(fry));
        }
        if (ncolx == 1 && ncoly == 1) {
            return new ValNum(((CoVarTask)cvts[0].getResult())._covs[0] / (double)(frx.numRows() - 1L));
        }
        Vec[] res = new Vec[ncolx];
        Key<Vec>[] keys = Vec.VectorGroup.VG_LEN1.addVecs(ncolx);
        for (int x = 0; x < ncolx; ++x) {
            res[x] = Vec.makeVec(ArrayUtils.div(((CoVarTask)cvts[x].getResult())._covs, (double)(frx.numRows() - 1L)), keys[x]);
        }
        return new ValFrame(new Frame(frx._names, res));
    }

    static double getVar(Vec v) {
        double m = v.mean();
        CoVarTask t = (CoVarTask)new CoVarTask(m, new double[]{m}).doAll(new Frame(v, v));
        return t._covs[0] / (double)(v.length() - 1L);
    }

    private static class CoVarTask
    extends MRTask<CoVarTask> {
        double[] _covs;
        final double _xmean;
        final double[] _ymeans;

        CoVarTask(double xmean, double[] ymeans) {
            this._xmean = xmean;
            this._ymeans = ymeans;
        }

        @Override
        public void map(Chunk[] cs) {
            int ncols = cs.length - 1;
            Chunk cx = cs[0];
            int len = cx._len;
            this._covs = new double[ncols];
            for (int y = 0; y < ncols; ++y) {
                double sum = 0.0;
                Chunk cy = cs[y + 1];
                double ymean = this._ymeans[y];
                for (int row = 0; row < len; ++row) {
                    sum += (cx.atd(row) - this._xmean) * (cy.atd(row) - ymean);
                }
                this._covs[y] = sum;
            }
        }

        @Override
        public void reduce(CoVarTask cvt) {
            ArrayUtils.add(this._covs, cvt._covs);
        }
    }

    private static enum Mode {
        Everything,
        AllObs,
        CompleteObs;

    }
}

