/*
 * Decompiled with CFR 0.152.
 */
package water.serial;

import com.google.common.io.ByteStreams;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import water.AutoBuffer;
import water.DKV;
import water.H2O;
import water.Keyed;
import water.MemoryManager;
import water.persist.Persist;
import water.serial.AutoBufferWithClassNames;
import water.serial.BinarySerializer;
import water.util.FileUtils;

public class KeyedBinarySerializer
extends BinarySerializer<Keyed, URI> {
    final boolean dkvPutAfterLoad;
    final boolean overrideInDkv;
    final boolean overrideFile;

    public KeyedBinarySerializer() {
        this(true, true, true);
    }

    public KeyedBinarySerializer(boolean dkvPutAfterLoad, boolean overrideDkv, boolean overrideFile) {
        this.dkvPutAfterLoad = dkvPutAfterLoad;
        this.overrideInDkv = overrideDkv;
        this.overrideFile = overrideFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(Keyed k, URI uri) throws IOException {
        assert (k != null) : "Object to save cannot be null!";
        Persist persistLayer = H2O.getPM().getPersistForURI(uri);
        OutputStream fo = null;
        AutoBuffer ab = null;
        ab = this.ab4write();
        k.getBinarySerializer().save(k, this.saveHeader(k, ab));
        try {
            fo = persistLayer.create(uri.toString(), true);
            fo.write(ab.buf());
        }
        catch (Throwable throwable) {
            FileUtils.close(fo);
            throw throwable;
        }
        FileUtils.close(fo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Keyed load(URI uri) throws IOException {
        Persist persistLayer = H2O.getPM().getPersistForURI(uri);
        InputStream fi = null;
        AutoBuffer ab = null;
        Persist.PersistEntry[] entries = persistLayer.list(uri.toString());
        if (entries.length == 0) {
            throw new FileNotFoundException(uri.toString());
        }
        if (entries.length > 1) {
            throw new IOException("Found more files matching given URI");
        }
        Persist.PersistEntry entry = entries[0];
        byte[] buf = MemoryManager.malloc1((int)entry._size);
        try {
            fi = persistLayer.open(uri.toString());
            ByteStreams.readFully((InputStream)fi, (byte[])buf);
        }
        catch (Throwable throwable) {
            FileUtils.close(fi);
            throw throwable;
        }
        FileUtils.close(fi);
        ab = this.ab4read(buf);
        Keyed k = (Keyed)this.loadHeader(ab);
        k.getBinarySerializer().load(k, ab);
        if (this.dkvPutAfterLoad && k._key != null) {
            if (this.overrideInDkv) {
                DKV.put(k._key, k);
            } else if (DKV.get(k._key) != null) {
                throw new IOException("The object with " + k._key + " key already exists in DKV!");
            }
        }
        return k;
    }

    @Override
    public Keyed load(Keyed k, URI f) throws IOException {
        throw new UnsupportedOperationException();
    }

    private AutoBuffer ab4read(byte[] buf) {
        return new AutoBufferWithClassNames(buf);
    }

    private AutoBuffer ab4write() {
        return new AutoBufferWithClassNames();
    }
}

