/*
 * Decompiled with CFR 0.152.
 */
package water.util;

import sun.misc.Unsafe;
import water.nbhm.UtilUnsafe;
import water.util.SB;

public abstract class AtomicUtils {

    public static class IntArray {
        private static final Unsafe _unsafe = UtilUnsafe.getUnsafe();
        private static final int _Ibase = _unsafe.arrayBaseOffset(int[].class);
        private static final int _Iscale = _unsafe.arrayIndexScale(int[].class);

        private static long rawIndex(int[] ary, int idx) {
            assert (idx >= 0 && idx < ary.length);
            return _Ibase + idx * _Iscale;
        }

        public static void incr(int[] is, int i) {
            IntArray.add(is, i, 1);
        }

        public static void add(int[] is, int i, int x) {
            long adr = IntArray.rawIndex(is, i);
            int old = is[i];
            while (!_unsafe.compareAndSwapInt(is, adr, old, old + x)) {
                old = is[i];
            }
        }
    }

    public static class LongArray {
        private static final Unsafe _unsafe = UtilUnsafe.getUnsafe();
        private static final int _Lbase = _unsafe.arrayBaseOffset(long[].class);
        private static final int _Lscale = _unsafe.arrayIndexScale(long[].class);

        private static long rawIndex(long[] ary, int idx) {
            assert (idx >= 0 && idx < ary.length);
            return _Lbase + idx * _Lscale;
        }

        public static void incr(long[] ls, int i) {
            LongArray.add(ls, i, 1L);
        }

        public static void add(long[] ls, int i, long x) {
            long adr = LongArray.rawIndex(ls, i);
            long old = ls[i];
            while (!_unsafe.compareAndSwapLong(ls, adr, old, old + x)) {
                old = ls[i];
            }
        }
    }

    public static class DoubleArray {
        private static final Unsafe _unsafe = UtilUnsafe.getUnsafe();
        private static final int _Dbase = _unsafe.arrayBaseOffset(double[].class);
        private static final int _Dscale = _unsafe.arrayIndexScale(double[].class);

        private static long rawIndex(double[] ary, int idx) {
            assert (idx >= 0 && idx < ary.length);
            return _Dbase + idx * _Dscale;
        }

        public static boolean CAS(double[] ds, int i, double old, double newd) {
            return _unsafe.compareAndSwapLong(ds, DoubleArray.rawIndex(ds, i), Double.doubleToRawLongBits(old), Double.doubleToRawLongBits(newd));
        }

        public static void add(double[] ds, int i, double y) {
            double old;
            while (!DoubleArray.CAS(ds, i, old = ds[i], old + y)) {
            }
        }
    }

    public static abstract class FloatArray {
        private static final Unsafe _unsafe = UtilUnsafe.getUnsafe();
        private static final int _Fbase = _unsafe.arrayBaseOffset(float[].class);
        private static final int _Fscale = _unsafe.arrayIndexScale(float[].class);

        private static long rawIndex(float[] ary, int idx) {
            assert (idx >= 0 && idx < ary.length);
            return _Fbase + idx * _Fscale;
        }

        public static void setMin(float[] fs, int i, float min) {
            float old = fs[i];
            while (min < old && !_unsafe.compareAndSwapInt(fs, FloatArray.rawIndex(fs, i), Float.floatToRawIntBits(old), Float.floatToRawIntBits(min))) {
                old = fs[i];
            }
        }

        public static void setMax(float[] fs, int i, float max) {
            float old = fs[i];
            while (max > old && !_unsafe.compareAndSwapInt(fs, FloatArray.rawIndex(fs, i), Float.floatToRawIntBits(old), Float.floatToRawIntBits(max))) {
                old = fs[i];
            }
        }

        public static void add(float[] ds, int i, float y) {
            long adr = FloatArray.rawIndex(ds, i);
            float old = ds[i];
            while (!_unsafe.compareAndSwapInt(ds, adr, Float.floatToRawIntBits(old), Float.floatToRawIntBits(old + y))) {
                old = ds[i];
            }
        }

        public static String toString(float[] fs) {
            SB sb = new SB();
            sb.p('[');
            for (float f : fs) {
                sb.p(f == Float.MAX_VALUE ? "max" : (f == -3.4028235E38f ? "min" : Float.toString(f))).p(',');
            }
            return sb.p(']').toString();
        }
    }
}

