/*
 * Decompiled with CFR 0.152.
 */
package water.util;

import water.AutoBuffer;
import water.H2O;
import water.Iced;
import water.util.SB;

public class IcedBitSet
extends Iced {
    private byte[] _val;
    private int _byteoff;
    private int _nbits;
    private int _bitoff;

    public IcedBitSet(int nbits) {
        this(nbits, 0);
    }

    public IcedBitSet(int nbits, int bitoff) {
        if (bitoff + nbits <= 32) {
            bitoff = 0;
            nbits = 32;
        }
        this.fill(nbits <= 0 ? null : new byte[IcedBitSet.bytes(nbits)], 0, nbits, bitoff);
    }

    public void fill(byte[] v, int byteoff, int nbits, int bitoff) {
        if (nbits < 0) {
            throw new NegativeArraySizeException("nbits < 0: " + nbits);
        }
        if (byteoff < 0) {
            throw new IndexOutOfBoundsException("byteoff < 0: " + byteoff);
        }
        if (bitoff < 0) {
            throw new IndexOutOfBoundsException("bitoff < 0: " + bitoff);
        }
        assert (v == null || byteoff + (nbits - 1 >> 3) + 1 <= v.length);
        this._val = v;
        this._nbits = nbits;
        this._bitoff = bitoff;
        this._byteoff = byteoff;
    }

    public boolean contains(int idx) {
        if (idx < 0) {
            throw new IndexOutOfBoundsException("idx < 0: " + idx);
        }
        return (idx -= this._bitoff) >= 0 && idx < this._nbits && (this._val[this._byteoff + (idx >> 3)] & 1 << (idx & 7)) != 0;
    }

    public void set(int idx) {
        if ((idx -= this._bitoff) < 0 || idx >= this._nbits) {
            throw new IndexOutOfBoundsException("Must have " + this._bitoff + " <= idx <= " + (this._bitoff + this._nbits - 1) + ": " + idx);
        }
        if (this._byteoff != 0) {
            throw H2O.fail();
        }
        int n = idx >> 3;
        this._val[n] = (byte)(this._val[n] | 1 << (idx & 7));
    }

    public void clear(int idx) {
        if ((idx -= this._bitoff) < 0 || idx >= this._nbits) {
            throw new IndexOutOfBoundsException("Must have 0 <= idx <= " + Integer.toString(this._nbits - 1) + ": " + idx);
        }
        if (this._byteoff != 0) {
            throw H2O.fail();
        }
        int n = idx >> 3;
        this._val[n] = (byte)(this._val[n] & ~(1 << (idx & 7)));
    }

    public int cardinality() {
        int nbits = 0;
        int bytes = this.numBytes();
        if (this._byteoff != 0) {
            throw H2O.fail();
        }
        for (int i = 0; i < bytes; ++i) {
            nbits += Integer.bitCount(this._val[i]);
        }
        return nbits;
    }

    public int size() {
        return this._nbits;
    }

    private static int bytes(int nbits) {
        return (nbits - 1 >> 3) + 1;
    }

    public int numBytes() {
        return IcedBitSet.bytes(this._nbits);
    }

    public int max() {
        return this._bitoff + this._nbits;
    }

    public void compress2(AutoBuffer ab) {
        assert (this.max() <= 32);
        assert (this._byteoff == 0);
        assert (this._val.length == 4);
        ab.putA1(this._val, 4);
    }

    public void fill2(byte[] bits, AutoBuffer ab) {
        this.fill(bits, ab.position(), 32, 0);
        ab.skip(4);
    }

    public void compress3(AutoBuffer ab) {
        assert (this.max() > 32);
        assert (this._byteoff == 0);
        assert (this._val.length == this.numBytes());
        ab.put2((char)this._bitoff);
        ab.put2((char)this._val.length);
        ab.putA1(this._val, this._val.length);
    }

    public void fill3(byte[] bits, AutoBuffer ab) {
        char bitoff = ab.get2();
        char nbytes = ab.get2();
        this.fill(bits, ab.position(), nbytes << 3, bitoff);
        ab.skip(nbytes);
    }

    public String toString() {
        return this.toString(new SB()).toString();
    }

    public SB toString(SB sb) {
        sb.p("{");
        if (this._bitoff > 0) {
            sb.p("...").p(this._bitoff).p(" 0-bits... ");
        }
        int bytes = IcedBitSet.bytes(this._nbits);
        for (int i = 0; i < bytes; ++i) {
            if (i > 0 && this._bitoff + 8 * i < this.size()) {
                sb.p(' ');
            }
            for (int j = 0; j < 8 && this._bitoff + 8 * i + j < this.size(); ++j) {
                sb.p(this._val[this._byteoff + i] >> j & 1);
            }
        }
        return sb.p("}");
    }

    public String toStrArray() {
        StringBuilder sb = new StringBuilder();
        sb.append("{").append(this._val[this._byteoff]);
        int bytes = IcedBitSet.bytes(this._nbits);
        for (int i = 1; i < bytes; ++i) {
            sb.append(", ").append(this._val[this._byteoff + i]);
        }
        sb.append("}");
        return sb.toString();
    }

    public SB toJava(SB sb, String varname, int col, String colname) {
        return sb.p("!GenModel.bitSetContains(").p(varname).p(", ").p(this._bitoff).p(", (int) data[").p(col).p(" /* ").p(colname).p(" */").p("])");
    }
}

