/*
 * Decompiled with CFR 0.152.
 */
package water.util;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import water.AutoBuffer;
import water.Freezable;
import water.H2O;
import water.Iced;

public abstract class IcedHashMapBase<K, V>
extends Iced
implements Map<K, V>,
Cloneable,
Serializable {
    protected abstract Map<K, V> map();

    @Override
    public int size() {
        return this.map().size();
    }

    @Override
    public boolean isEmpty() {
        return this.map().isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map().containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map().containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.map().get(key);
    }

    @Override
    public V put(K key, V value) {
        return this.map().put(key, value);
    }

    @Override
    public V remove(Object key) {
        return this.map().remove(key);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.map().putAll(m);
    }

    @Override
    public void clear() {
        this.map().clear();
    }

    @Override
    public Set<K> keySet() {
        return this.map().keySet();
    }

    @Override
    public Collection<V> values() {
        return this.map().values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.map().entrySet();
    }

    @Override
    public boolean equals(Object o) {
        return this.map().equals(o);
    }

    @Override
    public int hashCode() {
        return this.map().hashCode();
    }

    @Override
    public AutoBuffer write_impl(AutoBuffer ab) {
        int mode;
        if (this.map().size() == 0) {
            return ab.put1(0);
        }
        Map.Entry<K, V> entry = this.map().entrySet().iterator().next();
        K key = entry.getKey();
        V val = entry.getValue();
        assert (key != null && val != null);
        if (key instanceof String) {
            if (val instanceof String) {
                mode = 1;
            } else {
                assert (val instanceof Iced);
                mode = 2;
            }
        } else {
            assert (key instanceof Iced);
            if (val instanceof String) {
                mode = 3;
            } else {
                assert (val instanceof Iced);
                mode = 4;
            }
        }
        ab.put1(mode);
        this.writeMap(ab, mode);
        return mode == 1 || mode == 2 ? ab.putStr(null) : ab.put(null);
    }

    protected abstract Map<K, V> init();

    protected void writeMap(AutoBuffer ab, int mode) {
        for (Map.Entry<K, V> e : this.map().entrySet()) {
            K key = e.getKey();
            assert (key != null);
            V val = e.getValue();
            assert (val != null);
            if (mode == 1 || mode == 2) {
                ab.putStr((String)key);
            } else {
                ab.put((Iced)key);
            }
            if (mode == 1 || mode == 3) {
                ab.putStr((String)val);
                continue;
            }
            ab.put((Iced)val);
        }
    }

    @Override
    public IcedHashMapBase read_impl(AutoBuffer ab) {
        String key;
        assert (this.map() == null);
        Map<String, String> map = this.init();
        byte mode = ab.get1();
        if (mode == 0) {
            return this;
        }
        while ((key = mode == 1 || mode == 2 ? ab.getStr() : ab.get()) != null) {
            String val = mode == 1 || mode == 3 ? ab.getStr() : ab.get();
            map.put(key, val);
        }
        return this;
    }

    @Override
    public AutoBuffer writeJSON_impl(AutoBuffer ab) {
        boolean first = true;
        for (Map.Entry<K, V> entry : this.map().entrySet()) {
            K key = entry.getKey();
            V value = entry.getValue();
            assert (entry.getKey() instanceof String);
            assert (value instanceof String || value instanceof String[] || value instanceof Integer || value instanceof Freezable || value instanceof Freezable[]);
            if (first) {
                first = false;
            } else {
                ab.put1(44).put1(32);
            }
            ab.putJSONName((String)key);
            ab.put1(58);
            if (value instanceof String) {
                ab.putJSONName((String)value);
                continue;
            }
            if (value instanceof String[]) {
                ab.putJSONAStr((String[])value);
                continue;
            }
            if (value instanceof Integer) {
                ab.putJSON4((Integer)value);
                continue;
            }
            if (value instanceof Freezable) {
                ab.putJSON((Freezable)value);
                continue;
            }
            if (!(value instanceof Freezable[])) continue;
            ab.putJSONA((Freezable[])value);
        }
        return ab;
    }

    @Override
    public IcedHashMapBase<K, V> readJSON_impl(AutoBuffer ab) {
        throw H2O.fail();
    }
}

