/*
 * Decompiled with CFR 0.152.
 */
package hex;

import hex.AUC2;
import hex.ConfusionMatrix;
import hex.GLMMetrics;
import hex.GainsLift;
import hex.Model;
import hex.ModelMetricsBinomial;
import hex.ModelMetricsMultinomial;
import water.fvec.Frame;

public class ModelMetricsBinomialGLM
extends ModelMetricsBinomial
implements GLMMetrics {
    public final long _nullDegressOfFreedom;
    public final long _residualDegressOfFreedom;
    public final double _resDev;
    public final double _nullDev;
    public final double _AIC;

    public ModelMetricsBinomialGLM(Model model, Frame frame, double mse, String[] domain, double sigma, AUC2 auc, double logloss, double resDev, double nullDev, double aic, long nDof, long rDof, GainsLift gainsLift) {
        super(model, frame, mse, domain, sigma, auc, logloss, gainsLift);
        this._resDev = resDev;
        this._nullDev = nullDev;
        this._AIC = aic;
        this._nullDegressOfFreedom = nDof;
        this._residualDegressOfFreedom = rDof;
    }

    @Override
    public double residual_deviance() {
        return this._resDev;
    }

    @Override
    public double null_deviance() {
        return this._nullDev;
    }

    @Override
    public long residual_degrees_of_freedom() {
        return this._residualDegressOfFreedom;
    }

    @Override
    public long null_degrees_of_freedom() {
        return this._nullDegressOfFreedom;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append(" null DOF: " + (float)this._nullDegressOfFreedom + "\n");
        sb.append(" residual DOF: " + (float)this._residualDegressOfFreedom + "\n");
        sb.append(" null deviance: " + (float)this._nullDev + "\n");
        sb.append(" residual deviance: " + (float)this._resDev + "\n");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof ModelMetricsBinomialGLM)) {
            return false;
        }
        ModelMetricsBinomialGLM mm = (ModelMetricsBinomialGLM)o;
        return this._residualDegressOfFreedom == mm._residualDegressOfFreedom && this._nullDegressOfFreedom == mm._nullDegressOfFreedom && Math.abs(this._resDev - mm._resDev) < 1.0E-8;
    }

    public static class ModelMetricsMultinomialGLM
    extends ModelMetricsMultinomial
    implements GLMMetrics {
        public final long _nullDegressOfFreedom;
        public final long _residualDegressOfFreedom;
        public final double _resDev;
        public final double _nullDev;
        public final double _AIC;

        public ModelMetricsMultinomialGLM(Model model, Frame frame, double mse, String[] domain, double sigma, ConfusionMatrix cm, float[] hr, double logloss, double resDev, double nullDev, double aic, long nDof, long rDof) {
            super(model, frame, mse, domain, sigma, cm, hr, logloss);
            this._resDev = resDev;
            this._nullDev = nullDev;
            this._AIC = aic;
            this._nullDegressOfFreedom = nDof;
            this._residualDegressOfFreedom = rDof;
        }

        @Override
        public double residual_deviance() {
            return this._resDev;
        }

        @Override
        public double null_deviance() {
            return this._nullDev;
        }

        @Override
        public long residual_degrees_of_freedom() {
            return this._residualDegressOfFreedom;
        }

        @Override
        public long null_degrees_of_freedom() {
            return this._nullDegressOfFreedom;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(super.toString());
            sb.append(" null DOF: " + (float)this._nullDegressOfFreedom + "\n");
            sb.append(" residual DOF: " + (float)this._residualDegressOfFreedom + "\n");
            sb.append(" null deviance: " + (float)this._nullDev + "\n");
            sb.append(" residual deviance: " + (float)this._resDev + "\n");
            return sb.toString();
        }

        public boolean equals(Object o) {
            if (!(o instanceof ModelMetricsMultinomialGLM)) {
                return false;
            }
            ModelMetricsMultinomialGLM mm = (ModelMetricsMultinomialGLM)o;
            return this._residualDegressOfFreedom == mm._residualDegressOfFreedom && this._nullDegressOfFreedom == mm._nullDegressOfFreedom && Math.abs(this._resDev - mm._resDev) < 1.0E-8;
        }
    }
}

