/*
 * Decompiled with CFR 0.152.
 */
package hex.grid;

import hex.Model;
import hex.ModelCategory;
import hex.ModelMetrics;
import hex.ScoringInfo;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import water.AutoBuffer;
import water.DKV;
import water.Futures;
import water.H2O;
import water.Iced;
import water.Key;
import water.Keyed;
import water.Lockable;
import water.api.KeyV3;
import water.fvec.Frame;
import water.util.ArrayUtils;
import water.util.IcedHashMap;
import water.util.IcedLong;
import water.util.Log;
import water.util.PojoUtils;
import water.util.StringUtils;
import water.util.TwoDimTable;

public class Grid<MP extends Model.Parameters>
extends Lockable<Grid<MP>> {
    public static final Grid GRID_PROTO = new Grid<Object>(null, null, null, null);
    private final IcedHashMap<IcedLong, Key<Model>> _models = new IcedHashMap();
    private final MP _params;
    private MP[] _failed_params;
    private String[] _failure_details;
    private String[] _failure_stack_traces;
    private String[][] _failed_raw_params;
    private final String[] _hyper_names;
    private final PojoUtils.FieldNaming _field_naming_strategy;
    private ScoringInfo[] _scoring_infos = null;

    protected Grid(Key key, MP params, String[] hyperNames, PojoUtils.FieldNaming fieldNaming) {
        super(key);
        this._params = params != null ? (Model.Parameters)((Iced)params).clone() : null;
        this._hyper_names = hyperNames;
        Class<?> paramsClass = params != null ? params.getClass() : null;
        this._failed_params = paramsClass != null ? (Model.Parameters[])Array.newInstance(paramsClass, 0) : null;
        this._failure_details = new String[0];
        this._failed_raw_params = new String[0][];
        this._failure_stack_traces = new String[0];
        this._field_naming_strategy = fieldNaming;
    }

    public String getModelName() {
        return ((Model.Parameters)this._params).algoName();
    }

    public ScoringInfo[] getScoringInfos() {
        return this._scoring_infos;
    }

    public void setScoringInfos(ScoringInfo[] scoring_infos) {
        this._scoring_infos = scoring_infos;
    }

    public Frame getTrainingFrame() {
        return ((Model.Parameters)this._params).train();
    }

    public Model getModel(MP params) {
        Key<Model> mKey = this.getModelKey(params);
        return mKey != null ? mKey.get() : null;
    }

    public Key<Model> getModelKey(MP params) {
        long checksum = ((Model.Parameters)params).checksum();
        return this.getModelKey(checksum);
    }

    Key<Model> getModelKey(long paramsChecksum) {
        Key mKey = (Key)this._models.get(IcedLong.valueOf(paramsChecksum));
        return mKey;
    }

    synchronized Key<Model> putModel(long checksum, Key<Model> modelKey) {
        return this._models.put(IcedLong.valueOf(checksum), modelKey);
    }

    private void appendFailedModelParameters(MP params, String[] rawParams, String failureDetails, String stackTrace) {
        assert (rawParams != null) : "API has to always pass rawParams";
        MP[] a = this._failed_params;
        Model.Parameters[] na = (Model.Parameters[])Arrays.copyOf(a, a.length + 1);
        na[a.length] = params;
        this._failed_params = na;
        String[] m = this._failure_details;
        String[] nm = Arrays.copyOf(m, m.length + 1);
        nm[m.length] = failureDetails;
        this._failure_details = nm;
        String[][] rp = this._failed_raw_params;
        String[][] nrp = (String[][])Arrays.copyOf(rp, rp.length + 1);
        nrp[rp.length] = rawParams;
        this._failed_raw_params = nrp;
        String[] st = this._failure_stack_traces;
        String[] nst = Arrays.copyOf(st, st.length + 1);
        nst[st.length] = stackTrace;
        this._failure_stack_traces = nst;
    }

    void appendFailedModelParameters(MP params, Exception e) {
        assert (params != null) : "Model parameters should be always != null !";
        String[] rawParams = ArrayUtils.toString(this.getHyperValues(params));
        this.appendFailedModelParameters(params, rawParams, e.getMessage(), StringUtils.toString(e));
    }

    void appendFailedModelParameters(Object[] rawParams, Exception e) {
        assert (rawParams != null) : "Raw parameters should be always != null !";
        this.appendFailedModelParameters(null, ArrayUtils.toString(rawParams), e.getMessage(), StringUtils.toString(e));
    }

    public Key<Model>[] getModelKeys() {
        return this._models.values().toArray(new Key[this._models.size()]);
    }

    public Model[] getModels() {
        Collection modelKeys = this._models.values();
        Model[] models = new Model[modelKeys.size()];
        int i = 0;
        for (Key mKey : modelKeys) {
            models[i] = mKey != null ? (Model)mKey.get() : null;
            ++i;
        }
        return models;
    }

    public int getModelCount() {
        return this._models.size();
    }

    public int getFailureCount() {
        return this._failed_params.length;
    }

    public Model.Parameters[] getFailedParameters() {
        return this._failed_params;
    }

    public String[] getFailureDetails() {
        return this._failure_details;
    }

    public String[] getFailureStackTraces() {
        return this._failure_stack_traces;
    }

    public String[][] getFailedRawParameters() {
        return this._failed_raw_params;
    }

    public Object[] getHyperValues(MP parms) {
        Object[] result = new Object[this._hyper_names.length];
        for (int i = 0; i < this._hyper_names.length; ++i) {
            result[i] = PojoUtils.getFieldValue(parms, this._hyper_names[i], this._field_naming_strategy);
        }
        return result;
    }

    public String[] getHyperNames() {
        return this._hyper_names;
    }

    @Override
    protected Futures remove_impl(Futures fs) {
        for (Key k : this._models.values()) {
            k.remove(fs);
        }
        this._models.clear();
        return fs;
    }

    @Override
    protected AutoBuffer writeAll_impl(AutoBuffer ab) {
        for (Key k : this._models.values()) {
            ab.putKey(k);
        }
        return super.writeAll_impl(ab);
    }

    @Override
    protected Keyed readAll_impl(AutoBuffer ab, Futures fs) {
        throw H2O.unimpl();
    }

    @Override
    protected long checksum_impl() {
        throw H2O.unimpl();
    }

    @Override
    public Class<KeyV3.GridKeyV3> makeSchema() {
        return KeyV3.GridKeyV3.class;
    }

    public TwoDimTable createSummaryTable(Key<Model>[] model_ids, String sort_by, boolean decreasing) {
        if (this._hyper_names == null || model_ids == null || model_ids.length == 0) {
            return null;
        }
        int extra_len = sort_by != null ? 2 : 1;
        Object[] colTypes = new String[this._hyper_names.length + extra_len];
        Arrays.fill(colTypes, "string");
        Object[] colFormats = new String[this._hyper_names.length + extra_len];
        Arrays.fill(colFormats, "%s");
        String[] colNames = Arrays.copyOf(this._hyper_names, this._hyper_names.length + extra_len);
        colNames[this._hyper_names.length] = "model_ids";
        if (sort_by != null) {
            colNames[this._hyper_names.length + 1] = sort_by;
        }
        TwoDimTable table = new TwoDimTable("Hyper-Parameter Search Summary", sort_by != null ? "ordered by " + (decreasing ? "decreasing " : "increasing ") + sort_by : null, new String[this._models.size()], colNames, (String[])colTypes, (String[])colFormats, "");
        int i = 0;
        for (Key<Model> km : model_ids) {
            int j;
            Model m = (Model)DKV.getGet(km);
            Object parms = m._parms;
            for (j = 0; j < this._hyper_names.length; ++j) {
                table.set(i, j, PojoUtils.getFieldValue(parms, this._hyper_names[j], this._field_naming_strategy));
            }
            table.set(i, j, km.toString());
            if (sort_by != null) {
                table.set(i, j + 1, ModelMetrics.getMetricFromModel(km, sort_by));
            }
            ++i;
        }
        Log.info(table);
        return table;
    }

    public TwoDimTable createScoringHistoryTable() {
        Model m;
        if (0 == this._models.values().size()) {
            return ScoringInfo.createScoringHistoryTable(this._scoring_infos, false, false, ModelCategory.Binomial, false);
        }
        Key k = null;
        Iterator i$ = this._models.values().iterator();
        if (i$.hasNext()) {
            Key foo;
            k = foo = (Key)i$.next();
        }
        if (null == (m = (Model)k.get())) {
            Log.warn("Cannot create grid scoring history table; Model has been removed: " + k);
            return ScoringInfo.createScoringHistoryTable(this._scoring_infos, false, false, ModelCategory.Binomial, false);
        }
        ScoringInfo scoring_info = this._scoring_infos != null && this._scoring_infos.length > 0 ? this._scoring_infos[0] : null;
        return ScoringInfo.createScoringHistoryTable(this._scoring_infos, scoring_info != null ? scoring_info.validation : false, scoring_info != null ? scoring_info.cross_validation : false, ((Model.Output)m._output).getModelCategory(), scoring_info != null ? scoring_info.is_autoencoder : false);
    }
}

