/*
 * Decompiled with CFR 0.152.
 */
package hex.schemas;

import hex.Model;
import hex.ModelBuilder;
import hex.ModelCategory;
import java.util.Properties;
import water.AutoBuffer;
import water.H2O;
import water.Job;
import water.api.API;
import water.api.JobV3;
import water.api.KeyV3;
import water.api.ModelParametersSchema;
import water.api.RequestSchema;
import water.api.Schema;
import water.api.SpecifiesHttpResponseCode;
import water.api.ValidationMessageBase;
import water.api.ValidationMessageV3;
import water.util.IcedSortedHashMap;
import water.util.ReflectionUtils;

public class ModelBuilderSchema<B extends ModelBuilder, S extends ModelBuilderSchema<B, S, P>, P extends ModelParametersSchema>
extends RequestSchema<B, S>
implements SpecifiesHttpResponseCode {
    @API(help="Model builder parameters.")
    public P parameters = this.createParametersSchema();
    @API(help="The algo name for this ModelBuilder.", direction=API.Direction.OUTPUT)
    public String algo;
    @API(help="The pretty algo name for this ModelBuilder (e.g., Generalized Linear Model, rather than GLM).", direction=API.Direction.OUTPUT)
    public String algo_full_name;
    @API(help="Model categories this ModelBuilder can build.", values={"Unknown", "Binomial", "Multinomial", "Regression", "Clustering", "AutoEncoder", "DimReduction"}, direction=API.Direction.OUTPUT)
    public ModelCategory[] can_build;
    @API(help="Should the builder always be visible, be marked as beta, or only visible if the user starts up with the experimental flag?", values={"Experimental", "Beta", "AlwaysVisible"}, direction=API.Direction.OUTPUT)
    public ModelBuilder.BuilderVisibility visibility;
    @API(help="Job Key", direction=API.Direction.OUTPUT)
    public JobV3 job;
    @API(help="Parameter validation messages", direction=API.Direction.OUTPUT)
    public ValidationMessageBase[] messages;
    @API(help="Count of parameter validation errors", direction=API.Direction.OUTPUT)
    public int error_count;
    @API(help="HTTP status to return for this build.", json=false)
    public int __http_status;

    public void setHttpStatus(int status) {
        this.__http_status = status;
    }

    @Override
    public int httpStatus() {
        return this.__http_status;
    }

    public final P createParametersSchema() {
        if (ModelBuilderSchema.class == this.getClass()) {
            return (P)new ModelParametersSchema();
        }
        try {
            Class parameters_class = ReflectionUtils.findActualClassParameter(this.getClass(), 2);
            return (P)((ModelParametersSchema)parameters_class.newInstance());
        }
        catch (Exception e) {
            throw H2O.fail("Caught exception trying to instantiate a builder instance for ModelBuilderSchema: " + this + ": " + e, e);
        }
    }

    @Override
    public S fillFromParms(Properties parms) {
        ((Schema)this.parameters).fillFromParms(parms);
        return (S)this;
    }

    @Override
    public final B createImpl() {
        return ModelBuilder.make(this.get__meta().getSchema_type(), null, null);
    }

    @Override
    public B fillImpl(B impl) {
        super.fillImpl(impl);
        ((ModelParametersSchema)this.parameters).fillImpl(((ModelBuilder)impl)._parms);
        ((ModelBuilder)impl).init(false);
        return impl;
    }

    @Override
    public S fillFromImpl(B builder) {
        this.algo = ((Model.Parameters)((ModelBuilder)builder)._parms).algoName().toLowerCase();
        this.algo_full_name = ((Model.Parameters)((ModelBuilder)builder)._parms).fullName();
        this.can_build = ((ModelBuilder)builder).can_build();
        this.visibility = ((ModelBuilder)builder).builderVisibility();
        this.job = ((ModelBuilder)builder)._job == null ? null : (JobV3)Schema.schema(this.getSchemaVersion(), Job.class).fillFromImpl(((ModelBuilder)builder)._job);
        ModelBuilder.ValidationMessage[] msgs = ((ModelBuilder)builder)._messages;
        if (msgs != null) {
            this.messages = new ValidationMessageBase[msgs.length];
            int i = 0;
            for (ModelBuilder.ValidationMessage vm : msgs) {
                if (vm == null) continue;
                this.messages[i++] = new ValidationMessageV3().fillFromImpl(vm);
            }
            ValidationMessageBase.mapValidationMessageFieldNames(this.messages, new String[]{"_train", "_valid"}, new String[]{"training_frame", "validation_frame"});
        }
        this.error_count = ((ModelBuilder)builder).error_count();
        this.parameters = this.createParametersSchema();
        ((ModelParametersSchema)this.parameters).fillFromImpl(((ModelBuilder)builder)._parms);
        ((ModelParametersSchema)this.parameters).model_id = ((ModelBuilder)builder).dest() == null ? null : new KeyV3.ModelKeyV3(((ModelBuilder)builder).dest());
        return (S)this;
    }

    public final AutoBuffer writeJSON_impl(AutoBuffer ab) {
        ab.putJSON("job", this.job);
        ab.put1(44);
        ab.putJSONStr("algo", this.algo);
        ab.put1(44);
        ab.putJSONStr("algo_full_name", this.algo_full_name);
        ab.put1(44);
        ab.putJSONAEnum("can_build", (Enum[])this.can_build);
        ab.put1(44);
        ab.putJSONEnum("visibility", this.visibility);
        ab.put1(44);
        ab.putJSONA("messages", this.messages);
        ab.put1(44);
        ab.putJSON4("error_count", this.error_count);
        ab.put1(44);
        ModelParametersSchema.writeParametersJSON(ab, this.parameters, ((ModelParametersSchema)((Object)this.createParametersSchema())).fillFromImpl((Model.Parameters)((Model.Parameters)((Schema)this.parameters).createImpl())));
        return ab;
    }

    public static class IcedHashMapStringModelBuilderSchema
    extends IcedSortedHashMap<String, ModelBuilderSchema> {
    }
}

