/*
 * Decompiled with CFR 0.152.
 */
package water;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import water.Freezable;
import water.H2O;
import water.Key;
import water.MemoryManager;
import water.Value;
import water.fvec.Chunk;
import water.util.Log;
import water.util.PrettyPrint;

class Cleaner
extends Thread {
    private static volatile long _dirty;
    static volatile long HEAP_USED_AT_LAST_GC;
    static volatile long KV_USED_AT_LAST_GC;
    static volatile long TIME_AT_LAST_GC;
    static final Cleaner THE_CLEANER;
    volatile boolean _did_sweep;
    static volatile long DESIRED;

    static long dirty() {
        return _dirty;
    }

    static void dirty_store() {
        Cleaner.dirty_store(System.currentTimeMillis());
    }

    static void dirty_store(long x) {
        if (x < _dirty) {
            _dirty = x;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void kick_store_cleaner() {
        Cleaner cleaner = THE_CLEANER;
        synchronized (cleaner) {
            THE_CLEANER.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void block_store_cleaner() {
        Cleaner cleaner = THE_CLEANER;
        synchronized (cleaner) {
            try {
                THE_CLEANER.wait(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void block_for_test() throws InterruptedException {
        Cleaner.THE_CLEANER._did_sweep = false;
        Cleaner cleaner = THE_CLEANER;
        synchronized (cleaner) {
            while (!Cleaner.THE_CLEANER._did_sweep) {
                THE_CLEANER.wait();
            }
        }
    }

    Cleaner() {
        super("MemCleaner");
        this.setDaemon(true);
        this.setPriority(8);
        _dirty = Long.MAX_VALUE;
        Histo.current(true);
        Histo.current(true);
        MemoryManager.set_goals("init", false);
    }

    static boolean isDiskFull() {
        long space = H2O.getPM().getIce().getUsableSpace();
        return space >= 0L && space < 5120L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean diskFull = false;
        while (true) {
            boolean force;
            Histo h = Histo.current(false);
            long now = System.currentTimeMillis();
            long dirty = _dirty;
            if (h._cached < DESIRED && now - dirty < 5000L) {
                Cleaner.block_store_cleaner();
                continue;
            }
            now = System.currentTimeMillis();
            _dirty = Long.MAX_VALUE;
            MemoryManager.set_goals("preclean", false);
            boolean bl = force = h._cached >= DESIRED || !MemoryManager.CAN_ALLOC;
            if (force && diskFull) {
                diskFull = Cleaner.isDiskFull();
            }
            long clean_to_age = h.clean_to(force ? DESIRED : DESIRED >> 1);
            if (!force) {
                clean_to_age = Math.max(clean_to_age, now - 5000L);
            }
            if (DESIRED == -1L) {
                clean_to_age = now;
            }
            String s = h + " DESIRED=" + (DESIRED >> 20) + "M dirtysince=" + (now - dirty) + " force=" + force + " clean2age=" + (now - clean_to_age);
            if (MemoryManager.canAlloc()) {
                Log.debug(s);
            } else {
                System.err.println(s);
            }
            long cleaned = 0L;
            long freed = 0L;
            long io_ns = 0L;
            Object[] kvs = H2O.STORE.raw_array();
            for (int i = 2; i < kvs.length; i += 2) {
                Object ok = kvs[i];
                Object ov = kvs[i + 1];
                if (!(ok instanceof Key) || !(ov instanceof Value)) continue;
                Value val = (Value)ov;
                byte[] m = val.rawMem();
                Freezable p = val.rawPOJO();
                if (m == null && p == null || val.isLockable()) continue;
                boolean isChunk = p instanceof Chunk;
                long touched = val._lastAccessedTime;
                if (touched > clean_to_age) {
                    if (val.isPersisted() && m != null && p != null && !isChunk) {
                        val.freeMem();
                        freed += (long)val._max;
                    }
                    Cleaner.dirty_store(touched);
                    continue;
                }
                if (!H2O.ARGS.cleaner) continue;
                if (isChunk && !val.isPersisted() && !diskFull && ((Key)ok).home()) {
                    long now_ns = System.nanoTime();
                    try {
                        val.storePersist();
                    }
                    catch (FileNotFoundException fnfe) {
                        continue;
                    }
                    catch (IOException e) {
                        Log.warn(Cleaner.isDiskFull() ? "Disk full! Disabling swapping to disk." + (force ? " Memory low! Please free some space in " + H2O.ICE_ROOT + "!" : "") : "Disk swapping failed! " + e.getMessage());
                        diskFull = true;
                    }
                    if (m == null) {
                        m = val.rawMem();
                    }
                    if (m != null) {
                        cleaned += (long)m.length;
                    }
                    io_ns += System.nanoTime() - now_ns;
                }
                if (isChunk && force && (val.isPersisted() || !((Key)ok).home())) {
                    val.freeMem();
                    if (m != null) {
                        freed += (long)val._max;
                    }
                    m = null;
                    val.freePOJO();
                    if (p != null) {
                        freed += (long)val._max;
                    }
                    p = null;
                    if (isChunk) {
                        freed -= (long)val._max;
                    }
                }
                if (m != null && p != null && !isChunk) {
                    val.freeMem();
                    freed += (long)val._max;
                }
                force = h._cached >= DESIRED || !MemoryManager.CAN_ALLOC;
            }
            String s1 = "Cleaner pass took: " + PrettyPrint.msecs(System.currentTimeMillis() - now, true) + ", spilled " + PrettyPrint.bytes(cleaned) + " in " + PrettyPrint.usecs(io_ns >> 10);
            h = Histo.current(true);
            MemoryManager.set_goals("postclean", false);
            String s2 = h + " diski_o=" + PrettyPrint.bytes(cleaned) + ", freed=" + (freed >> 20) + "M, DESIRED=" + (DESIRED >> 20) + "M";
            if (MemoryManager.canAlloc()) {
                Log.debug(s1, s2);
            } else {
                System.err.println(s1 + "\n" + s2);
            }
            Cleaner cleaner = this;
            synchronized (cleaner) {
                this._did_sweep = true;
                if (DESIRED == -1L) {
                    DESIRED = 0L;
                }
                this.notifyAll();
            }
        }
    }

    static {
        TIME_AT_LAST_GC = System.currentTimeMillis();
        THE_CLEANER = new Cleaner();
    }

    static class Histo {
        private static volatile Histo H;
        final long[] _hs = new long[128];
        long _oldest;
        long _eldest;
        long _hStep;
        long _cached;
        long _total;
        long _when;
        long _swapped;
        Value _vold;
        boolean _clean;

        static synchronized Histo current(boolean force) {
            Histo h = H;
            if (!force && System.currentTimeMillis() < h._when + 2000L) {
                return h;
            }
            if (h != null && h._clean && _dirty == Long.MAX_VALUE) {
                return h;
            }
            H = new Histo(h == null ? 0L : h._oldest);
            return H;
        }

        static long cached() {
            return Histo.H._cached;
        }

        static long swapped() {
            return Histo.H._swapped;
        }

        Histo(long eldest) {
            Arrays.fill(this._hs, 0L);
            this._when = System.currentTimeMillis();
            this._eldest = eldest;
            this._hStep = Math.max(1L, (this._when - eldest) / (long)this._hs.length);
            boolean clean = _dirty == Long.MAX_VALUE;
            Object[] kvs = H2O.STORE.raw_array();
            long cached = 0L;
            long total = 0L;
            long swapped = 0L;
            long oldest = Long.MAX_VALUE;
            Value vold = null;
            for (int i = 2; i < kvs.length; i += 2) {
                int idx;
                Object ok = kvs[i];
                Object ov = kvs[i + 1];
                if (!(ok instanceof Key) || !(ov instanceof Value)) continue;
                Value val = (Value)ov;
                if (val.isNull()) {
                    Value.STORE_get(val._key);
                    continue;
                }
                total += (long)val._max;
                if (val.isPersisted()) {
                    swapped += (long)val._max;
                }
                int len = 0;
                byte[] m = val.rawMem();
                Freezable p = val.rawPOJO();
                if (m != null) {
                    len += val._max;
                }
                if (p != null) {
                    len += val._max;
                }
                if (m != null && p instanceof Chunk) {
                    len -= val._max;
                }
                if (len == 0) continue;
                cached += (long)len;
                if (val._lastAccessedTime < oldest) {
                    vold = val;
                    oldest = val._lastAccessedTime;
                }
                if ((idx = (int)((val._lastAccessedTime - eldest) / this._hStep)) < 0) {
                    idx = 0;
                } else if (idx >= this._hs.length) {
                    idx = this._hs.length - 1;
                }
                int n = idx;
                this._hs[n] = this._hs[n] + (long)len;
            }
            this._cached = cached;
            this._total = total;
            this._swapped = swapped;
            this._oldest = oldest;
            this._vold = vold;
            this._clean = clean && _dirty == Long.MAX_VALUE;
        }

        long clean_to(long desired) {
            long age = this._eldest;
            if (this._cached < desired) {
                return age;
            }
            long s = 0L;
            for (long t : this._hs) {
                age += this._hStep;
                if (this._cached - (s += t) < desired) break;
            }
            return age;
        }

        public String toString() {
            long x = this._eldest;
            long now = System.currentTimeMillis();
            return "H(cached:" + (this._cached >> 20) + "M, eldest:" + x + "L < +" + (this._oldest - x) + "ms <...{" + this._hStep + "ms}...< +" + this._hStep * (long)this._hs.length + "ms < +" + (now - x) + ")";
        }
    }
}

