/*
 * Decompiled with CFR 0.152.
 */
package water;

import java.util.Arrays;
import jsr166y.CountedCompleter;
import water.AutoBuffer;
import water.DKV;
import water.Futures;
import water.H2O;
import water.H2ONode;
import water.Key;
import water.Keyed;
import water.MRTask;
import water.TAtomic;
import water.TypeMap;
import water.Value;
import water.api.KeyV3;
import water.util.Log;

public final class Job<T extends Keyed>
extends Keyed<Job> {
    public final Key<T> _result;
    public final int _typeid;
    public final String _description;
    private String[] _warns;
    private long _start_time;
    private long _end_time;
    private volatile boolean _stop_requested;
    private byte[] _ex;
    public long _work;
    private long _worked;
    private String _msg;
    public static final Key<Job> LIST = Key.make(" JobList", (byte)0, (byte)2, false, new H2ONode[0]);
    private transient Barrier2 _barrier;

    public void setWarnings(final String[] warns) {
        new JAtomic(){

            @Override
            boolean abort(Job job) {
                return job._stop_requested;
            }

            @Override
            void update(Job job) {
                Job.access$202(job, warns);
            }
        }.apply(this);
    }

    public Job(Key<T> key, String clz_of_T, String desc) {
        super(Job.defaultJobKey());
        assert (key == null || clz_of_T != null);
        this._result = key;
        this._typeid = clz_of_T == null ? 0 : TypeMap.onIce(clz_of_T);
        this._description = desc;
    }

    private static Key<Job> defaultJobKey() {
        return Key.make((byte)0, (byte)3, false, H2O.SELF);
    }

    private boolean created() {
        return this._start_time == 0L;
    }

    private boolean running() {
        return this._start_time != 0L && this._end_time == 0L;
    }

    private boolean stopped() {
        return this._end_time != 0L;
    }

    public long start_time() {
        this.update_from_remote();
        assert (!this.created());
        return this._start_time;
    }

    public long end_time() {
        this.update_from_remote();
        assert (this.stopped());
        return this._end_time;
    }

    public boolean isRunning() {
        this.update_from_remote();
        return this.running();
    }

    public boolean isStopped() {
        this.update_from_remote();
        return this.stopped();
    }

    public boolean isStopping() {
        return this.isRunning() && this._stop_requested;
    }

    public boolean isDone() {
        return this.isStopped() && this._ex == null;
    }

    public boolean isCrashing() {
        return this.isRunning() && this._ex != null;
    }

    public boolean isCrashed() {
        return this.isStopped() && this._ex != null;
    }

    public long msec() {
        this.update_from_remote();
        if (this.created()) {
            return 0L;
        }
        if (this.running()) {
            return System.currentTimeMillis() - this._start_time;
        }
        return this._end_time - this._start_time;
    }

    public boolean stop_requested() {
        this.update_from_remote();
        return this._stop_requested;
    }

    public void stop() {
        if (!this._stop_requested) {
            new JAtomic(){

                @Override
                boolean abort(Job job) {
                    return job._stop_requested;
                }

                @Override
                void update(Job job) {
                    job._stop_requested = true;
                }
            }.apply(this);
        }
    }

    public Throwable ex() {
        if (this._ex == null) {
            return null;
        }
        return (Throwable)AutoBuffer.javaSerializeReadPojo(this._ex);
    }

    public float progress() {
        this.update_from_remote();
        return this._work == 0L ? 0.0f : Math.min(1.0f, (float)this._worked / (float)this._work);
    }

    public String progress_msg() {
        this.update_from_remote();
        return this._msg;
    }

    public final void update(final long newworked, final String msg) {
        if (newworked > 0L || msg != null && !msg.equals(this._msg)) {
            new JAtomic(){

                @Override
                boolean abort(Job job) {
                    return newworked == 0L && (msg == null && Job.this._msg == null || msg != null && msg.equals(job._msg));
                }

                @Override
                void update(Job old) {
                    old._worked += newworked;
                    old._msg = msg;
                }
            }.apply(this);
        }
    }

    public final void update(long newworked) {
        this.update(newworked, null);
    }

    public static void update(long newworked, Key<Job> jobkey) {
        Job.update(newworked, null, jobkey);
    }

    public static void update(long newworked, String msg, Key<Job> jobkey) {
        jobkey.get().update(newworked, msg);
    }

    public String[] warns() {
        return this._warns;
    }

    public static Job[] jobs() {
        Value val = DKV.get(LIST);
        if (val == null) {
            return new Job[0];
        }
        JobList jl = (JobList)val.get();
        Job[] jobs = new Job[jl._jobs.length];
        int j = 0;
        for (int i = 0; i < jl._jobs.length; ++i) {
            Value job = DKV.get(jl._jobs[i]);
            if (job == null) continue;
            jobs[j++] = (Job)job.get();
        }
        if (j == jobs.length) {
            return jobs;
        }
        jobs = Arrays.copyOf(jobs, j);
        Key[] keys = new Key[j];
        for (int i = 0; i < j; ++i) {
            keys[i] = jobs[i]._key;
        }
        DKV.DputIfMatch(LIST, new Value(LIST, new JobList(keys)), val, new Futures());
        return jobs;
    }

    public Job<T> start(H2O.H2OCountedCompleter fjtask, long work) {
        assert (!((AssertNoKey)new AssertNoKey((Key<Job>)this._key).doAllNodes())._found);
        assert (this.created() && !this.running() && !this.stopped());
        assert (fjtask != null) : "Starting a job with null working task is not permitted!";
        assert (fjtask.getCompleter() == null) : "Cannot have a completer; this must be a top-level task";
        this._barrier = new Barrier2();
        fjtask.setCompleter(new Barrier1(this._barrier));
        this._start_time = System.currentTimeMillis();
        assert (!this.created() && this.running() && !this.stopped());
        this._work = work;
        DKV.put(this);
        final Key jobkey = this._key;
        new TAtomic<JobList>(){

            @Override
            public JobList atomic(JobList old) {
                if (old == null) {
                    old = new JobList();
                }
                Key<Job>[] jobs = old._jobs;
                old._jobs = Arrays.copyOf(jobs, jobs.length + 1);
                old._jobs[jobs.length] = jobkey;
                return old;
            }
        }.invoke(LIST);
        H2O.submitTask(fjtask);
        return this;
    }

    public static boolean isCancelledException(Throwable ex) {
        return ex instanceof JobCancelledException || ex.getCause() != null && ex.getCause() instanceof JobCancelledException;
    }

    public T get() {
        Barrier2 bar = this._barrier;
        if (bar != null) {
            bar.join();
        }
        assert (this.isStopped());
        if (this._ex != null) {
            throw new RuntimeException((Throwable)AutoBuffer.javaSerializeReadPojo(this._ex));
        }
        return this._result == null ? null : (T)this._result.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update_from_remote() {
        Job remote = (Job)DKV.getGet(this._key);
        if (this == remote) {
            return;
        }
        if (null == remote) {
            return;
        }
        boolean differ = false;
        if (this._stop_requested != remote._stop_requested) {
            differ = true;
        }
        if (this._start_time != remote._start_time) {
            differ = true;
        }
        if (this._end_time != remote._end_time) {
            differ = true;
        }
        if (this._ex != remote._ex) {
            differ = true;
        }
        if (this._work != remote._work) {
            differ = true;
        }
        if (this._worked != remote._worked) {
            differ = true;
        }
        if (this._msg != remote._msg) {
            differ = true;
        }
        if (differ) {
            Job job = this;
            synchronized (job) {
                this._stop_requested = remote._stop_requested;
                this._start_time = remote._start_time;
                this._end_time = remote._end_time;
                this._ex = remote._ex;
                this._work = remote._work;
                this._worked = remote._worked;
                this._msg = remote._msg;
            }
        }
    }

    @Override
    public Class<KeyV3.JobKeyV3> makeSchema() {
        return KeyV3.JobKeyV3.class;
    }

    static /* synthetic */ String[] access$202(Job x0, String[] x1) {
        x0._warns = x1;
        return x1;
    }

    static /* synthetic */ byte[] access$1002(Job x0, byte[] x1) {
        x0._ex = x1;
        return x1;
    }

    private static abstract class JAtomic
    extends TAtomic<Job> {
        private JAtomic() {
        }

        void apply(Job job) {
            this.invoke(job._key);
            job.update_from_remote();
        }

        abstract boolean abort(Job var1);

        abstract void update(Job var1);

        @Override
        public Job atomic(Job job) {
            assert (job != null) : "Race on creation";
            if (this.abort(job)) {
                return null;
            }
            this.update(job);
            return job;
        }
    }

    private class Barrier2
    extends CountedCompleter {
        private Barrier2() {
        }

        @Override
        public void compute() {
        }
    }

    private static class Barrier1OnExCom
    extends JAtomic {
        final byte[] _dex;

        Barrier1OnExCom(Throwable ex) {
            this._dex = AutoBuffer.javaSerializeWritePojo(ex);
        }

        @Override
        boolean abort(Job job) {
            return job._ex != null && job._end_time != 0L;
        }

        @Override
        void update(Job job) {
            if (job._ex == null) {
                Job.access$1002(job, this._dex);
            }
            job._stop_requested = true;
            if (job._end_time == 0L) {
                job._end_time = System.currentTimeMillis();
            }
            job._msg = "Failed.";
        }
    }

    private static class Barrier1OnCom
    extends JAtomic {
        private Barrier1OnCom() {
        }

        @Override
        boolean abort(Job job) {
            return false;
        }

        @Override
        public void update(Job old) {
            assert (old._end_time == 0L) : "onComp should be called once at most, and never if onExComp is called";
            old._end_time = System.currentTimeMillis();
            if (old._worked < old._work) {
                old._worked = old._work;
            }
            old._msg = old._stop_requested ? "Cancelled." : "Done.";
        }
    }

    private class Barrier1
    extends CountedCompleter {
        Barrier1(CountedCompleter cc) {
            super(cc, 0);
        }

        @Override
        public void compute() {
        }

        @Override
        public void onCompletion(CountedCompleter caller) {
            new Barrier1OnCom().apply(Job.this);
            Job.this._barrier = null;
        }

        @Override
        public boolean onExceptionalCompletion(Throwable ex, CountedCompleter caller) {
            if (Job.isCancelledException(ex)) {
                new Barrier1OnCom().apply(Job.this);
                Job.this._barrier = null;
            } else {
                try {
                    Log.err(ex);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                new Barrier1OnExCom(ex).apply(Job.this);
            }
            Job.this._barrier = null;
            return true;
        }
    }

    public static class JobCancelledException
    extends RuntimeException {
    }

    private static class AssertNoKey
    extends MRTask<AssertNoKey> {
        private final Key<Job> _key;
        boolean _found;

        AssertNoKey(Key<Job> key) {
            this._key = key;
        }

        @Override
        public void setupLocal() {
            this._found = H2O.containsKey(this._key);
        }

        @Override
        public void reduce(AssertNoKey ank) {
            this._found |= ank._found;
        }
    }

    private static class JobList
    extends Keyed {
        Key<Job>[] _jobs;

        JobList() {
            super(LIST);
            this._jobs = new Key[0];
        }

        private JobList(Key<Job>[] jobs) {
            super(LIST);
            this._jobs = jobs;
        }
    }
}

