/*
 * Decompiled with CFR 0.152.
 */
package water;

import hex.Model;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import jsr166y.ForkJoinPool;
import water.AutoBuffer;
import water.Freezable;
import water.Futures;
import water.H2O;
import water.H2ONode;
import water.Iced;
import water.Job;
import water.Key;
import water.Lockable;
import water.TaskInvalidateKey;
import water.TypeMap;
import water.fvec.Frame;
import water.fvec.Vec;
import water.util.Log;

public final class Value
extends Iced
implements ForkJoinPool.ManagedBlocker {
    public transient Key _key;
    private short _type;
    public static final int MAX = 0x10000000;
    public int _max;
    private volatile byte[] _mem;
    private volatile Freezable _pojo;
    transient long _lastAccessedTime = System.currentTimeMillis();
    private volatile byte _persist;
    public static final byte ICE = 1;
    public static final byte HDFS = 2;
    public static final byte S3 = 3;
    public static final byte NFS = 4;
    public static final byte TCP = 7;
    private static final byte BACKEND_MASK = 7;
    private static final byte NOTdsk = 0;
    private static final byte ON_dsk = 8;
    private volatile byte _deleted;
    private transient AtomicInteger _rwlock;
    private volatile byte[] _replicas;
    private static final AtomicReferenceFieldUpdater<Value, byte[]> REPLICAS_UPDATER = AtomicReferenceFieldUpdater.newUpdater(Value.class, byte[].class, "_replicas");

    public int type() {
        return this._type;
    }

    public String className() {
        return TypeMap.className(this._type);
    }

    final byte[] rawMem() {
        return this._mem;
    }

    Freezable rawPOJO() {
        return this._pojo;
    }

    public final void freeMem() {
        assert (this.isPersisted() || this._pojo != null || this._key.isChunkKey());
        this._mem = null;
    }

    public final void freePOJO() {
        assert (this.isPersisted() || this._mem != null);
        this._pojo = null;
    }

    public final byte[] memOrLoad() {
        byte[] mem = this._mem;
        if (mem != null) {
            return mem;
        }
        Freezable pojo = this._pojo;
        if (pojo != null) {
            this._mem = pojo.asBytes();
        }
        if (this._max == 0) {
            this._mem = new byte[0];
            return this._mem;
        }
        this._mem = this.loadPersist();
        return this._mem;
    }

    final boolean isEmpty() {
        return this._max > 0 && this._mem == null && this._pojo == null && !this.isPersisted();
    }

    public final <T extends Iced> T get() {
        this.touch();
        Iced pojo = (Iced)this._pojo;
        if (pojo != null) {
            return (T)pojo;
        }
        pojo = TypeMap.newInstance(this._type);
        this._pojo = pojo.reloadFromBytes(this.memOrLoad());
        return (T)((Iced)this._pojo);
    }

    public final <T extends Freezable> T get(Class<T> fc) {
        T pojo = this.getFreezable();
        assert (fc.isAssignableFrom(pojo.getClass()));
        return pojo;
    }

    public final <T extends Freezable> T getFreezable() {
        this.touch();
        Freezable pojo = this._pojo;
        if (pojo != null) {
            return (T)pojo;
        }
        pojo = TypeMap.newFreezable(this._type);
        pojo.reloadFromBytes(this.memOrLoad());
        this._pojo = pojo;
        return (T)this._pojo;
    }

    private void touch() {
        this._lastAccessedTime = System.currentTimeMillis();
    }

    void touchAt(long time) {
        this._lastAccessedTime = time;
    }

    final byte backend() {
        return (byte)(this._persist & 7);
    }

    boolean onICE() {
        return this.backend() == 1;
    }

    private boolean onHDFS() {
        return this.backend() == 2;
    }

    private boolean onNFS() {
        return this.backend() == 4;
    }

    private boolean onS3() {
        return this.backend() == 3;
    }

    public final boolean isPersisted() {
        return (this._persist & 8) != 0;
    }

    public final void setDsk() {
        this._persist = (byte)(this._persist | 8);
    }

    public final boolean isDeleted() {
        return this._deleted != 0;
    }

    public final void setDel() {
        this._deleted = 1;
    }

    void storePersist() throws IOException {
        if (this.isDeleted()) {
            return;
        }
        if (this.isPersisted()) {
            return;
        }
        H2O.getPM().store(this.backend(), this);
        assert (!this.isPersisted());
        this.setDsk();
        if (this.isDeleted()) {
            H2O.getPM().delete(this.backend(), this);
        }
    }

    public void removePersist() {
        if (!this.onICE()) {
            return;
        }
        if (this.isDeleted()) {
            return;
        }
        this.setDel();
        if (!this.isPersisted()) {
            return;
        }
        H2O.getPM().delete(this.backend(), this);
    }

    byte[] loadPersist() {
        assert (this.isPersisted());
        try {
            byte[] res = H2O.getPM().load(this.backend(), this);
            assert (!this.isDeleted());
            return res;
        }
        catch (IOException ioe) {
            throw Log.throwErr(ioe);
        }
    }

    String nameOfPersist() {
        return Value.nameOfPersist(this.backend());
    }

    public static String nameOfPersist(int x) {
        switch (x) {
            case 1: {
                return "ICE";
            }
            case 2: {
                return "HDFS";
            }
            case 3: {
                return "S3";
            }
            case 4: {
                return "NFS";
            }
            case 7: {
                return "TCP";
            }
        }
        return null;
    }

    public static boolean isSubclassOf(int type, Class clz) {
        return clz.isAssignableFrom(TypeMap.theFreezable(type).getClass());
    }

    public boolean isKey() {
        return this._type != TypeMap.PRIM_B && TypeMap.theFreezable(this._type) instanceof Key;
    }

    public boolean isFrame() {
        return this._type != TypeMap.PRIM_B && TypeMap.theFreezable(this._type) instanceof Frame;
    }

    public boolean isVecGroup() {
        return this._type == TypeMap.VECGROUP;
    }

    public boolean isESPCGroup() {
        return this._type == TypeMap.ESPCGROUP;
    }

    public boolean isLockable() {
        return this._type != TypeMap.PRIM_B && TypeMap.theFreezable(this._type) instanceof Lockable;
    }

    public boolean isVec() {
        return this._type != TypeMap.PRIM_B && TypeMap.theFreezable(this._type) instanceof Vec;
    }

    public boolean isModel() {
        return this._type != TypeMap.PRIM_B && TypeMap.theFreezable(this._type) instanceof Model;
    }

    public boolean isJob() {
        return this._type != TypeMap.PRIM_B && TypeMap.theFreezable(this._type) instanceof Job;
    }

    public Class<? extends Freezable> theFreezableClass() {
        return TypeMap.theFreezable(this._type).getClass();
    }

    public Value(Key k, int max, byte[] mem, short type, byte be) {
        assert (mem == null || mem.length == max);
        assert (max < 0x10000000) : "Value size=0x" + Integer.toHexString(max);
        this._key = k;
        this._max = max;
        this._mem = mem;
        this._type = type;
        this._pojo = null;
        byte p = (byte)(be & 7);
        this._persist = p == 1 ? p : be;
        this._rwlock = new AtomicInteger(1);
        this._replicas = null;
    }

    Value(Key k, byte[] mem) {
        this(k, mem.length, mem, TypeMap.PRIM_B, 1);
    }

    Value(Key k, String s) {
        this(k, s.getBytes());
    }

    Value(Key k, Iced pojo) {
        this(k, pojo, 1);
    }

    Value(Key k, Iced pojo, byte be) {
        this._key = k;
        this._pojo = pojo;
        this._type = (short)pojo.frozenType();
        this._mem = pojo.asBytes();
        this._max = this._mem.length;
        assert (this._max < 0x10000000) : "Value size = " + this._max + " (0x" + Integer.toHexString(this._max) + ") >= (MAX=" + 0x10000000 + ").";
        byte p = (byte)(be & 7);
        this._persist = p == 1 ? p : be;
        this._rwlock = new AtomicInteger(1);
        this._replicas = null;
    }

    public Value(Key k, Freezable pojo) {
        this(k, pojo, 1);
    }

    Value(Key k, Freezable pojo, byte be) {
        this._key = k;
        this._pojo = pojo;
        this._type = (short)pojo.frozenType();
        this._mem = pojo.asBytes();
        this._max = this._mem.length;
        byte p = (byte)(be & 7);
        this._persist = p == 1 ? p : be;
        this._rwlock = new AtomicInteger(1);
        this._replicas = null;
    }

    public final AutoBuffer write_impl(AutoBuffer ab) {
        return ab.put1(this._persist).put2(this._type).putA1(this.memOrLoad());
    }

    public final Value read_impl(AutoBuffer bb) {
        assert (this._key == null);
        this._persist = (byte)(bb.get1() & 7);
        this._type = (short)bb.get2();
        this._mem = bb.getA1();
        this._max = this._mem.length;
        assert (this._max < 0x10000000) : "Value size=0x" + Integer.toHexString(this._max) + " during read is larger than " + Integer.toHexString(0x10000000) + ", type: " + TypeMap.className(this._type);
        this._pojo = null;
        this._rwlock = new AtomicInteger(-1);
        this._replicas = null;
        this.touch();
        return this;
    }

    private boolean RW_CAS(int old, int nnn, String msg) {
        return this._rwlock.compareAndSet(old, nnn);
    }

    private byte[] replicas() {
        byte[] r = this._replicas;
        if (r != null) {
            return r;
        }
        byte[] nr = new byte[H2O.CLOUD.size() + 1 + 10];
        if (REPLICAS_UPDATER.compareAndSet(this, null, nr)) {
            return nr;
        }
        r = this._replicas;
        assert (r != null);
        return r;
    }

    boolean read_lock() {
        int old;
        do {
            if ((old = this._rwlock.get()) == -1) {
                return false;
            }
            assert (old >= 0);
        } while (!this.RW_CAS(old, old + 1, "rlock+"));
        return true;
    }

    boolean setReplica(H2ONode h2o) {
        assert (this._key.home());
        assert (h2o != H2O.SELF);
        if (!this.read_lock()) {
            return false;
        }
        this.replicas()[h2o._unique_idx] = 1;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void lowerActiveGetCount(H2ONode h2o) {
        int old;
        assert (this._key.home());
        assert (h2o != H2O.SELF);
        do {
            old = this._rwlock.get();
            assert (old > 0);
            assert (old != -1);
            assert (h2o == null || this._replicas != null && this._replicas[h2o._unique_idx] == 1);
        } while (!this.RW_CAS(old, old - 1, "rlock-"));
        if (old - 1 == 0) {
            Value value = this;
            synchronized (value) {
                this.notifyAll();
            }
        }
    }

    Futures lockAndInvalidate(H2ONode sender, Value newval, Futures fs) {
        assert (this._key.home());
        assert (newval._rwlock.get() >= 1);
        while (true) {
            int old = this._rwlock.get();
            assert (old >= 0) : this._key + ", rwlock=" + old;
            assert (old != -1);
            if (old != 0) {
                try {
                    ForkJoinPool.managedBlock(this);
                }
                catch (InterruptedException ignore) {}
                continue;
            }
            if (this.RW_CAS(0, -1, "wlock")) break;
        }
        byte[] r = this._replicas;
        if (r != null) {
            int max = r.length;
            for (int i = 0; i < max; ++i) {
                if (r[i] != 1 || H2ONode.IDX[i] == sender) continue;
                TaskInvalidateKey.invalidate(H2ONode.IDX[i], this._key, newval, fs);
            }
        }
        newval.lowerActiveGetCount(null);
        return fs;
    }

    void blockTillNoReaders() {
        assert (this._key.home());
        int old;
        while ((old = this._rwlock.get()) > 0) {
            try {
                ForkJoinPool.managedBlock(this);
            }
            catch (InterruptedException interruptedException) {
            }
        }
        return;
    }

    void initReplicaHome(H2ONode h2o, Key key) {
        assert (key.home());
        assert (this._key == null);
        assert (h2o != H2O.SELF);
        this._key = key;
        this.replicas()[h2o._unique_idx] = 1;
        this._rwlock.set(1);
    }

    void startRemotePut() {
        int x;
        assert (!this._key.home());
        while ((x = this._rwlock.get()) != -1) {
            if (x != 2 && !this.RW_CAS(1, 2, "remote_need_notify")) continue;
            try {
                ForkJoinPool.managedBlock(this);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void completeRemotePut() {
        assert (!this._key.home());
        if (this.RW_CAS(1, -1, "remote_complete")) {
            return;
        }
        Value value = this;
        synchronized (value) {
            boolean res = this.RW_CAS(2, -1, "remote_do_notify");
            assert (res);
            this.notifyAll();
        }
    }

    static Value makeNull(Key key) {
        assert (key.home());
        return new Value(key, 0, null, 0, 7);
    }

    boolean isNull() {
        assert (this._type != 0 || this._key.home());
        return this._type == 0;
    }

    public static Value STORE_get(Key key) {
        Value val = H2O.STORE.get(key);
        if (val == null) {
            return null;
        }
        if (!val.isNull()) {
            return val;
        }
        if (val._rwlock.get() == 0) {
            H2O.putIfMatch(key, null, val);
        }
        return null;
    }

    @Override
    public boolean isReleasable() {
        int r = this._rwlock.get();
        if (this._key.home()) {
            return r <= 0;
        }
        assert (r == 2 || r == -1);
        return r == -1;
    }

    @Override
    public synchronized boolean block() {
        while (!this.isReleasable()) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        return true;
    }
}

