/*
 * Decompiled with CFR 0.152.
 */
package water.api;

import water.Futures;
import water.Key;
import water.MemoryManager;
import water.api.API;
import water.api.FrameBase;
import water.api.KeyV3;
import water.api.Schema;
import water.api.TwoDimTableBase;
import water.fvec.ByteVec;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.Vec;
import water.parser.BufferedString;
import water.util.ChunkSummary;
import water.util.FrameUtils;
import water.util.PrettyPrint;
import water.util.TwoDimTable;

public class FrameV3
extends FrameBase<Frame, FrameV3> {
    @API(help="Row offset to display", direction=API.Direction.INPUT)
    public long row_offset;
    @API(help="Number of rows to display", direction=API.Direction.INOUT)
    public int row_count;
    @API(help="Column offset to return", direction=API.Direction.INOUT)
    public int column_offset;
    @API(help="Number of columns to return", direction=API.Direction.INOUT)
    public int column_count;
    @API(help="Total number of columns in the Frame", direction=API.Direction.INOUT)
    public int total_column_count;
    @API(help="checksum", direction=API.Direction.OUTPUT)
    public long checksum;
    @API(help="Number of rows in the Frame", direction=API.Direction.OUTPUT)
    public long rows;
    @API(help="Default percentiles, from 0 to 1", direction=API.Direction.OUTPUT)
    public double[] default_percentiles;
    @API(help="Columns in the Frame", direction=API.Direction.OUTPUT)
    public ColV3[] columns;
    @API(help="Compatible models, if requested", direction=API.Direction.OUTPUT)
    public String[] compatible_models;
    @API(help="Chunk summary", direction=API.Direction.OUTPUT)
    public TwoDimTableBase chunk_summary;
    @API(help="Distribution summary", direction=API.Direction.OUTPUT)
    public TwoDimTableBase distribution_summary;

    public FrameV3() {
    }

    FrameV3(Key frame_id) {
        this.frame_id = new KeyV3.FrameKeyV3((Key<Frame>)frame_id);
    }

    FrameV3(Frame fr) {
        this(fr, 1L, (int)fr.numRows(), 0, 0);
    }

    FrameV3(Frame f, long row_offset, int row_count) {
        this(f, row_offset, row_count, 0, 0);
    }

    FrameV3(Frame f, long row_offset, int row_count, int column_offset, int column_count) {
        this.fillFromImpl(f, row_offset, row_count, column_offset, column_count);
    }

    @Override
    public FrameV3 fillFromImpl(Frame f) {
        return this.fillFromImpl(f, 1L, (int)f.numRows(), 0, 0);
    }

    public FrameV3 fillFromImpl(Frame f, long row_offset, int row_count, int column_offset, int column_count) {
        int i;
        if (row_count == 0) {
            row_count = 100;
        }
        if (column_count == 0) {
            column_count = f.numCols() - column_offset;
        }
        row_count = (int)Math.min((long)row_count, row_offset + f.numRows());
        column_count = Math.min(column_count, column_offset + f.numCols());
        this.frame_id = new KeyV3.FrameKeyV3((Key<Frame>)f._key);
        this.checksum = f.checksum();
        this.byte_size = f.byteSize();
        this.row_offset = row_offset;
        this.rows = f.numRows();
        this.row_count = row_count;
        this.total_column_count = f.numCols();
        this.column_offset = column_offset;
        this.column_count = column_count;
        this.columns = new ColV3[column_count];
        Vec[] vecs = f.vecs();
        Futures fs = new Futures();
        for (i = 0; i < column_count; ++i) {
            vecs[column_offset + i].startRollupStats(fs);
        }
        for (i = 0; i < column_count; ++i) {
            this.columns[i] = new ColV3(f._names[column_offset + i], vecs[column_offset + i], this.row_offset, this.row_count);
        }
        fs.blockForPending();
        this.is_text = f.numCols() == 1 && vecs[0] instanceof ByteVec;
        this.default_percentiles = Vec.PERCENTILES;
        ChunkSummary cs = FrameUtils.chunkSummary(f);
        TwoDimTable chunk_summary_table = cs.toTwoDimTableChunkTypes();
        this.chunk_summary = (TwoDimTableBase)Schema.schema(this.getSchemaVersion(), chunk_summary_table).fillFromImpl(chunk_summary_table);
        TwoDimTable distribution_summary_table = cs.toTwoDimTableDistribution();
        this.distribution_summary = (TwoDimTableBase)Schema.schema(this.getSchemaVersion(), distribution_summary_table).fillFromImpl(distribution_summary_table);
        this._fr = f;
        return this;
    }

    public void clearBinsField() {
        for (ColV3 col : this.columns) {
            col.clearBinsField();
        }
    }

    private String rollUpStr(ColV3 c, double d) {
        return this.formatCell(c.domain != null || "uuid".equals(c.type) || "string".equals(c.type) ? Double.NaN : d, null, c, 4);
    }

    private String formatCell(double d, String str, ColV3 c, int precision) {
        if (Double.isNaN(d)) {
            return "-";
        }
        if (c.domain != null) {
            return c.domain[(int)d];
        }
        if ("uuid".equals(c.type) || "string".equals(c.type)) {
            if (str == null) {
                return "-";
            }
            return "<b style=\"font-family:monospace;\">" + str + "</b>";
        }
        Chunk chk = c._vec.chunkForRow(this.row_offset);
        return PrettyPrint.number(chk, d, precision);
    }

    private static abstract class ColOp {
        private ColOp() {
        }

        abstract String op(ColV3 var1);
    }

    public static class ColV3
    extends Schema<Vec, ColV3> {
        @API(help="label", direction=API.Direction.OUTPUT)
        public String label;
        @API(help="missing", direction=API.Direction.OUTPUT)
        public long missing_count;
        @API(help="zeros", direction=API.Direction.OUTPUT)
        public long zero_count;
        @API(help="positive infinities", direction=API.Direction.OUTPUT)
        public long positive_infinity_count;
        @API(help="negative infinities", direction=API.Direction.OUTPUT)
        public long negative_infinity_count;
        @API(help="mins", direction=API.Direction.OUTPUT)
        public double[] mins;
        @API(help="maxs", direction=API.Direction.OUTPUT)
        public double[] maxs;
        @API(help="mean", direction=API.Direction.OUTPUT)
        public double mean;
        @API(help="sigma", direction=API.Direction.OUTPUT)
        public double sigma;
        @API(help="datatype: {enum, string, int, real, time, uuid}", direction=API.Direction.OUTPUT)
        public String type;
        @API(help="domain; not-null for categorical columns only", direction=API.Direction.OUTPUT)
        public String[] domain;
        @API(help="cardinality of this column's domain; not-null for categorical columns only", direction=API.Direction.OUTPUT)
        public int domain_cardinality;
        @API(help="data", direction=API.Direction.OUTPUT)
        public double[] data;
        @API(help="string data", direction=API.Direction.OUTPUT)
        public String[] string_data;
        @API(help="decimal precision, -1 for all digits", direction=API.Direction.OUTPUT)
        public byte precision;
        @API(help="Histogram bins; null if not computed", direction=API.Direction.OUTPUT)
        public long[] histogram_bins;
        @API(help="Start of histogram bin zero", direction=API.Direction.OUTPUT)
        public double histogram_base;
        @API(help="Stride per bin", direction=API.Direction.OUTPUT)
        public double histogram_stride;
        @API(help="Percentile values, matching the default percentiles", direction=API.Direction.OUTPUT)
        public double[] percentiles;
        transient Vec _vec;

        public ColV3() {
        }

        ColV3(String name, Vec vec, long off, int len) {
            this.label = name;
            this.missing_count = vec.naCnt();
            this.zero_count = vec.length() - vec.nzCnt() - this.missing_count;
            this.positive_infinity_count = vec.pinfs();
            this.negative_infinity_count = vec.ninfs();
            this.mins = vec.mins();
            this.maxs = vec.maxs();
            this.mean = vec.mean();
            this.sigma = vec.sigma();
            this.histogram_bins = vec.lazy_bins();
            this.histogram_base = this.histogram_bins == null ? 0.0 : vec.base();
            this.histogram_stride = this.histogram_bins == null ? 0.0 : vec.stride();
            double[] dArray = this.percentiles = this.histogram_bins == null ? null : vec.pctiles();
            this.type = vec.isCategorical() ? "enum" : (vec.isUUID() ? "uuid" : (vec.isString() ? "string" : (vec.isInt() ? (vec.isTime() ? "time" : "int") : "real")));
            this.domain = vec.domain();
            this.domain_cardinality = vec.isCategorical() ? this.domain.length : 0;
            len = (int)Math.min((long)len, vec.length() - off);
            if (vec.isUUID()) {
                this.string_data = new String[len];
                for (int i = 0; i < len; ++i) {
                    this.string_data[i] = vec.isNA(off + (long)i) ? null : PrettyPrint.UUID(vec.at16l(off + (long)i), vec.at16h(off + (long)i));
                }
                this.data = null;
            } else if (vec.isString()) {
                this.string_data = new String[len];
                BufferedString tmpStr = new BufferedString();
                for (int i = 0; i < len; ++i) {
                    this.string_data[i] = vec.isNA(off + (long)i) ? null : vec.atStr(tmpStr, off + (long)i).toString();
                }
                this.data = null;
            } else {
                this.data = MemoryManager.malloc8d(len);
                for (int i = 0; i < len; ++i) {
                    this.data[i] = vec.at(off + (long)i);
                }
                this.string_data = null;
            }
            this._vec = vec;
            if (len > 0) {
                this.precision = vec.chunkForRow(0L).precision();
            }
        }

        public void clearBinsField() {
            this.histogram_bins = null;
        }
    }

    public static class ColSpecifierV3
    extends Schema<Frame.VecSpecifier, ColSpecifierV3> {
        @API(help="Name of the column", direction=API.Direction.INOUT)
        public String column_name;
        @API(help="List of fields which specify columns that must contain this column", direction=API.Direction.INOUT)
        public String[] is_member_of_frames;

        public ColSpecifierV3() {
        }

        public ColSpecifierV3(String column_name) {
            this.column_name = column_name;
        }
    }
}

