/*
 * Decompiled with CFR 0.152.
 */
package water.api;

import hex.Model;
import hex.ModelBuilder;
import hex.schemas.ModelBuilderSchema;
import java.util.Properties;
import water.H2O;
import water.Job;
import water.Key;
import water.TypeMap;
import water.api.Handler;
import water.api.ModelParametersSchema;
import water.api.Route;
import water.api.Schema;
import water.util.HttpResponseStatus;
import water.util.PojoUtils;

public class ModelBuilderHandler<B extends ModelBuilder, S extends ModelBuilderSchema<B, S, P>, P extends ModelParametersSchema>
extends Handler {
    @Override
    Schema handle(int version, Route route, Properties parms) throws Exception {
        String[] ss = route._url_pattern_raw.split("/");
        String algoURLName = ss[3];
        String algoName = ModelBuilder.algoName(algoURLName);
        String schemaDir = ModelBuilder.schemaDirectory(algoURLName);
        String schemaName = schemaDir + algoName + "V" + version;
        ModelBuilderSchema schema = (ModelBuilderSchema)TypeMap.newFreezable(schemaName);
        schema.init_meta();
        String parmName = schemaDir + algoName + "V" + version + "$" + algoName + "ParametersV" + version;
        ModelParametersSchema parmSchema = (ModelParametersSchema)TypeMap.newFreezable(parmName);
        schema.parameters = parmSchema;
        String handlerName = route._handler_method.getName();
        boolean doTrain = handlerName.equals("train");
        assert (doTrain || handlerName.equals("validate_parameters"));
        String model_id = parms.getProperty("model_id");
        Key<Model> key = doTrain ? (model_id == null ? ModelBuilder.defaultKey(algoName) : Key.make(model_id)) : null;
        Job<Model> job = doTrain ? new Job<Model>(key, ModelBuilder.javaName(algoURLName), algoName) : null;
        Object builder = ModelBuilder.make(algoURLName, job, key);
        ((ModelParametersSchema)schema.parameters).fillFromImpl(((ModelBuilder)builder)._parms);
        ((Schema)schema.parameters).fillFromParms(parms);
        ((ModelParametersSchema)schema.parameters).fillImpl(((ModelBuilder)builder)._parms);
        ((ModelBuilder)builder).init(false);
        this._t_start = System.currentTimeMillis();
        if (doTrain) {
            ((ModelBuilder)builder).trainModel();
        }
        this._t_stop = System.currentTimeMillis();
        schema.fillFromImpl(builder);
        PojoUtils.copyProperties(schema.parameters, ((ModelBuilder)builder)._parms, PojoUtils.FieldNaming.ORIGIN_HAS_UNDERSCORES, null, new String[]{"error_count", "messages"});
        schema.setHttpStatus(HttpResponseStatus.OK.getCode());
        return schema;
    }

    public S train(int version, S schema) {
        throw H2O.fail();
    }

    public S validate_parameters(int version, S schema) {
        throw H2O.fail();
    }
}

