/*
 * Decompiled with CFR 0.152.
 */
package water.api;

import java.lang.reflect.Field;
import water.AutoBuffer;
import water.H2O;
import water.Iced;
import water.IcedWrapper;
import water.api.API;
import water.api.ModelParametersSchema;
import water.api.Schema;
import water.api.SchemaMetadata;
import water.util.PojoUtils;

public class ModelParameterSchemaV3
extends Schema<Iced, ModelParameterSchemaV3> {
    @API(help="name in the JSON, e.g. \"lambda\"", direction=API.Direction.OUTPUT)
    public String name;
    @API(help="label in the UI, e.g. \"lambda\"", direction=API.Direction.OUTPUT)
    public String label;
    @API(help="help for the UI, e.g. \"regularization multiplier, typically used for foo bar baz etc.\"", direction=API.Direction.OUTPUT)
    public String help;
    @API(help="the field is required", direction=API.Direction.OUTPUT)
    public boolean required;
    @API(help="Java type, e.g. \"double\"", direction=API.Direction.OUTPUT)
    public String type;
    @API(help="default value, e.g. 1", direction=API.Direction.OUTPUT)
    public Iced default_value;
    @API(help="actual value as set by the user and / or modified by the ModelBuilder, e.g., 10", direction=API.Direction.OUTPUT)
    public Iced actual_value;
    @API(help="the importance of the parameter, used by the UI, e.g. \"critical\", \"extended\" or \"expert\"", direction=API.Direction.OUTPUT)
    public String level;
    @API(help="list of valid values for use by the front-end", direction=API.Direction.OUTPUT)
    public String[] values;
    @API(help="For Vec-type fields this is the set of other Vec-type fields which must contain mutually exclusive values; for example, for a SupervisedModel the response_column must be mutually exclusive with the weights_column")
    public String[] is_member_of_frames;
    @API(help="For Vec-type fields this is the set of Frame-type fields which must contain the named column; for example, for a SupervisedModel the response_column must be in both the training_frame and (if it's set) the validation_frame")
    public String[] is_mutually_exclusive_with;
    @API(help="Parameter can be used in grid call", direction=API.Direction.OUTPUT)
    public boolean gridable;

    public ModelParameterSchemaV3() {
    }

    public ModelParameterSchemaV3(ModelParametersSchema schema, ModelParametersSchema default_schema, Field f) {
        f.setAccessible(true);
        try {
            this.name = f.getName();
            boolean is_array = f.getType().isArray();
            Object o = f.get(default_schema);
            this.default_value = SchemaMetadata.FieldMetadata.consValue(o);
            o = f.get(schema);
            this.actual_value = SchemaMetadata.FieldMetadata.consValue(o);
            boolean is_enum = Enum.class.isAssignableFrom(f.getType());
            this.type = SchemaMetadata.FieldMetadata.consType(schema, f.getType(), f.getName());
            API annotation = f.getAnnotation(API.class);
            if (null != annotation) {
                String l = annotation.label();
                this.label = null == l || l.isEmpty() ? f.getName() : l;
                this.help = annotation.help();
                this.required = annotation.required();
                this.level = annotation.level().toString();
                this.values = annotation.values();
                if (is_enum && (null == this.values || 0 == this.values.length)) {
                    throw H2O.fail("Didn't find values annotation for enum field: " + this.name);
                }
                this.is_member_of_frames = annotation.is_member_of_frames();
                this.is_mutually_exclusive_with = annotation.is_mutually_exclusive_with();
                this.gridable = annotation.gridable();
            }
        }
        catch (Exception e) {
            throw H2O.fail("Caught exception accessing field: " + f + " for schema object: " + this + ": " + e.toString());
        }
    }

    @Override
    public ModelParameterSchemaV3 fillFromImpl(Iced iced) {
        PojoUtils.copyProperties(this, iced, PojoUtils.FieldNaming.ORIGIN_HAS_UNDERSCORES);
        return this;
    }

    @Override
    public Iced createImpl() {
        throw H2O.fail("createImpl should never get called in ModelParameterSchemaV2!");
    }

    public final AutoBuffer writeJSON_impl(AutoBuffer ab) {
        ab.putJSONStr("name", this.name);
        ab.put1(44);
        ab.putJSONStr("label", this.label);
        ab.put1(44);
        ab.putJSONStr("help", this.help);
        ab.put1(44);
        ab.putJSONStrUnquoted("required", this.required ? "true" : "false");
        ab.put1(44);
        ab.putJSONStr("type", this.type);
        ab.put1(44);
        if (this.default_value instanceof IcedWrapper) {
            ab.putJSONStr("default_value").put1(58);
            ((IcedWrapper)this.default_value).writeUnwrappedJSON(ab);
            ab.put1(44);
        } else {
            ab.putJSONStr("default_value").put1(58).putJSON(this.default_value);
            ab.put1(44);
        }
        if (this.actual_value instanceof IcedWrapper) {
            ab.putJSONStr("actual_value").put1(58);
            ((IcedWrapper)this.actual_value).writeUnwrappedJSON(ab);
            ab.put1(44);
        } else {
            ab.putJSONStr("actual_value").put1(58).putJSON(this.actual_value);
            ab.put1(44);
        }
        ab.putJSONStr("level", this.level);
        ab.put1(44);
        ab.putJSONAStr("values", this.values);
        ab.put1(44);
        ab.putJSONAStr("is_member_of_frames", this.is_member_of_frames);
        ab.put1(44);
        ab.putJSONAStr("is_mutually_exclusive_with", this.is_mutually_exclusive_with);
        ab.put1(44);
        ab.putJSONStrUnquoted("gridable", this.gridable ? "true" : "false");
        return ab;
    }
}

