/*
 * Decompiled with CFR 0.152.
 */
package water.api;

import hex.Model;
import water.Iced;
import water.Key;
import water.api.API;
import water.api.KeyV3;
import water.api.Schema;

public class ModelSchemaBase<M extends Iced, S extends Schema<M, S>>
extends Schema<M, S> {
    @API(help="Model key", required=true, direction=API.Direction.INOUT)
    public KeyV3.ModelKeyV3 model_id;
    @API(help="The algo name for this Model.", direction=API.Direction.OUTPUT)
    public String algo;
    @API(help="The pretty algo name for this Model (e.g., Generalized Linear Model, rather than GLM).", direction=API.Direction.OUTPUT)
    public String algo_full_name;
    @API(help="The response column name for this Model (if applicable). Is null otherwise.", direction=API.Direction.OUTPUT)
    public String response_column_name;
    @API(help="The Model's training frame key", direction=API.Direction.OUTPUT)
    public KeyV3.FrameKeyV3 data_frame;
    @API(help="Timestamp for when this model was completed", direction=API.Direction.OUTPUT)
    public long timestamp;

    public ModelSchemaBase() {
    }

    public ModelSchemaBase(Model m) {
        this.model_id = new KeyV3.ModelKeyV3((Key<? extends Model>)m._key);
        this.algo = ((Model.Parameters)m._parms).algoName().toLowerCase();
        this.algo_full_name = ((Model.Parameters)m._parms).fullName();
        this.data_frame = new KeyV3.FrameKeyV3(((Model.Parameters)m._parms)._train);
        this.response_column_name = ((Model.Parameters)m._parms)._response_column;
        this.timestamp = ((Model.Output)m._output)._job == null ? -1L : (((Model.Output)m._output)._job.isRunning() ? 0L : ((Model.Output)m._output)._job.end_time());
    }
}

