/*
 * Decompiled with CFR 0.152.
 */
package water.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import water.DKV;
import water.Key;
import water.api.Handler;
import water.api.ParseSetupV3;
import water.exceptions.H2OIllegalArgumentException;
import water.parser.ParseSetup;
import water.util.PojoUtils;

public class ParseSetupHandler
extends Handler {
    public ParseSetupV3 guessSetup(int version, ParseSetupV3 p) {
        int i;
        if (p.source_frames == null) {
            throw new H2OIllegalArgumentException("No file names given for parsing.");
        }
        Key[] fkeys = new Key[p.source_frames.length];
        for (i = 0; i < p.source_frames.length; ++i) {
            fkeys[i] = p.source_frames[i].key();
            if (DKV.get(fkeys[i]) != null) continue;
            throw new IllegalArgumentException("Key not loaded: " + p.source_frames[i]);
        }
        if (p.na_strings != null) {
            for (i = 0; i < p.na_strings.length; ++i) {
                if (p.na_strings[i] == null || p.na_strings[i].length != 0) continue;
                p.na_strings[i] = null;
            }
        }
        ParseSetup ps = ParseSetup.guessSetup(fkeys, new ParseSetup(p));
        if (ps._errs != null && ps._errs.length > 0) {
            p.warnings = new String[ps._errs.length];
            for (int i2 = 0; i2 < ps._errs.length; ++i2) {
                p.warnings[i2] = ps._errs[i2].toString();
            }
        }
        if ((null == p.column_name_filter || "".equals(p.column_name_filter)) && 0 == p.column_offset && 0 == p.column_count) {
            PojoUtils.copyProperties(p, ps, PojoUtils.FieldNaming.ORIGIN_HAS_UNDERSCORES, new String[]{"destination_key", "source_keys", "column_types"});
            p.total_filtered_column_count = p.number_columns;
        } else {
            PojoUtils.copyProperties(p, ps, PojoUtils.FieldNaming.ORIGIN_HAS_UNDERSCORES, new String[]{"destination_key", "source_keys", "column_types", "data"});
            String[] all_col_names = ps.getColumnNames();
            String[][] data = ps.getData();
            ArrayList<Integer> keep_indexes = new ArrayList<Integer>();
            if (null != p.column_name_filter && !"".equals(p.column_name_filter)) {
                Pattern pattern = Pattern.compile(p.column_name_filter);
                Matcher m = pattern.matcher("dummy");
                for (int column = 0; column < all_col_names.length; ++column) {
                    m.reset(all_col_names[column]);
                    if (!m.matches()) continue;
                    keep_indexes.add(column);
                }
            } else {
                for (int column = 0; column < all_col_names.length; ++column) {
                    keep_indexes.add(column);
                }
            }
            int width_to_return = Math.max(0, keep_indexes.size() - p.column_offset);
            if (p.column_count > 0) {
                width_to_return = Math.min(width_to_return, p.column_count);
            }
            String[][] filtered_data = new String[data.length][width_to_return];
            for (int row = 0; row < data.length; ++row) {
                int output_column = 0;
                for (int input_column_index = p.column_offset; input_column_index < p.column_offset + width_to_return; ++input_column_index) {
                    filtered_data[row][output_column++] = data[row][(Integer)keep_indexes.get(input_column_index)];
                }
            }
            p.data = filtered_data;
            p.total_filtered_column_count = keep_indexes.size();
        }
        p.destination_frame = ParseSetup.createHexName(p.source_frames[0].toString());
        if (p.check_header == 1 && Arrays.equals(p.column_names, p.data[0])) {
            p.data = (String[][])Arrays.copyOfRange(p.data, 1, p.data.length);
        }
        p.column_types = ps.getColumnTypeStrings();
        return p;
    }
}

