/*
 * Decompiled with CFR 0.152.
 */
package water.api;

import com.google.code.regexp.Matcher;
import com.google.code.regexp.Pattern;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicLong;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import water.DKV;
import water.H2O;
import water.H2OError;
import water.H2OModelBuilderError;
import water.H2ONode;
import water.NanoHTTPD;
import water.api.AboutHandler;
import water.api.AssemblyHandler;
import water.api.AssemblyV99;
import water.api.CloudHandler;
import water.api.CreateFrameHandler;
import water.api.DCTTransformerHandler;
import water.api.DownloadDataHandler;
import water.api.FindHandler;
import water.api.FramesHandler;
import water.api.GarbageCollectHandler;
import water.api.GridsHandler;
import water.api.H2OErrorV3;
import water.api.H2OModelBuilderErrorV3;
import water.api.Handler;
import water.api.HandlerFactory;
import water.api.ImportFilesHandler;
import water.api.InitIDHandler;
import water.api.InteractionHandler;
import water.api.JStackHandler;
import water.api.JobsHandler;
import water.api.KillMinus3Handler;
import water.api.LogAndEchoHandler;
import water.api.LogsHandler;
import water.api.MetadataHandler;
import water.api.MissingInserterHandler;
import water.api.ModelBuildersHandler;
import water.api.ModelMetricsHandler;
import water.api.ModelsHandler;
import water.api.NetworkTestHandler;
import water.api.NodePersistentStorageHandler;
import water.api.ParseHandler;
import water.api.ParseSetupHandler;
import water.api.ProfilerHandler;
import water.api.RapidsHandler;
import water.api.RemoveAllHandler;
import water.api.RemoveHandler;
import water.api.RequestType;
import water.api.Route;
import water.api.Schema;
import water.api.ShutdownHandler;
import water.api.SpecifiesHttpResponseCode;
import water.api.SplitFrameHandler;
import water.api.StreamingSchema;
import water.api.TabulateHandler;
import water.api.TimelineHandler;
import water.api.TypeaheadHandler;
import water.api.UnlockKeysHandler;
import water.api.WaterMeterCpuTicksHandler;
import water.api.WaterMeterIoHandler;
import water.exceptions.H2OAbstractRuntimeException;
import water.exceptions.H2OFailException;
import water.exceptions.H2OIllegalArgumentException;
import water.exceptions.H2OModelBuilderIllegalArgumentException;
import water.exceptions.H2ONotFoundArgumentException;
import water.fvec.Frame;
import water.init.JarHash;
import water.init.NodePersistentStorage;
import water.nbhm.NonBlockingHashMap;
import water.rapids.Assembly;
import water.util.GAUtils;
import water.util.GetLogsFromNode;
import water.util.HttpResponseStatus;
import water.util.JCodeGen;
import water.util.Log;
import water.util.PojoUtils;

public class RequestServer
extends NanoHTTPD {
    public static final int H2O_REST_API_VERSION = 3;
    public static RequestServer SERVER;
    private static final LinkedHashMap<java.util.regex.Pattern, Route> _routes;
    private static final LinkedHashMap<java.util.regex.Pattern, Route> _fallbacks;
    private static Pattern version_pattern;
    private static final NonBlockingHashMap<String, byte[]> _cache;

    private RequestServer() {
    }

    public static int numRoutes() {
        return _routes.size();
    }

    public static Collection<Route> routes() {
        return _routes.values();
    }

    private static Pattern getVersionPattern() {
        if (null == version_pattern) {
            version_pattern = Pattern.compile((String)"^/(\\d+|EXPERIMENTAL)/(.*)");
        }
        return version_pattern;
    }

    public static Route register(String uri_pattern_raw, String http_method, Class<? extends Handler> handler_class, String handler_method, String doc_method, String summary, HandlerFactory handler_factory) {
        assert (uri_pattern_raw.startsWith("/"));
        Method meth = null;
        Method doc_meth = null;
        try {
            for (Method m : handler_class.getMethods()) {
                Class<?>[] params;
                if (!m.getName().equals(handler_method) || null == (params = m.getParameterTypes()) || params.length != 2 || params[0] != Integer.TYPE || !Schema.class.isAssignableFrom(params[1])) continue;
                meth = m;
                break;
            }
            if (null != doc_method) {
                doc_meth = handler_class.getMethod(doc_method, Integer.TYPE, StringBuffer.class);
            }
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        if (null == meth) {
            throw H2O.fail("Failed to find handler method: " + handler_method + " for handler class: " + handler_class);
        }
        if (null != doc_method && null == doc_meth) {
            throw H2O.fail("Failed to find doc method: " + doc_method + " for handler class: " + handler_class);
        }
        if (!"/".equals(uri_pattern_raw)) {
            Matcher m = RequestServer.getVersionPattern().matcher((CharSequence)uri_pattern_raw);
            if (!m.matches()) {
                throw H2O.fail("Route URL pattern must begin with a version: " + uri_pattern_raw);
            }
            int version = Integer.valueOf(m.group(1));
            if (version > Schema.getHighestSupportedVersion() && version != Schema.getExperimentalVersion()) {
                throw H2O.fail("Route version is greater than the max supported of: " + Schema.getHighestSupportedVersion() + ": " + uri_pattern_raw);
            }
        }
        String group_pattern_raw = "\\?<([\\p{Alnum}_]+)>";
        ArrayList<String> params_list = new ArrayList<String>();
        Pattern group_pattern = Pattern.compile((String)group_pattern_raw);
        Matcher group_matcher = group_pattern.matcher((CharSequence)uri_pattern_raw);
        StringBuffer new_uri_buffer = new StringBuffer();
        while (group_matcher.find()) {
            String group = group_matcher.group(1);
            params_list.add(group);
            group_matcher.appendReplacement(new_uri_buffer, "?<" + group.replace("_", "") + ">");
        }
        group_matcher.appendTail(new_uri_buffer);
        uri_pattern_raw = new_uri_buffer.toString();
        assert (RequestServer.lookup(handler_method, uri_pattern_raw) == null);
        Pattern uri_pattern = Pattern.compile((String)uri_pattern_raw);
        Route route = new Route(http_method, uri_pattern_raw, uri_pattern, summary, handler_class, meth, doc_meth, params_list.toArray(new String[params_list.size()]), handler_factory);
        _routes.put(uri_pattern.pattern(), route);
        return route;
    }

    public static Route register(String uri_pattern_raw, String http_method, Class<? extends Handler> handler_class, String handler_method, String doc_method, String summary) {
        return RequestServer.register(uri_pattern_raw, http_method, handler_class, handler_method, doc_method, summary, HandlerFactory.DEFAULT);
    }

    protected static Route lookup(String http_method, String uri) {
        if (null == http_method || null == uri) {
            return null;
        }
        for (Route r : _routes.values()) {
            if (!r._url_pattern.matcher((CharSequence)uri).matches() || !http_method.equals(r._http_method)) continue;
            return r;
        }
        for (Route r : _fallbacks.values()) {
            if (!r._url_pattern.matcher((CharSequence)uri).matches() || !http_method.equals(r._http_method)) continue;
            return r;
        }
        Matcher m = RequestServer.getVersionPattern().matcher((CharSequence)uri);
        if (!m.matches()) {
            return null;
        }
        int version = Integer.valueOf(m.group(1));
        if (version == 1) {
            return null;
        }
        String lower_uri = "/" + (version - 1) + "/" + m.group(2);
        Route fallback = RequestServer.lookup(http_method, lower_uri);
        if (null == fallback) {
            return null;
        }
        Matcher route_m = version_pattern.matcher((CharSequence)fallback._url_pattern_raw);
        if (!route_m.matches()) {
            throw H2O.fail("Found a fallback route that doesn't have a version: " + fallback);
        }
        int route_version = Integer.valueOf(route_m.group(1));
        for (int i = version; i > route_version && i >= 1; --i) {
            String fallback_route_uri = "/" + i + "/" + route_m.group(2);
            Pattern fallback_route_pattern = Pattern.compile((String)fallback_route_uri);
            Route generated = new Route(fallback._http_method, fallback_route_uri, fallback_route_pattern, fallback._summary, fallback._handler_class, fallback._handler_method, fallback._doc_method, fallback._path_params, fallback._handler_factory);
            _fallbacks.put(fallback_route_pattern.pattern(), generated);
        }
        return RequestServer.lookup(http_method, uri);
    }

    public static void finalizeRegistration() {
        Schema.registerAllSchemasIfNecessary();
        SERVER = new RequestServer();
        H2O.getJetty().acceptRequests();
    }

    public static void alwaysLogRequest(String uri, String method, Properties parms) {
        throw H2O.fail();
    }

    boolean maybeLogRequest(String method, String uri, String pattern, Properties parms, Properties header) {
        if (uri.endsWith(".css") || uri.endsWith(".js") || uri.endsWith(".png") || uri.endsWith(".ico")) {
            return false;
        }
        if (uri.contains("/Cloud") || uri.contains("/Jobs") && method.equals("GET") || uri.contains("/Log") || uri.contains("/Progress") || uri.contains("/Typeahead") || uri.contains("/WaterMeterCpuTicks")) {
            return false;
        }
        String paddedMethod = String.format("%-6s", method);
        Log.info("Method: " + paddedMethod, ", URI: " + uri + ", route: " + pattern + ", parms: " + parms);
        return true;
    }

    private void capturePathParms(Properties parms, String path, Route route) {
        Matcher m = route._url_pattern.matcher((CharSequence)path);
        if (!m.matches()) {
            throw H2O.fail("Routing regex error: Pattern matched once but not again for pattern: " + route._url_pattern.pattern() + " and path: " + path);
        }
        for (String key : route._path_params) {
            String val;
            String key_no_underscore = key.replace("_", "");
            try {
                val = m.group(key_no_underscore);
            }
            catch (IllegalArgumentException e) {
                throw H2O.fail("Missing request parameter in the URL: did not find " + key + " in the URL as expected; URL pattern: " + route._url_pattern.pattern() + " with expected parameters: " + Arrays.toString(route._path_params) + " for URL: " + path);
            }
            if (null == val) continue;
            parms.put(key, val);
        }
    }

    private NanoHTTPD.Response response404(String what, RequestType type) {
        H2ONotFoundArgumentException e = new H2ONotFoundArgumentException(what + " not found", what + " not found");
        H2OError error = e.toH2OError(what);
        Log.warn(error._dev_msg);
        Log.warn(error._values.toJsonString());
        Log.warn(error._stacktrace);
        return this.wrap((Schema)new H2OErrorV3().fillFromImpl(error), type);
    }

    @Override
    public NanoHTTPD.Response serve(String uri, String method, Properties header, Properties parms) {
        Thread.currentThread().setPriority(9);
        if (uri.startsWith("/LATEST")) {
            uri = -1 == Schema.getLatestVersion() ? "/" + Schema.getHighestSupportedVersion() + uri.substring("/latest".length()) : "/" + Schema.getLatestVersion() + uri.substring("/latest".length());
        }
        RequestType type = RequestType.requestType(uri);
        if (uri.equals("/") && method.equals("HEAD")) {
            NanoHTTPD.Response r = (NanoHTTPD)this.new NanoHTTPD.Response("200 OK", "text/plain", "");
            return r;
        }
        String versioned_path = uri;
        String path = uri;
        int version = 1;
        Matcher m = RequestServer.getVersionPattern().matcher((CharSequence)uri);
        if (m.matches()) {
            version = "EXPERIMENTAL".equals(m.group(1)) ? 99 : Integer.valueOf(m.group(1));
            String uripath = "/" + m.group(2);
            path = type.requestName(uripath);
            versioned_path = "/" + version + path;
        }
        try {
            Pattern p2;
            Matcher m2;
            boolean b2;
            if (method.equals("GET") && uri.equals("/")) {
                boolean logged = this.maybeLogRequest(method, uri, "", parms, header);
                if (logged) {
                    GAUtils.logRequest(uri, header);
                }
                return this.redirectToFlow();
            }
            if (method.equals("GET") && uri.endsWith("/Logs/download")) {
                boolean logged = this.maybeLogRequest(method, uri, "", parms, header);
                if (logged) {
                    GAUtils.logRequest(uri, header);
                }
                return this.downloadLogs();
            }
            if (method.equals("GET") && (b2 = (m2 = (p2 = Pattern.compile((String)".*/NodePersistentStorage.bin/([^/]+)/([^/]+)")).matcher((CharSequence)uri)).matches())) {
                String categoryName = m2.group(1);
                String keyName = m2.group(2);
                return this.downloadNps(categoryName, keyName);
            }
            Route route = RequestServer.lookup(method, versioned_path);
            if (route == null) {
                if (method.equals("GET")) {
                    return this.getResource(type, uri);
                }
                return this.response404(method + " " + uri, type);
            }
            this.capturePathParms(parms, versioned_path, route);
            boolean logged = this.maybeLogRequest(method, uri, route._url_pattern.namedPattern(), parms, header);
            if (logged) {
                GAUtils.logRequest(uri, header);
            }
            Schema s = this.handle(type, route, version, parms);
            PojoUtils.filterFields(s, (String)parms.get("_include_fields"), (String)parms.get("_exclude_fields"));
            NanoHTTPD.Response r = this.wrap(s, type);
            return r;
        }
        catch (H2OFailException e) {
            H2OError error = e.toH2OError(uri);
            Log.fatal("Caught exception (fatal to the cluster): " + error.toString());
            H2O.fail(this.wrap((Schema)new H2OErrorV3().fillFromImpl(error), type).toString());
            return null;
        }
        catch (H2OModelBuilderIllegalArgumentException e) {
            H2OModelBuilderError error = e.toH2OError(uri);
            Log.warn("Caught exception: " + error.toString());
            return this.wrap((Schema)new H2OModelBuilderErrorV3().fillFromImpl(error), type);
        }
        catch (H2OAbstractRuntimeException e) {
            H2OError error = e.toH2OError(uri);
            Log.warn("Caught exception: " + error.toString());
            return this.wrap((Schema)new H2OErrorV3().fillFromImpl(error), type);
        }
        catch (Exception e) {
            H2OError error = new H2OError(e, uri);
            if (e instanceof IllegalArgumentException) {
                error._http_status = HttpResponseStatus.BAD_REQUEST.getCode();
            } else if (e instanceof FileNotFoundException) {
                error._http_status = HttpResponseStatus.BAD_REQUEST.getCode();
            } else if (e instanceof MalformedURLException) {
                error._http_status = HttpResponseStatus.BAD_REQUEST.getCode();
            }
            Log.err("Caught exception: " + error.toString());
            return this.wrap((Schema)new H2OErrorV3().fillFromImpl(error), type);
        }
    }

    private Schema handle(RequestType type, Route route, int version, Properties parms) throws Exception {
        switch (type) {
            case html: 
            case java: 
            case json: 
            case xml: {
                Handler h = route._handler;
                return h.handle(version, route, parms);
            }
        }
        throw H2O.unimpl("Unknown type: " + type.toString());
    }

    private NanoHTTPD.Response wrap(Schema s, RequestType type) {
        String http_response_header = H2OError.httpStatusHeader(HttpResponseStatus.OK.getCode());
        if (s instanceof SpecifiesHttpResponseCode) {
            http_response_header = H2OError.httpStatusHeader(((SpecifiesHttpResponseCode)((Object)s)).httpStatus());
        }
        if (s instanceof SpecifiesHttpResponseCode && HttpResponseStatus.OK.getCode() != ((SpecifiesHttpResponseCode)((Object)s)).httpStatus()) {
            type = RequestType.json;
        }
        switch (type) {
            case html: 
            case json: {
                return (NanoHTTPD)this.new NanoHTTPD.Response(http_response_header, "application/json", s.toJsonString());
            }
            case xml: {
                throw H2O.unimpl("Unknown type: " + type.toString());
            }
            case java: {
                if (s instanceof H2OErrorV3) {
                    return (NanoHTTPD)this.new NanoHTTPD.Response(http_response_header, "application/json", s.toJsonString());
                }
                if (s instanceof AssemblyV99) {
                    Assembly ass = (Assembly)DKV.getGet(((AssemblyV99)s).assembly_id);
                    NanoHTTPD.Response r = (NanoHTTPD)this.new NanoHTTPD.Response(http_response_header, "application/octet-stream", ass.toJava(((AssemblyV99)s).pojo_name));
                    r.addHeader("Content-Disposition", "attachment; filename=\"" + JCodeGen.toJavaId(((AssemblyV99)s).pojo_name) + ".java\"");
                    return r;
                }
                if (s instanceof StreamingSchema) {
                    StreamingSchema ss = (StreamingSchema)s;
                    NanoHTTPD.StreamResponse r = (NanoHTTPD)this.new NanoHTTPD.StreamResponse(http_response_header, "application/octet-stream", ss.getStreamWriter());
                    r.addHeader("Content-Disposition", "attachment; filename=\"" + ss.getFilename() + "\"");
                    return r;
                }
                throw new H2OIllegalArgumentException("Cannot generate java for type: " + s.getClass().getSimpleName());
            }
        }
        throw H2O.unimpl("Unknown type to wrap(): " + (Object)((Object)type));
    }

    private NanoHTTPD.Response getResource(RequestType request_type, String uri) {
        byte[] bytes = _cache.get(uri);
        if (bytes == null) {
            try {
                InputStream resource = JarHash.getResource2(uri);
                Throwable throwable = null;
                try {
                    if (resource != null) {
                        try {
                            bytes = RequestServer.toByteArray(resource);
                        }
                        catch (IOException e) {
                            Log.err(e);
                        }
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (resource != null) {
                        if (throwable != null) {
                            try {
                                resource.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                        } else {
                            resource.close();
                        }
                    }
                }
            }
            catch (IOException ignore) {
                // empty catch block
            }
        }
        if (bytes == null || bytes.length == 0) {
            return this.response404("Resource " + uri, request_type);
        }
        String mime = "application/octet-stream";
        if (uri.endsWith(".css")) {
            mime = "text/css";
        } else if (uri.endsWith(".html")) {
            mime = "text/html";
        }
        NanoHTTPD.Response res = (NanoHTTPD)this.new NanoHTTPD.Response("200 OK", mime, new ByteArrayInputStream(bytes));
        res.addHeader("Content-Length", Long.toString(bytes.length));
        return res;
    }

    private static byte[] toByteArray(InputStream is) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        Throwable throwable = null;
        try {
            int len;
            byte[] buffer = new byte[8192];
            while ((len = is.read(buffer)) != -1) {
                os.write(buffer, 0, len);
            }
            byte[] byArray = os.toByteArray();
            return byArray;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            if (os != null) {
                if (throwable != null) {
                    try {
                        os.close();
                    }
                    catch (Throwable x2) {
                        throwable.addSuppressed(x2);
                    }
                } else {
                    os.close();
                }
            }
        }
    }

    static String[] frameChoices(int version, Frame fr) {
        ArrayList al = new ArrayList();
        for (java.util.regex.Pattern p : _routes.keySet()) {
            try {
                Class<?> clz0;
                Method meth = RequestServer._routes.get((Object)p)._handler_method;
                Class<?> clz = clz0 = meth.getDeclaringClass();
                Handler h = (Handler)clz.newInstance();
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException ignore) {}
        }
        return al.toArray(new String[al.size()]);
    }

    private String getOutputLogStem() {
        String pattern = "yyyyMMdd_hhmmss";
        SimpleDateFormat formatter = new SimpleDateFormat(pattern);
        String now = formatter.format(new Date());
        return "h2ologs_" + now;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] zipLogs(byte[][] results, byte[] clientResult, String topDir) throws IOException {
        int l = 0;
        assert (H2O.CLOUD._memary.length == results.length) : "Unexpected change in the cloud!";
        int i = 0;
        while (i < results.length) {
            l += results[i++].length;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream(l);
        ZipOutputStream zos = new ZipOutputStream(baos);
        ZipEntry zde = new ZipEntry(topDir + File.separator);
        zos.putNextEntry(zde);
        try {
            for (int i2 = 0; i2 < results.length; ++i2) {
                String filename = topDir + File.separator + "node" + i2 + "_" + H2O.CLOUD._memary[i2].getIpPortString().replace(':', '_').replace('/', '_') + ".zip";
                ZipEntry ze = new ZipEntry(filename);
                zos.putNextEntry(ze);
                zos.write(results[i2]);
                zos.closeEntry();
            }
            if (clientResult != null) {
                String filename = topDir + File.separator + "driver.zip";
                ZipEntry ze = new ZipEntry(filename);
                zos.putNextEntry(ze);
                zos.write(clientResult);
                zos.closeEntry();
            }
            zos.closeEntry();
        }
        finally {
            zos.close();
        }
        return baos.toByteArray();
    }

    private NanoHTTPD.Response downloadLogs() {
        byte[] finalZipByteArray;
        Log.info("\nCollecting logs.");
        H2ONode[] members = H2O.CLOUD.members();
        byte[][] perNodeZipByteArray = new byte[members.length][];
        byte[] clientNodeByteArray = null;
        for (int i = 0; i < members.length; ++i) {
            byte[] bytes;
            try {
                boolean healthy;
                boolean bl = healthy = System.currentTimeMillis() - members[i]._last_heard_from < 60000L;
                if (healthy) {
                    GetLogsFromNode g = new GetLogsFromNode();
                    g.nodeidx = i;
                    g.doIt();
                    bytes = g.bytes;
                } else {
                    bytes = "Node not healthy".getBytes();
                }
            }
            catch (Exception e) {
                bytes = e.toString().getBytes();
            }
            perNodeZipByteArray[i] = bytes;
        }
        if (H2O.ARGS.client) {
            byte[] bytes;
            try {
                GetLogsFromNode g = new GetLogsFromNode();
                g.nodeidx = -1;
                g.doIt();
                bytes = g.bytes;
            }
            catch (Exception e) {
                bytes = e.toString().getBytes();
            }
            clientNodeByteArray = bytes;
        }
        String outputFileStem = this.getOutputLogStem();
        try {
            finalZipByteArray = this.zipLogs(perNodeZipByteArray, clientNodeByteArray, outputFileStem);
        }
        catch (Exception e) {
            finalZipByteArray = e.toString().getBytes();
        }
        NanoHTTPD.Response res = (NanoHTTPD)this.new NanoHTTPD.Response("200 OK", "application/octet-stream", new ByteArrayInputStream(finalZipByteArray));
        res.addHeader("Content-Length", Long.toString(finalZipByteArray.length));
        res.addHeader("Content-Disposition", "attachment; filename=" + outputFileStem + ".zip");
        return res;
    }

    private NanoHTTPD.Response downloadNps(String categoryName, String keyName) {
        NodePersistentStorage nps = H2O.getNPS();
        AtomicLong length = new AtomicLong();
        InputStream is = nps.get(categoryName, keyName, length);
        NanoHTTPD.Response res = (NanoHTTPD)this.new NanoHTTPD.Response("200 OK", "application/octet-stream", is);
        res.addHeader("Content-Length", Long.toString(length.get()));
        res.addHeader("Content-Disposition", "attachment; filename=" + keyName + ".flow");
        return res;
    }

    private NanoHTTPD.Response redirectToFlow() {
        StringBuilder sb = new StringBuilder();
        NanoHTTPD.Response res = (NanoHTTPD)this.new NanoHTTPD.Response("301 Moved Permanently", "text/plain", sb.toString());
        res.addHeader("Location", "/flow/index.html");
        return res;
    }

    static {
        _routes = new LinkedHashMap();
        _fallbacks = new LinkedHashMap();
        version_pattern = null;
        RequestServer.register("/3/CreateFrame", "POST", CreateFrameHandler.class, "run", null, "Create a synthetic H2O Frame.");
        RequestServer.register("/3/SplitFrame", "POST", SplitFrameHandler.class, "run", null, "Split a H2O Frame.");
        RequestServer.register("/3/Interaction", "POST", InteractionHandler.class, "run", null, "Create interactions between categorical columns.");
        RequestServer.register("/3/MissingInserter", "POST", MissingInserterHandler.class, "run", null, "Insert missing values.");
        RequestServer.register("/99/DCTTransformer", "POST", DCTTransformerHandler.class, "run", null, "Row-by-Row discrete cosine transforms in 1D, 2D and 3D.");
        RequestServer.register("/99/Tabulate", "POST", TabulateHandler.class, "run", null, "Tabulate one column vs another.");
        RequestServer.register("/3/ImportFiles", "GET", ImportFilesHandler.class, "importFiles", null, "Import raw data files into a single-column H2O Frame.");
        RequestServer.register("/3/ImportFiles", "POST", ImportFilesHandler.class, "importFiles", null, "Import raw data files into a single-column H2O Frame.");
        RequestServer.register("/3/ParseSetup", "POST", ParseSetupHandler.class, "guessSetup", null, "Guess the parameters for parsing raw byte-oriented data into an H2O Frame.");
        RequestServer.register("/3/Parse", "POST", ParseHandler.class, "parse", null, "Parse a raw byte-oriented Frame into a useful columnar data Frame.");
        RequestServer.register("/3/Cloud", "GET", CloudHandler.class, "status", null, "Determine the status of the nodes in the H2O cloud.");
        RequestServer.register("/3/Cloud", "HEAD", CloudHandler.class, "head", null, "Determine the status of the nodes in the H2O cloud.");
        RequestServer.register("/3/Jobs", "GET", JobsHandler.class, "list", null, "Get a list of all the H2O Jobs (long-running actions).");
        RequestServer.register("/3/Timeline", "GET", TimelineHandler.class, "fetch", null, "Debugging tool that provides information on current communication between nodes.");
        RequestServer.register("/3/Profiler", "GET", ProfilerHandler.class, "fetch", null, "Report real-time profiling information for all nodes (sorted, aggregated stack traces).");
        RequestServer.register("/3/JStack", "GET", JStackHandler.class, "fetch", null, "Report stack traces for all threads on all nodes.");
        RequestServer.register("/3/NetworkTest", "GET", NetworkTestHandler.class, "fetch", null, "Run a network test to measure the performance of the cluster interconnect.");
        RequestServer.register("/3/UnlockKeys", "POST", UnlockKeysHandler.class, "unlock", null, "Unlock all keys in the H2O distributed K/V store, to attempt to recover from a crash.");
        RequestServer.register("/3/Shutdown", "POST", ShutdownHandler.class, "shutdown", null, "Shut down the cluster");
        RequestServer.register("/3/About", "GET", AboutHandler.class, "get", null, "Return information about this H2O cluster.");
        RequestServer.register("/3/Metadata/endpoints/(?<num>[0-9]+)", "GET", MetadataHandler.class, "fetchRoute", null, "Return the REST API endpoint metadata, including documentation, for the endpoint specified by number.");
        RequestServer.register("/3/Metadata/endpoints/(?<path>.*)", "GET", MetadataHandler.class, "fetchRoute", null, "Return the REST API endpoint metadata, including documentation, for the endpoint specified by path.");
        RequestServer.register("/3/Metadata/endpoints", "GET", MetadataHandler.class, "listRoutes", null, "Return a list of all the REST API endpoints.");
        RequestServer.register("/3/Metadata/schemaclasses/(?<classname>.*)", "GET", MetadataHandler.class, "fetchSchemaMetadataByClass", null, "Return the REST API schema metadata for specified schema class.");
        RequestServer.register("/3/Metadata/schemas/(?<schemaname>.*)", "GET", MetadataHandler.class, "fetchSchemaMetadata", null, "Return the REST API schema metadata for specified schema.");
        RequestServer.register("/3/Metadata/schemas", "GET", MetadataHandler.class, "listSchemas", null, "Return list of all REST API schemas.");
        RequestServer.register("/3/Typeahead/files", "GET", TypeaheadHandler.class, "files", null, "Typehead hander for filename completion.");
        RequestServer.register("/3/Jobs/(?<job_id>.*)", "GET", JobsHandler.class, "fetch", null, "Get the status of the given H2O Job (long-running action).");
        RequestServer.register("/3/Jobs/(?<job_id>.*)/cancel", "POST", JobsHandler.class, "cancel", null, "Cancel a running job.");
        RequestServer.register("/3/Find", "GET", FindHandler.class, "find", null, "Find a value within a Frame.");
        RequestServer.register("/3/Frames/(?<frame_id>.*)/export/(?<path>.*)/overwrite/(?<force>.*)", "GET", FramesHandler.class, "export", null, "Export a Frame to the given path with optional overwrite.");
        RequestServer.register("/3/Frames/(?<frame_id>.*)/export", "POST", FramesHandler.class, "export", null, "Export a Frame to the given path with optional overwrite.");
        RequestServer.register("/3/Frames/(?<frame_id>.*)/columns/(?<column>.*)/summary", "GET", FramesHandler.class, "columnSummary", "columnSummaryDocs", "Return the summary metrics for a column, e.g. mins, maxes, mean, sigma, percentiles, etc.");
        RequestServer.register("/3/Frames/(?<frame_id>.*)/columns/(?<column>.*)/domain", "GET", FramesHandler.class, "columnDomain", null, "Return the domains for the specified column. \"null\" if the column is not a categorical.");
        RequestServer.register("/3/Frames/(?<frame_id>.*)/columns/(?<column>.*)", "GET", FramesHandler.class, "column", null, "Return the specified column from a Frame.");
        RequestServer.register("/3/Frames/(?<frame_id>.*)/columns", "GET", FramesHandler.class, "columns", null, "Return all the columns from a Frame.");
        RequestServer.register("/3/Frames/(?<frame_id>.*)/summary", "GET", FramesHandler.class, "summary", null, "Return a Frame, including the histograms, after forcing computation of rollups.");
        RequestServer.register("/3/Frames/(?<frame_id>.*)", "GET", FramesHandler.class, "fetch", null, "Return the specified Frame.");
        RequestServer.register("/3/Frames", "GET", FramesHandler.class, "list", null, "Return all Frames in the H2O distributed K/V store.");
        RequestServer.register("/3/Frames/(?<frame_id>.*)", "DELETE", FramesHandler.class, "delete", null, "Delete the specified Frame from the H2O distributed K/V store.");
        RequestServer.register("/3/Frames", "DELETE", FramesHandler.class, "deleteAll", null, "Delete all Frames from the H2O distributed K/V store.");
        RequestServer.register("/3/Models/(?<model_id>.*)", "GET", ModelsHandler.class, "fetch", null, "Return the specified Model from the H2O distributed K/V store, optionally with the list of compatible Frames.");
        RequestServer.register("/3/Models", "GET", ModelsHandler.class, "list", null, "Return all Models from the H2O distributed K/V store.");
        RequestServer.register("/3/Models/(?<model_id>.*)", "DELETE", ModelsHandler.class, "delete", null, "Delete the specified Model from the H2O distributed K/V store.");
        RequestServer.register("/3/Models", "DELETE", ModelsHandler.class, "deleteAll", null, "Delete all Models from the H2O distributed K/V store.");
        RequestServer.register("/3/Models.java/(?<model_id>.*)/preview", "GET", ModelsHandler.class, "fetchPreview", null, "Return potentially abridged model suitable for viewing in a browser (currently only used for java model code).");
        RequestServer.register("/3/Models.java/(?<model_id>.*)", "GET", ModelsHandler.class, "fetchJavaCode", null, "Return the stream containing model implementation in Java code.");
        RequestServer.register("/99/Models.bin/(?<model_id>.*)", "POST", ModelsHandler.class, "importModel", null, "Import given binary model into H2O.");
        RequestServer.register("/99/Models.bin/(?<model_id>.*)", "GET", ModelsHandler.class, "exportModel", null, "Export given model.");
        RequestServer.register("/99/Grids/(?<grid_id>.*)", "GET", GridsHandler.class, "fetch", null, "Return the specified grid search result.");
        RequestServer.register("/99/Grids", "GET", GridsHandler.class, "list", null, "Return all grids from H2O distributed K/V store.");
        RequestServer.register("/3/ModelBuilders/(?<algo>.*)/model_id", "POST", ModelBuildersHandler.class, "calcModelId", null, "Return a new unique model_id for the specified algorithm.");
        RequestServer.register("/3/ModelBuilders/(?<algo>.*)", "GET", ModelBuildersHandler.class, "fetch", null, "Return the Model Builder metadata for the specified algorithm.");
        RequestServer.register("/3/ModelBuilders", "GET", ModelBuildersHandler.class, "list", null, "Return the Model Builder metadata for all available algorithms.");
        RequestServer.register("/3/ModelMetrics/models/(?<model>.*)/frames/(?<frame>.*)", "GET", ModelMetricsHandler.class, "fetch", null, "Return the saved scoring metrics for the specified Model and Frame.");
        RequestServer.register("/3/ModelMetrics/models/(?<model>.*)/frames/(?<frame>.*)", "DELETE", ModelMetricsHandler.class, "delete", null, "Return the saved scoring metrics for the specified Model and Frame.");
        RequestServer.register("/3/ModelMetrics/models/(?<model>.*)", "GET", ModelMetricsHandler.class, "fetch", null, "Return the saved scoring metrics for the specified Model.");
        RequestServer.register("/3/ModelMetrics/frames/(?<frame>.*)/models/(?<model>.*)", "GET", ModelMetricsHandler.class, "fetch", null, "Return the saved scoring metrics for the specified Model and Frame.");
        RequestServer.register("/3/ModelMetrics/frames/(?<frame>.*)/models/(?<model>.*)", "DELETE", ModelMetricsHandler.class, "delete", null, "Return the saved scoring metrics for the specified Model and Frame.");
        RequestServer.register("/3/ModelMetrics/frames/(?<frame>.*)", "GET", ModelMetricsHandler.class, "fetch", null, "Return the saved scoring metrics for the specified Frame.");
        RequestServer.register("/3/ModelMetrics", "GET", ModelMetricsHandler.class, "fetch", null, "Return all the saved scoring metrics.");
        RequestServer.register("/3/ModelMetrics/models/(?<model>.*)/frames/(?<frame>.*)", "POST", ModelMetricsHandler.class, "score", null, "Return the scoring metrics for the specified Frame with the specified Model.  If the Frame has already been scored with the Model then cached results will be returned; otherwise predictions for all rows in the Frame will be generated and the metrics will be returned.");
        RequestServer.register("/3/Predictions/models/(?<model>.*)/frames/(?<frame>.*)", "POST", ModelMetricsHandler.class, "predict", null, "Score (generate predictions) for the specified Frame with the specified Model.  Both the Frame of predictions and the metrics will be returned.");
        RequestServer.register("/4/Predictions/models/(?<model>.*)/frames/(?<frame>.*)", "POST", ModelMetricsHandler.class, "predict2", null, "Score (generate predictions) for the specified Frame with the specified Model.  Both the Frame of predictions and the metrics will be returned.");
        RequestServer.register("/3/WaterMeterCpuTicks/(?<nodeidx>.*)", "GET", WaterMeterCpuTicksHandler.class, "fetch", null, "Return a CPU usage snapshot of all cores of all nodes in the H2O cluster.");
        RequestServer.register("/3/WaterMeterIo/(?<nodeidx>.*)", "GET", WaterMeterIoHandler.class, "fetch", null, "Return IO usage snapshot of all nodes in the H2O cluster.");
        RequestServer.register("/3/WaterMeterIo", "GET", WaterMeterIoHandler.class, "fetch_all", null, "Return IO usage snapshot of all nodes in the H2O cluster.");
        RequestServer.register("/3/NodePersistentStorage/categories/(?<category>.*)/names/(?<name>.*)/exists", "GET", NodePersistentStorageHandler.class, "exists", null, "Return true or false.");
        RequestServer.register("/3/NodePersistentStorage/categories/(?<category>.*)/exists", "GET", NodePersistentStorageHandler.class, "exists", null, "Return true or false.");
        RequestServer.register("/3/NodePersistentStorage/configured", "GET", NodePersistentStorageHandler.class, "configured", null, "Return true or false.");
        RequestServer.register("/3/NodePersistentStorage/(?<category>.*)/(?<name>.*)", "POST", NodePersistentStorageHandler.class, "put_with_name", null, "Store a named value.");
        RequestServer.register("/3/NodePersistentStorage/(?<category>.*)/(?<name>.*)", "GET", NodePersistentStorageHandler.class, "get_as_string", null, "Return value for a given name.");
        RequestServer.register("/3/NodePersistentStorage/(?<category>.*)/(?<name>.*)", "DELETE", NodePersistentStorageHandler.class, "delete", null, "Delete a key.");
        RequestServer.register("/3/NodePersistentStorage/(?<category>.*)", "POST", NodePersistentStorageHandler.class, "put", null, "Store a value.");
        RequestServer.register("/3/NodePersistentStorage/(?<category>.*)", "GET", NodePersistentStorageHandler.class, "list", null, "Return all keys stored for a given category.");
        RequestServer.register("/3/Logs/nodes/(?<nodeidx>.*)/files/(?<name>.*)", "GET", LogsHandler.class, "fetch", null, "Get named log file for a node.");
        RequestServer.register("/3/KillMinus3", "GET", KillMinus3Handler.class, "killm3", null, "Kill minus 3 on *this* node");
        RequestServer.register("/99/Rapids", "POST", RapidsHandler.class, "exec", null, "Execute an Rapids AST.");
        RequestServer.register("/99/Assembly.java/(?<assembly_id>.*)/(?<pojo_name>.*)", "GET", AssemblyHandler.class, "toJava", null, "Generate a Java POJO from the Assembly");
        RequestServer.register("/99/Assembly", "POST", AssemblyHandler.class, "fit", null, "Fit an assembly to an input frame");
        RequestServer.register("/3/DownloadDataset", "GET", DownloadDataHandler.class, "fetch", null, "Download dataset as a CSV.");
        RequestServer.register("/3/DownloadDataset.bin", "GET", DownloadDataHandler.class, "fetchStreaming", null, "Download dataset as a CSV.");
        RequestServer.register("/3/DKV/(?<key>.*)", "DELETE", RemoveHandler.class, "remove", null, "Remove an arbitrary key from the H2O distributed K/V store.");
        RequestServer.register("/3/DKV", "DELETE", RemoveAllHandler.class, "remove", null, "Remove all keys from the H2O distributed K/V store.");
        RequestServer.register("/3/LogAndEcho", "POST", LogAndEchoHandler.class, "echo", null, "Save a message to the H2O logfile.");
        RequestServer.register("/3/InitID", "GET", InitIDHandler.class, "issue", null, "Issue a new session ID.");
        RequestServer.register("/3/InitID", "DELETE", InitIDHandler.class, "endSession", null, "End a session.");
        RequestServer.register("/3/GarbageCollect", "POST", GarbageCollectHandler.class, "gc", null, "Explicitly call System.gc().");
        RequestServer.register("/99/Sample", "GET", CloudHandler.class, "status", null, "Example of an experimental endpoint.  Call via /EXPERIMENTAL/Sample.  Experimental endpoints can change at any moment.");
        _cache = new NonBlockingHashMap();
    }
}

