/*
 * Decompiled with CFR 0.152.
 */
package water.api;

import hex.schemas.ModelBuilderSchema;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import water.DKV;
import water.H2O;
import water.Iced;
import water.Job;
import water.Key;
import water.Value;
import water.api.API;
import water.api.FrameV3;
import water.api.JobV3;
import water.api.KeyV3;
import water.api.ModelOutputSchema;
import water.api.ModelParametersSchema;
import water.api.ModelSchema;
import water.api.SchemaMetadata;
import water.exceptions.H2OIllegalArgumentException;
import water.exceptions.H2OKeyNotFoundArgumentException;
import water.exceptions.H2ONotFoundArgumentException;
import water.fvec.Frame;
import water.util.IcedHashMap;
import water.util.Log;
import water.util.MarkdownBuilder;
import water.util.Pair;
import water.util.PojoUtils;
import water.util.ReflectionUtils;

public class Schema<I extends Iced, S extends Schema<I, S>>
extends Iced {
    private transient Class<I> _impl_class;
    private static final int HIGHEST_SUPPORTED_VERSION = 4;
    private static final int EXPERIMENTAL_VERSION = 99;
    @API(help="Metadata on this schema instance, to make it self-describing.", direction=API.Direction.OUTPUT)
    private Meta __meta;
    private static Map<String, Class<? extends Schema>> schemas = new HashMap<String, Class<? extends Schema>>();
    private static Map<String, Class<? extends Iced>> schema_to_iced = new HashMap<String, Class<? extends Iced>>();
    private static Map<Pair<String, Integer>, Class<? extends Schema>> iced_to_schema = new HashMap<Pair<String, Integer>, Class<? extends Schema>>();
    private static volatile int LATEST_VERSION = -1;
    private static boolean schemas_registered = false;

    protected Meta get__meta() {
        return this.__meta;
    }

    public Schema() {
        String name = this.getClass().getSimpleName();
        int version = Schema.extractVersion(name);
        String type = this.getImplClass().getSimpleName();
        this.init_meta();
        if (null == schema_to_iced.get(name)) {
            Log.debug("Registering schema: " + name + " schema_version: " + version + " with Iced class: " + this._impl_class.toString());
            if (null != schemas.get(name)) {
                throw H2O.fail("Found a duplicate schema name in two different packages: " + schemas.get(name) + " and: " + this.getClass().toString());
            }
            schemas.put(name, this.getClass());
            schema_to_iced.put(name, this._impl_class);
            if (this._impl_class != Iced.class) {
                Pair<String, Integer> versioned = new Pair<String, Integer>(type, version);
                if (null != iced_to_schema.get(versioned)) {
                    throw H2O.fail("Found two schemas mapping to the same Iced class with the same version: " + iced_to_schema.get(versioned) + " and: " + this.getClass().toString() + " both map to version: " + version + " of Iced class: " + this._impl_class);
                }
                iced_to_schema.put(versioned, this.getClass());
            }
        }
    }

    protected void init_meta() {
        if (this.__meta != null) {
            return;
        }
        String name = this.getClass().getSimpleName();
        int version = Schema.extractVersion(name);
        String type = this.getImplClass().getSimpleName();
        this.__meta = new Meta(version, name, type);
    }

    private static int extractVersion(String clz_name) {
        int idx = clz_name.lastIndexOf(86);
        if (idx == -1) {
            return -1;
        }
        try {
            return Integer.valueOf(clz_name.substring(idx + 1));
        }
        catch (NumberFormatException ex) {
            return -1;
        }
    }

    public int getSchemaVersion() {
        return this.__meta.schema_version;
    }

    public static int getLatestVersion() {
        return LATEST_VERSION;
    }

    public static int getHighestSupportedVersion() {
        return 4;
    }

    public static int getExperimentalVersion() {
        return 99;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static void register(Class<? extends Schema> clz) {
        Class<? extends Schema> clazz = clz;
        // MONITORENTER : clazz
        Class<? extends Schema> existing = schemas.get(clz.getSimpleName());
        if (null != existing) {
            if (clz != existing) {
                throw H2O.fail("Two schema classes have the same simpleName; this is not supported: " + clz + " and " + existing + ".");
            }
            // MONITOREXIT : clazz
            return;
        }
        if (!(clz.getGenericSuperclass() instanceof ParameterizedType)) throw H2O.fail("Found a Schema that does not have a parameterized superclass.  Each Schema needs to be parameterized on the backing class (if any, or Iced if not) and itself: " + clz);
        Type[] schema_type_parms = ((ParameterizedType)clz.getGenericSuperclass()).getActualTypeArguments();
        if (schema_type_parms.length < 2) {
            throw H2O.fail("Found a Schema that does not pass at least two type parameters.  Each Schema needs to be parameterized on the backing class (if any, or Iced if not) and itself: " + clz);
        }
        Class<Schema> parm0 = ReflectionUtils.findActualClassParameter(clz, 0);
        if (!Iced.class.isAssignableFrom(parm0)) {
            throw H2O.fail("Found a Schema with bad type parameters.  First parameter is a subclass of Iced.  Each Schema needs to be parameterized on the backing class (if any, or Iced if not) and itself: " + clz + ".  Second parameter is of class: " + parm0);
        }
        if (Schema.class.isAssignableFrom(parm0)) {
            throw H2O.fail("Found a Schema with bad type parameters.  First parameter is a subclass of Schema.  Each Schema needs to be parameterized on the backing class (if any, or Iced if not) and itself: " + clz + ".  Second parameter is of class: " + parm0);
        }
        Class parm1 = ReflectionUtils.findActualClassParameter(clz, 1);
        if (!Schema.class.isAssignableFrom(parm1)) {
            throw H2O.fail("Found a Schema with bad type parameters.  Second parameter is not a subclass of Schema.  Each Schema needs to be parameterized on the backing class (if any, or Iced if not) and itself: " + clz + ".  Second parameter is of class: " + parm1);
        }
        int version = Schema.extractVersion(clz.getSimpleName());
        if (version > Schema.getHighestSupportedVersion() && version != 99) {
            throw H2O.fail("Found a schema with a version higher than the highest supported version; you probably want to bump the highest supported version: " + clz);
        }
        if (version > -1 && version != 99) {
            if (version > 4) {
                throw H2O.fail("Found a schema with a version greater than the highest supported version of: " + Schema.getHighestSupportedVersion() + ": " + clz);
            }
            if (version > LATEST_VERSION) {
                parm0 = Schema.class;
                // MONITORENTER : water.api.Schema.class
                if (version > LATEST_VERSION) {
                    LATEST_VERSION = version;
                }
                // MONITOREXIT : parm0
            }
        }
        Schema s = null;
        try {
            s = clz.newInstance();
        }
        catch (Exception e) {
            Log.err("Failed to instantiate schema class: " + clz + " because: " + e);
        }
        if (null != s) {
            Log.debug("Registered Schema: " + clz.getSimpleName());
            SchemaMetadata meta = new SchemaMetadata(s);
            for (SchemaMetadata.FieldMetadata field_meta : meta.fields) {
                String name = field_meta.name;
                if ("__meta".equals(name) || "__http_status".equals(name) || "_exclude_fields".equals(name) || "_include_fields".equals(name) || "Gini".equals(name) || name.endsWith("AUC") || "F0point5".equals(name) || "F0point5_for_criteria".equals(name) || "F1_for_criteria".equals(name) || "F2_for_criteria".equals(name)) continue;
                if (name.startsWith("_")) {
                    Log.warn("Found schema field which violates the naming convention; name starts with underscore: " + meta.name + "." + name);
                }
                if (name.equals(name.toLowerCase()) || name.equals(name.toUpperCase())) continue;
                Log.warn("Found schema field which violates the naming convention; name has mixed lowercase and uppercase characters: " + meta.name + "." + name);
            }
        }
        // MONITOREXIT : clazz
    }

    public I createImpl() {
        try {
            return (I)((Iced)this.getImplClass().newInstance());
        }
        catch (Exception e) {
            throw H2O.fail("Exception making a newInstance", e);
        }
    }

    public I fillImpl(I impl) {
        PojoUtils.copyProperties(impl, this, PojoUtils.FieldNaming.CONSISTENT);
        PojoUtils.copyProperties(impl, this, PojoUtils.FieldNaming.DEST_HAS_UNDERSCORES);
        return impl;
    }

    public final I createAndFillImpl() {
        return this.fillImpl(this.createImpl());
    }

    public S fillFromImpl(I impl) {
        PojoUtils.copyProperties(this, impl, PojoUtils.FieldNaming.ORIGIN_HAS_UNDERSCORES);
        PojoUtils.copyProperties(this, impl, PojoUtils.FieldNaming.CONSISTENT);
        return (S)this;
    }

    public static Class<? extends Iced> getImplClass(Class<? extends Schema> clz) {
        Class impl_class = ReflectionUtils.findActualClassParameter(clz, 0);
        if (null == impl_class) {
            Log.warn("Failed to find an impl class for Schema: " + clz);
        }
        return impl_class;
    }

    public Class<I> getImplClass() {
        return this._impl_class != null ? this._impl_class : (this._impl_class = ReflectionUtils.findActualClassParameter(this.getClass(), 0));
    }

    public S fillFromParms(Properties parms) {
        return this.fillFromParms(parms, true);
    }

    public S fillFromParms(Properties parms, boolean checkRequiredFields) {
        Class<?> thisSchemaClass = this.getClass();
        HashMap<String, Field> fields = new HashMap<String, Field>();
        Field current = null;
        try {
            Class<?> clz = thisSchemaClass;
            do {
                Field[] some_fields;
                Field[] arr$ = some_fields = clz.getDeclaredFields();
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    Field f;
                    current = f = arr$[i$];
                    if (null != fields.get(f.getName())) continue;
                    fields.put(f.getName(), f);
                }
            } while (Iced.class.isAssignableFrom((clz = clz.getSuperclass()).getSuperclass()));
        }
        catch (SecurityException e) {
            throw H2O.fail("Exception accessing field: " + current + " in class: " + this.getClass() + ": " + e);
        }
        for (String key : parms.stringPropertyNames()) {
            try {
                Field f = (Field)fields.get(key);
                if (null == f) {
                    throw new H2OIllegalArgumentException("Unknown parameter: " + key, "Unknown parameter in fillFromParms: " + key + " for class: " + this.getClass().toString());
                }
                int mods = f.getModifiers();
                if (Modifier.isTransient(mods) || Modifier.isStatic(mods)) {
                    throw new H2OIllegalArgumentException("Bad parameter for field: " + key + " for class: " + this.getClass().toString(), "Bad parameter definition for field: " + key + " in fillFromParms for class: " + this.getClass().toString() + " (field was declared static or transient)");
                }
                Annotation[] apis = f.getAnnotations();
                if (apis.length == 0) {
                    throw H2O.fail("Broken internal schema; missing API annotation for field: " + key);
                }
                API api = (API)apis[0];
                if (api.direction() == API.Direction.OUTPUT) {
                    throw new H2OIllegalArgumentException("Attempting to set output field: " + key + " for class: " + this.getClass().toString(), "Attempting to set output field: " + key + " in fillFromParms for class: " + this.getClass().toString() + " (field was annotated as API.Direction.OUTPUT)");
                }
                Schema.setField(this, f, key, parms.getProperty(key), api.required(), thisSchemaClass);
            }
            catch (IllegalAccessException iae) {
                throw H2O.fail("Broken internal schema; field cannot be private nor final: " + key);
            }
        }
        if (checkRequiredFields) {
            for (Field f : fields.values()) {
                int mods = f.getModifiers();
                if (Modifier.isTransient(mods) || Modifier.isStatic(mods)) continue;
                try {
                    API api = (API)f.getAnnotations()[0];
                    if (!api.required() || parms.getProperty(f.getName()) != null) continue;
                    IcedHashMap.IcedHashMapStringObject values = new IcedHashMap.IcedHashMapStringObject();
                    values.put("schema", this.getClass().getSimpleName());
                    values.put("argument", f.getName());
                    throw new H2OIllegalArgumentException("Required field " + f.getName() + " not specified", "Required field " + f.getName() + " not specified for schema class: " + this.getClass(), values);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw H2O.fail("Missing annotation for API field: " + f.getName());
                }
            }
        }
        return (S)this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <T extends Schema> void setField(T o, Field f, String key, String value, boolean required, Class thisSchemaClass) throws IllegalAccessException {
        Object parse_result = Schema.parse(key, value, f.getType(), required, thisSchemaClass);
        if (parse_result != null && f.getType().isArray() && parse_result.getClass().isArray() && f.getType().getComponentType() != parse_result.getClass().getComponentType()) {
            if (parse_result.getClass().getComponentType() == Integer.TYPE && f.getType().getComponentType() == Integer.class) {
                int[] from = (int[])parse_result;
                Integer[] copy = new Integer[from.length];
                for (int i = 0; i < from.length; ++i) {
                    copy[i] = from[i];
                }
                f.set(o, copy);
                return;
            } else if (parse_result.getClass().getComponentType() == Integer.class && f.getType().getComponentType() == Integer.TYPE) {
                Integer[] from = (Integer[])parse_result;
                int[] copy = new int[from.length];
                for (int i = 0; i < from.length; ++i) {
                    copy[i] = from[i];
                }
                f.set(o, copy);
                return;
            } else if (parse_result.getClass().getComponentType() == Double.class && f.getType().getComponentType() == Double.TYPE) {
                Double[] from = (Double[])parse_result;
                double[] copy = new double[from.length];
                for (int i = 0; i < from.length; ++i) {
                    copy[i] = from[i];
                }
                f.set(o, copy);
                return;
            } else {
                if (parse_result.getClass().getComponentType() != Float.class || f.getType().getComponentType() != Float.TYPE) throw H2O.fail("Don't know how to cast an array of: " + parse_result.getClass().getComponentType() + " to an array of: " + f.getType().getComponentType());
                Float[] from = (Float[])parse_result;
                float[] copy = new float[from.length];
                for (int i = 0; i < from.length; ++i) {
                    copy[i] = from[i].floatValue();
                }
                f.set(o, copy);
            }
            return;
        } else {
            f.set(o, parse_result);
        }
    }

    static <E> Object parsePrimitve(String s, Class fclz) {
        if (fclz.equals(String.class)) {
            return s;
        }
        if (fclz.equals(Integer.TYPE)) {
            return Schema.parseInteger(s, Integer.TYPE);
        }
        if (fclz.equals(Long.TYPE)) {
            return Schema.parseInteger(s, Long.TYPE);
        }
        if (fclz.equals(Short.TYPE)) {
            return Schema.parseInteger(s, Short.TYPE);
        }
        if (fclz.equals(Boolean.TYPE)) {
            if (s.equals("0")) {
                return Boolean.FALSE;
            }
            if (s.equals("1")) {
                return Boolean.TRUE;
            }
            return Boolean.valueOf(s);
        }
        if (fclz.equals(Byte.TYPE)) {
            return Schema.parseInteger(s, Byte.TYPE);
        }
        if (fclz.equals(Double.TYPE)) {
            return Double.valueOf(s);
        }
        if (fclz.equals(Float.TYPE)) {
            return Float.valueOf(s);
        }
        throw H2O.fail("Unknown primitive type to parse: " + fclz.getSimpleName());
    }

    static <E> Object parse(String field_name, String s, Class fclz, boolean required, Class schemaClass) {
        if (fclz.isPrimitive() || String.class.equals((Object)fclz)) {
            try {
                return Schema.parsePrimitve(s, fclz);
            }
            catch (NumberFormatException ne) {
                String msg = "Illegal argument for field: " + field_name + " of schema: " + schemaClass.getSimpleName() + ": cannot convert \"" + s + "\" to type " + fclz.getSimpleName();
                throw new H2OIllegalArgumentException(msg);
            }
        }
        if (fclz.isArray()) {
            String[] splits;
            Class<?> afclz = fclz.getComponentType();
            Object[] a = null;
            if (s.equals("null") || s.length() == 0) {
                return null;
            }
            if (s.startsWith("[") && s.endsWith("]")) {
                Schema.read(s, 0, '[', fclz);
                Schema.read(s, s.length() - 1, ']', fclz);
                String inside = s.substring(1, s.length() - 1).trim();
                splits = inside.length() == 0 ? new String[]{} : Schema.splitArgs(inside);
            } else {
                splits = new String[]{s.trim()};
            }
            a = afclz == Integer.TYPE ? (Object[])Array.newInstance(Integer.class, splits.length) : (afclz == Double.TYPE ? (Object[])Array.newInstance(Double.class, splits.length) : (afclz == Float.TYPE ? (Object[])Array.newInstance(Float.class, splits.length) : (Object[])Array.newInstance(afclz, splits.length)));
            for (int i = 0; i < splits.length; ++i) {
                if (String.class == afclz || KeyV3.class.isAssignableFrom(afclz)) {
                    String stripped = splits[i].trim();
                    if ("null".equals(stripped.toLowerCase()) || "na".equals(stripped.toLowerCase())) {
                        a[i] = null;
                        continue;
                    }
                    if (!stripped.startsWith("\"") || !stripped.endsWith("\"")) {
                        String msg = "Illegal argument for field: " + field_name + " of schema: " + schemaClass.getSimpleName() + ": string and key arrays' values must be double quoted, but the client sent: " + stripped;
                        IcedHashMap.IcedHashMapStringObject values = new IcedHashMap.IcedHashMapStringObject();
                        values.put("function", fclz.getSimpleName() + ".fillFromParms()");
                        values.put("argument", field_name);
                        values.put("value", stripped);
                        throw new H2OIllegalArgumentException(msg, msg, values);
                    }
                    stripped = stripped.substring(1, stripped.length() - 1);
                    a[i] = Schema.parse(field_name, stripped, afclz, required, schemaClass);
                    continue;
                }
                a[i] = Schema.parse(field_name, splits[i].trim(), afclz, required, schemaClass);
            }
            return a;
        }
        if (fclz.equals(Key.class)) {
            if ((s == null || s.length() == 0) && required) {
                throw new H2OKeyNotFoundArgumentException(field_name, s);
            }
            if (!(required || s != null && s.length() != 0)) {
                return null;
            }
            return Key.make(s.startsWith("\"") ? s.substring(1, s.length() - 1) : s);
        }
        if (KeyV3.class.isAssignableFrom(fclz)) {
            if ((s == null || s.length() == 0) && required) {
                throw new H2OKeyNotFoundArgumentException(field_name, s);
            }
            if (!(required || s != null && s.length() != 0)) {
                return null;
            }
            return KeyV3.make(fclz, Key.make(s.startsWith("\"") ? s.substring(1, s.length() - 1) : s));
        }
        if (Enum.class.isAssignableFrom(fclz)) {
            return Enum.valueOf(fclz, s);
        }
        if (FrameV3.class.isAssignableFrom(fclz)) {
            if ((s == null || s.length() == 0) && required) {
                throw new H2OKeyNotFoundArgumentException(field_name, s);
            }
            if (!(required || s != null && s.length() != 0)) {
                return null;
            }
            Value v = DKV.get(s);
            if (null == v) {
                return null;
            }
            if (!v.isFrame()) {
                throw H2OIllegalArgumentException.wrongKeyType(field_name, s, "Frame", v.get().getClass());
            }
            return new FrameV3((Frame)v.get());
        }
        if (JobV3.class.isAssignableFrom(fclz)) {
            if ((s == null || s.length() == 0) && required) {
                throw new H2OKeyNotFoundArgumentException(s);
            }
            if (!(required || s != null && s.length() != 0)) {
                return null;
            }
            Value v = DKV.get(s);
            if (null == v) {
                return null;
            }
            if (!v.isJob()) {
                throw H2OIllegalArgumentException.wrongKeyType(field_name, s, "Job", v.get().getClass());
            }
            return new JobV3().fillFromImpl((Job)v.get());
        }
        if (FrameV3.ColSpecifierV3.class.isAssignableFrom(fclz)) {
            return new FrameV3.ColSpecifierV3(s);
        }
        if (ModelSchema.class.isAssignableFrom(fclz)) {
            throw H2O.fail("Can't yet take ModelSchema as input.");
        }
        throw H2O.fail("Unimplemented schema fill from " + fclz.getSimpleName());
    }

    private static <T> T parseInteger(String s, Class<T> return_type) {
        try {
            BigDecimal num = new BigDecimal(s);
            Object result = num.getClass().getDeclaredMethod(return_type.getSimpleName() + "ValueExact", new Class[0]).invoke((Object)num, new Object[0]);
            return (T)result;
        }
        catch (InvocationTargetException ite) {
            throw new NumberFormatException("The expression's numeric value is out of the range of type " + return_type.getSimpleName());
        }
        catch (NoSuchMethodException nsme) {
            throw new IllegalArgumentException(return_type.getSimpleName() + " is not an integer data type");
        }
        catch (IllegalAccessException iae) {
            throw H2O.fail("Cannot parse expression as " + return_type.getSimpleName() + " (Illegal Access)");
        }
    }

    private static int read(String s, int x, char c, Class fclz) {
        if (Schema.peek(s, x, c)) {
            return x + 1;
        }
        throw new IllegalArgumentException("Expected '" + c + "' while reading a " + fclz.getSimpleName() + ", but found " + s);
    }

    private static boolean peek(String s, int x, char c) {
        return x < s.length() && s.charAt(x) == c;
    }

    private static String[] splitArgs(String argStr) {
        StringBuffer sb = new StringBuffer(argStr);
        StringBuffer arg = new StringBuffer();
        ArrayList<String> splitArgList = new ArrayList<String>();
        boolean inDoubleQuotes = false;
        boolean inSquareBrackets = false;
        for (int i = 0; i < sb.length(); ++i) {
            if (sb.charAt(i) == '\"' && !inDoubleQuotes && !inSquareBrackets) {
                inDoubleQuotes = true;
                arg.append(sb.charAt(i));
                continue;
            }
            if (sb.charAt(i) == '\"' && inDoubleQuotes && !inSquareBrackets) {
                inDoubleQuotes = false;
                arg.append(sb.charAt(i));
                continue;
            }
            if (sb.charAt(i) == ',' && !inDoubleQuotes && !inSquareBrackets) {
                splitArgList.add(arg.toString());
                arg.setLength(0);
                continue;
            }
            if (sb.charAt(i) == '[') {
                inSquareBrackets = true;
                arg.append(sb.charAt(i));
                continue;
            }
            if (sb.charAt(i) == ']') {
                inSquareBrackets = false;
                arg.append(sb.charAt(i));
                continue;
            }
            arg.append(sb.charAt(i));
        }
        if (arg.length() > 0) {
            splitArgList.add(arg.toString());
        }
        return splitArgList.toArray(new String[splitArgList.size()]);
    }

    public static synchronized void registerAllSchemasIfNecessary() {
        if (schemas_registered) {
            return;
        }
        long before = System.currentTimeMillis();
        new Schema();
        String[] packages = new String[]{"water", "hex"};
        Class[] clzs = new Class[]{Schema.class, ModelBuilderSchema.class, ModelSchema.class, ModelOutputSchema.class, ModelParametersSchema.class};
        for (String pkg : packages) {
            Reflections reflections = new Reflections(pkg, new Scanner[0]);
            for (Class clz : clzs) {
                Log.debug("Registering: " + clz.toString() + " in package: " + pkg);
                if (!Modifier.isAbstract(clz.getModifiers())) {
                    Schema.register(clz);
                }
                Log.debug("Registering subclasses of: " + clz.toString() + " in package: " + pkg);
                for (Class schema_class : reflections.getSubTypesOf(clz)) {
                    if (Modifier.isAbstract(schema_class.getModifiers())) continue;
                    Schema.register(schema_class);
                }
            }
        }
        schemas_registered = true;
        Log.info("Registered: " + Schema.schemas().size() + " schemas in: " + (System.currentTimeMillis() - before) + "mS");
    }

    protected static Map<String, Class<? extends Schema>> schemas() {
        return Collections.unmodifiableMap(new HashMap<String, Class<? extends Schema>>(schemas));
    }

    protected static Class<? extends Schema> schemaClass(int version, Class<? extends Iced> impl_class) {
        return Schema.schemaClass(version, impl_class.getSimpleName());
    }

    public static Class<? extends Schema> schemaClass(int version, String type) {
        if (version < 1) {
            return null;
        }
        Class<? extends Schema> clz = iced_to_schema.get(new Pair<String, Integer>(type, version));
        if (null != clz) {
            return clz;
        }
        clz = Schema.schemaClass(version - 1, type);
        if (null != clz) {
            iced_to_schema.put(new Pair<String, Integer>(type, version), clz);
        }
        return clz;
    }

    public static Schema schema(int version, Iced impl) {
        return Schema.schema(version, impl.getClass().getSimpleName());
    }

    public static Schema schema(int version, Class<? extends Iced> impl_class) {
        return Schema.schema(version, impl_class.getSimpleName());
    }

    public static <T extends Schema> T newInstance(Class<T> clz) {
        try {
            return (T)((Schema)clz.newInstance());
        }
        catch (Exception e) {
            throw H2O.fail("Failed to instantiate schema of class: " + clz.getCanonicalName(), e);
        }
    }

    private static Schema schema(int version, String type) {
        Class<Schema> clz = Schema.schemaClass(version, type);
        if (null == clz) {
            clz = Schema.schemaClass(Schema.getExperimentalVersion(), type);
        }
        if (null == clz) {
            throw new H2ONotFoundArgumentException("Failed to find schema for version: " + version + " and type: " + type, "Failed to find schema for version: " + version + " and type: " + type);
        }
        return Schema.newInstance(clz);
    }

    protected static Schema newInstance(String schema_name) {
        Class<? extends Schema> clz = schemas.get(schema_name);
        if (null == clz) {
            throw new H2ONotFoundArgumentException("Failed to find schema for schema_name: " + schema_name, "Failed to find schema for schema_name: " + schema_name);
        }
        return Schema.newInstance(clz);
    }

    public StringBuffer markdown(boolean include_input_fields, boolean include_output_fields) {
        return this.markdown(new SchemaMetadata(this), include_input_fields, include_output_fields);
    }

    public StringBuffer markdown(SchemaMetadata meta, boolean include_input_fields, boolean include_output_fields) {
        MarkdownBuilder builder = new MarkdownBuilder();
        builder.comment("Preview with http://jbt.github.io/markdown-editor");
        builder.heading1("schema ", this.getClass().getSimpleName());
        builder.hline();
        try {
            boolean first;
            if (include_input_fields) {
                first = true;
                builder.heading2("input fields");
                for (SchemaMetadata.FieldMetadata field_meta : meta.fields) {
                    if (field_meta.direction != API.Direction.INPUT && field_meta.direction != API.Direction.INOUT) continue;
                    if (first) {
                        builder.tableHeader("name", "required?", "level", "type", "schema?", "schema", "default", "description", "values", "is member of frames", "is mutually exclusive with");
                        first = false;
                    }
                    builder.tableRow(field_meta.name, String.valueOf(field_meta.required), field_meta.level.name(), field_meta.type, String.valueOf(field_meta.is_schema), field_meta.is_schema ? field_meta.schema_name : "", null == field_meta.value ? "(null)" : field_meta.value.toString(), field_meta.help, field_meta.values == null || field_meta.values.length == 0 ? "" : Arrays.toString(field_meta.values), field_meta.is_member_of_frames == null ? "[]" : Arrays.toString(field_meta.is_member_of_frames), field_meta.is_mutually_exclusive_with == null ? "[]" : Arrays.toString(field_meta.is_mutually_exclusive_with));
                }
                if (first) {
                    builder.paragraph("(none)");
                }
            }
            if (include_output_fields) {
                first = true;
                builder.heading2("output fields");
                for (SchemaMetadata.FieldMetadata field_meta : meta.fields) {
                    if (field_meta.direction != API.Direction.OUTPUT && field_meta.direction != API.Direction.INOUT) continue;
                    if (first) {
                        builder.tableHeader("name", "type", "schema?", "schema", "default", "description", "values", "is member of frames", "is mutually exclusive with");
                        first = false;
                    }
                    builder.tableRow(field_meta.name, field_meta.type, String.valueOf(field_meta.is_schema), field_meta.is_schema ? field_meta.schema_name : "", null == field_meta.value ? "(null)" : field_meta.value.toString(), field_meta.help, field_meta.values == null || field_meta.values.length == 0 ? "" : Arrays.toString(field_meta.values), field_meta.is_member_of_frames == null ? "[]" : Arrays.toString(field_meta.is_member_of_frames), field_meta.is_mutually_exclusive_with == null ? "[]" : Arrays.toString(field_meta.is_mutually_exclusive_with));
                }
                if (first) {
                    builder.paragraph("(none)");
                }
            }
        }
        catch (Exception e) {
            IcedHashMap.IcedHashMapStringObject values = new IcedHashMap.IcedHashMapStringObject();
            values.put("schema", this);
            throw new H2OIllegalArgumentException("Caught exception using reflection on schema: " + this, "Caught exception using reflection on schema: " + this + ": " + e, values);
        }
        return builder.stringBuffer();
    }

    public static final class Meta
    extends Iced {
        @API(help="Version number of this Schema.  Must not be changed after creation (treat as final).", direction=API.Direction.OUTPUT)
        private int schema_version;
        @API(help="Simple name of this Schema.  NOTE: the schema_names form a single namespace.", direction=API.Direction.OUTPUT)
        private String schema_name;
        @API(help="Simple name of H2O type that this Schema represents.  Must not be changed after creation (treat as final).", direction=API.Direction.OUTPUT)
        private String schema_type;

        public Meta() {
        }

        public Meta(int version, String name, String type) {
            this.schema_version = version;
            this.schema_name = name;
            this.schema_type = type;
        }

        public int getSchema_version() {
            return this.schema_version;
        }

        public String getSchema_name() {
            return this.schema_name;
        }

        public String getSchema_type() {
            return this.schema_type;
        }

        protected void setSchema_type(String schema_type) {
            this.schema_type = schema_type;
        }
    }
}

