/*
 * Decompiled with CFR 0.152.
 */
package water.api;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import water.H2O;
import water.Iced;
import water.IcedWrapper;
import water.Key;
import water.Weaver;
import water.api.API;
import water.api.FieldMetadataV3;
import water.api.KeyV3;
import water.api.ModelParameterSchemaV3;
import water.api.Schema;
import water.api.SchemaMetadataBase;
import water.api.TwoDimTableBase;
import water.api.TwoDimTableV3;
import water.exceptions.H2OIllegalArgumentException;
import water.util.IcedHashMapBase;
import water.util.Log;
import water.util.ReflectionUtils;

public final class SchemaMetadata
extends Iced {
    public int version;
    public String name;
    public String superclass;
    public String type;
    public List<FieldMetadata> fields;
    public String markdown;

    public SchemaMetadata() {
        this.fields = new ArrayList<FieldMetadata>();
    }

    public SchemaMetadata(Schema schema) {
        this.version = schema.get__meta().getSchema_version();
        this.name = schema.get__meta().getSchema_name();
        this.type = schema.get__meta().getSchema_type();
        this.superclass = schema.getClass().getSuperclass().getSimpleName();
        this.fields = SchemaMetadata.getFieldMetadata(schema);
        this.markdown = schema.markdown(this, true, true).toString();
    }

    public static List<FieldMetadata> getFieldMetadata(Schema schema) {
        List<Field> superclassFields = Arrays.asList(Weaver.getWovenFields(schema.getClass().getSuperclass()));
        ArrayList<FieldMetadata> fields = new ArrayList<FieldMetadata>();
        for (Field field : Weaver.getWovenFields(schema.getClass())) {
            FieldMetadata fmd = FieldMetadata.createIfApiAnnotation(schema, field, superclassFields);
            if (null == fmd) continue;
            fields.add(fmd);
        }
        return fields;
    }

    public static SchemaMetadata createSchemaMetadata(String classname) throws IllegalArgumentException {
        try {
            Class<?> clz = Class.forName(classname);
            Schema s = (Schema)clz.newInstance();
            return new SchemaMetadata(s);
        }
        catch (Exception e) {
            String msg = "Caught exception fetching schema: " + classname + ": " + e;
            Log.warn(msg);
            throw new IllegalArgumentException(msg);
        }
    }

    public static final class FieldMetadata
    extends Iced {
        public String name;
        public String type;
        public boolean is_schema;
        public String schema_name;
        public Iced value;
        String help;
        String label;
        boolean required;
        API.Level level;
        API.Direction direction;
        public boolean is_inherited;
        public boolean is_gridable;
        String[] values;
        boolean json;
        String[] is_member_of_frames;
        String[] is_mutually_exclusive_with;

        public FieldMetadata() {
        }

        public FieldMetadata(Schema schema, Field f, List<Field> superclassFields) {
            try {
                f.setAccessible(true);
                this.name = f.getName();
                Object o = f.get(schema);
                this.value = FieldMetadata.consValue(o);
                boolean is_enum = Enum.class.isAssignableFrom(f.getType()) || f.getType().isArray() && Enum.class.isAssignableFrom(f.getType().getComponentType());
                this.is_schema = Schema.class.isAssignableFrom(f.getType()) || f.getType().isArray() && Schema.class.isAssignableFrom(f.getType().getComponentType());
                this.type = FieldMetadata.consType(schema, ReflectionUtils.findActualFieldClass(schema.getClass(), f), f.getName());
                if (this.is_schema) {
                    Class schema_class = f.getType().isArray() ? f.getType().getComponentType() : ReflectionUtils.findActualFieldClass(schema.getClass(), f);
                    Class<Schema> versioned_schema_class = Schema.schemaClass(schema.getSchemaVersion(), Schema.getImplClass(schema_class));
                    this.schema_name = null != versioned_schema_class ? versioned_schema_class.getSimpleName() : schema_class.getSimpleName();
                } else if (is_enum && !f.getType().isArray()) {
                    this.schema_name = f.getType().getSimpleName();
                } else if (is_enum && f.getType().isArray()) {
                    this.schema_name = f.getType().getComponentType().getSimpleName();
                }
                this.is_inherited = superclassFields.contains(f);
                API annotation = f.getAnnotation(API.class);
                if (null != annotation) {
                    String l = annotation.label();
                    this.help = annotation.help();
                    this.label = null == l || l.isEmpty() ? f.getName() : l;
                    this.required = annotation.required();
                    this.level = annotation.level();
                    this.direction = annotation.direction();
                    this.is_gridable = annotation.gridable();
                    this.values = annotation.values();
                    this.json = annotation.json();
                    this.is_member_of_frames = annotation.is_member_of_frames();
                    this.is_mutually_exclusive_with = annotation.is_mutually_exclusive_with();
                    if (is_enum && (null == this.values || 0 == this.values.length)) {
                        throw H2O.fail("Didn't find values annotation for enum field: " + this.name);
                    }
                }
            }
            catch (Exception e) {
                throw H2O.fail("Caught exception accessing field: " + f + " for schema object: " + schema + ": " + e.toString());
            }
        }

        public static FieldMetadata createIfApiAnnotation(Schema schema, Field f, List<Field> superclassFields) {
            f.setAccessible(true);
            if (null != f.getAnnotation(API.class)) {
                return new FieldMetadata(schema, f, superclassFields);
            }
            Log.warn("Skipping field that lacks an annotation: " + schema.toString() + "." + f);
            return null;
        }

        public static String consType(Schema schema, Class clz, String field_name) {
            boolean is_enum = Enum.class.isAssignableFrom(clz);
            boolean is_array = clz.isArray();
            if (is_enum) {
                return "enum";
            }
            if (String.class.isAssignableFrom(clz)) {
                return "string";
            }
            if (clz.equals(Boolean.TYPE) || clz.equals(Byte.TYPE) || clz.equals(Short.TYPE) || clz.equals(Integer.TYPE) || clz.equals(Long.TYPE) || clz.equals(Float.TYPE) || clz.equals(Double.TYPE)) {
                return clz.toString();
            }
            if (is_array) {
                return FieldMetadata.consType(schema, clz.getComponentType(), field_name) + "[]";
            }
            if (Map.class.isAssignableFrom(clz)) {
                if (IcedHashMapBase.class.isAssignableFrom(clz)) {
                    String type0 = ReflectionUtils.findActualClassParameter(clz, 0).getSimpleName();
                    String type1 = ReflectionUtils.findActualClassParameter(clz, 1).getSimpleName();
                    if ("String".equals(type0)) {
                        type0 = "string";
                    }
                    if ("String".equals(type1)) {
                        type1 = "string";
                    }
                    return "Map<" + type0 + "," + type1 + ">";
                }
                Log.warn("Schema Map field isn't a subclass of IcedHashMap, so its metadata won't have type parameters: " + schema.getClass().getSimpleName() + "." + field_name);
                return "Map";
            }
            if (List.class.isAssignableFrom(clz)) {
                return "List";
            }
            if (Key.class.isAssignableFrom(clz)) {
                Log.warn("Raw Key (not KeySchema) in Schema: " + schema.getClass() + " field: " + field_name);
                return "Key";
            }
            if (KeyV3.class.isAssignableFrom(clz)) {
                return "Key<" + KeyV3.getKeyedClassType(clz) + ">";
            }
            if (Schema.class.isAssignableFrom(clz)) {
                return Schema.getImplClass(clz).getSimpleName();
            }
            if (Iced.class.isAssignableFrom(clz)) {
                if (clz == Schema.Meta.class) {
                    return "Schema.Meta";
                }
                if (schema instanceof ModelParameterSchemaV3 && ("default_value".equals(field_name) || "actual_value".equals(field_name))) {
                    return "Polymorphic";
                }
                if ((schema instanceof FieldMetadataV3 || schema instanceof SchemaMetadataBase.FieldMetadataBase) && "value".equals(field_name)) {
                    return "Polymorphic";
                }
                if ((schema instanceof TwoDimTableBase || schema instanceof TwoDimTableV3) && "data".equals(field_name)) {
                    return "Polymorphic";
                }
                Log.warn("WARNING: found non-Schema Iced field: " + clz.toString() + " in Schema: " + schema.getClass() + " field: " + field_name);
                return clz.getSimpleName();
            }
            String msg = "Don't know how to generate a client-friendly type name for class: " + clz.toString() + " in Schema: " + schema.getClass() + " field: " + field_name;
            Log.warn(msg);
            throw H2O.fail(msg);
        }

        public static Iced consValue(Object o) {
            if (null == o) {
                return null;
            }
            Class<?> clz = o.getClass();
            if (Iced.class.isAssignableFrom(clz)) {
                return (Iced)o;
            }
            if (clz.isArray()) {
                return new IcedWrapper(o);
            }
            if (clz.isPrimitive()) {
                return new IcedWrapper(o);
            }
            if (o instanceof Number) {
                return new IcedWrapper(o);
            }
            if (o instanceof Boolean) {
                return new IcedWrapper(o);
            }
            if (o instanceof String) {
                return new IcedWrapper(o);
            }
            if (o instanceof Enum) {
                return new IcedWrapper(o);
            }
            throw new H2OIllegalArgumentException("o", "consValue", o);
        }
    }
}

