/*
 * Decompiled with CFR 0.152.
 */
package water.fvec;

import java.util.Arrays;
import java.util.Iterator;
import water.H2O;
import water.fvec.Chunk;
import water.fvec.NewChunk;
import water.util.UnsafeUtils;

public class CXIChunk
extends Chunk {
    private transient int _valsz;
    private transient int _valsz_log;
    protected transient int _ridsz;
    protected transient int _sparseLen;
    protected static final int _OFF = 6;
    private transient int _lastOff = 6;
    private static final long[] NAS = new long[]{255L, -32768L, Integer.MIN_VALUE, Long.MIN_VALUE};

    protected final int valsz() {
        return this._valsz;
    }

    protected final int ridsz() {
        return this._ridsz;
    }

    protected CXIChunk(int len, int valsz, byte[] buf) {
        byte b;
        assert (valsz == 0 || valsz == 1 || valsz == 2 || valsz == 4 || valsz == 8);
        this.set_len(len);
        int log = 0;
        while (1 << log < valsz) {
            ++log;
        }
        assert (valsz == 0 || 1 << log == valsz);
        this._valsz = valsz;
        this._valsz_log = log;
        this._ridsz = len >= 65535 ? 4 : 2;
        UnsafeUtils.set4(buf, 0, len);
        buf[4] = b = (byte)this._ridsz;
        buf[5] = (byte)this._valsz;
        this._mem = buf;
        this._sparseLen = (this._mem.length - 6) / (this._valsz + this._ridsz);
        assert ((this._mem.length - 6) % (this._valsz + this._ridsz) == 0) : "unexpected mem buffer length: mem.length = " + this._mem.length + ", off = " + 6 + ", valSz = " + this._valsz + "ridsz = " + this._ridsz;
    }

    @Override
    public double[] getDoubles(double[] vals, int from, int to, double NA) {
        double fill;
        double d = fill = this.isSparseNA() ? Double.NaN : 0.0;
        if (from == 0 && to == this._len) {
            Arrays.fill(vals, fill);
            double[] svals = new double[this._sparseLen];
            int[] sids = new int[this._sparseLen];
            this.asSparseDoubles(svals, sids, NA);
            for (int i = 0; i < sids.length && sids[i] < to; ++i) {
                vals[sids[i]] = svals[i];
            }
        } else {
            int i;
            for (i = from; i < to; ++i) {
                vals[i - from] = fill;
            }
            i = this.nextNZ(from - 1);
            while (i < to) {
                vals[i - from] = this.atd(i);
                i = this.nextNZ(i);
            }
        }
        return vals;
    }

    @Override
    public int asSparseDoubles(double[] vals, int[] ids, double NA) {
        block22: {
            block23: {
                int inc;
                int off;
                block21: {
                    if (vals.length < this._sparseLen) {
                        throw new IllegalArgumentException();
                    }
                    off = 6;
                    inc = this._valsz + this._ridsz;
                    if (this._ridsz != 2) break block21;
                    switch (this._valsz) {
                        case 1: {
                            int i = 0;
                            while (i < this._sparseLen) {
                                ids[i] = UnsafeUtils.get2(this._mem, off) & 0xFFFF;
                                long v = this._mem[off + 2] & 0xFF;
                                vals[i] = v == NAS[this._valsz_log] ? NA : (double)v;
                                ++i;
                                off += inc;
                            }
                            break block22;
                        }
                        case 2: {
                            int i = 0;
                            while (i < this._sparseLen) {
                                ids[i] = UnsafeUtils.get2(this._mem, off) & 0xFFFF;
                                long v = UnsafeUtils.get2(this._mem, off + 2);
                                vals[i] = v == NAS[this._valsz_log] ? NA : (double)v;
                                ++i;
                                off += inc;
                            }
                            break block22;
                        }
                        case 4: {
                            int i = 0;
                            while (i < this._sparseLen) {
                                ids[i] = UnsafeUtils.get2(this._mem, off) & 0xFFFF;
                                long v = UnsafeUtils.get4(this._mem, off + 2);
                                vals[i] = v == NAS[this._valsz_log] ? NA : (double)v;
                                ++i;
                                off += inc;
                            }
                            break block22;
                        }
                        case 8: {
                            int i = 0;
                            while (i < this._sparseLen) {
                                ids[i] = UnsafeUtils.get2(this._mem, off) & 0xFFFF;
                                long v = UnsafeUtils.get8(this._mem, off + 2);
                                vals[i] = v == Long.MIN_VALUE ? Double.NaN : (double)v;
                                ++i;
                                off += inc;
                            }
                            break;
                        }
                    }
                    break block22;
                }
                if (this._ridsz != 4) break block23;
                switch (this._valsz) {
                    case 1: {
                        int i = 0;
                        while (i < this._sparseLen) {
                            ids[i] = UnsafeUtils.get4(this._mem, off);
                            long v = this._mem[off + 4] & 0xFF;
                            vals[i] = v == 255L ? NA : (double)v;
                            ++i;
                            off += inc;
                        }
                        break block22;
                    }
                    case 2: {
                        int i = 0;
                        while (i < this._sparseLen) {
                            ids[i] = UnsafeUtils.get4(this._mem, off);
                            long v = UnsafeUtils.get2(this._mem, off + 4);
                            vals[i] = v == -32768L ? NA : (double)v;
                            ++i;
                            off += inc;
                        }
                        break block22;
                    }
                    case 4: {
                        int i = 0;
                        while (i < this._sparseLen) {
                            ids[i] = UnsafeUtils.get4(this._mem, off);
                            long v = UnsafeUtils.get4(this._mem, off + 4);
                            vals[i] = v == Integer.MIN_VALUE ? NA : (double)v;
                            ++i;
                            off += inc;
                        }
                        break block22;
                    }
                    case 8: {
                        int i = 0;
                        while (i < this._sparseLen) {
                            ids[i] = UnsafeUtils.get4(this._mem, off);
                            long v = UnsafeUtils.get8(this._mem, off + 4);
                            vals[i] = v == Long.MIN_VALUE ? NA : (double)v;
                            ++i;
                            off += inc;
                        }
                        break;
                    }
                }
                break block22;
            }
            throw H2O.unimpl();
        }
        return this.sparseLenZero();
    }

    @Override
    public boolean isSparseZero() {
        return true;
    }

    @Override
    public int sparseLenZero() {
        return this._sparseLen;
    }

    @Override
    public int nextNZ(int rid) {
        int off = rid == -1 ? 6 : this.findOffset(rid);
        int x = this.getId(off);
        if (x > rid) {
            return x;
        }
        if (off < this._mem.length - this._ridsz - this._valsz) {
            return this.getId(off + this._ridsz + this._valsz);
        }
        return this._len;
    }

    @Override
    public int nonzeros(int[] arr) {
        int off = 6;
        int inc = this._valsz + this._ridsz;
        int i = 0;
        while (i < this._sparseLen) {
            arr[i] = this.getId(off);
            ++i;
            off += inc;
        }
        return this._sparseLen;
    }

    @Override
    boolean set_impl(int idx, long l) {
        return false;
    }

    @Override
    boolean set_impl(int idx, double d) {
        return false;
    }

    @Override
    boolean set_impl(int idx, float f) {
        return false;
    }

    @Override
    boolean setNA_impl(int idx) {
        return false;
    }

    @Override
    protected long at8_impl(int idx) {
        int off = this.findOffset(idx);
        if (this.getId(off) != idx) {
            return 0L;
        }
        long v = this.getIValue(off);
        if (v == NAS[this._valsz_log]) {
            throw new IllegalArgumentException("at8_abs but value is missing");
        }
        return v;
    }

    @Override
    protected double atd_impl(int idx) {
        int off = this.findOffset(idx);
        if (this.getId(off) != idx) {
            return 0.0;
        }
        long v = this.getIValue(off);
        return v == NAS[this._valsz_log] ? Double.NaN : (double)v;
    }

    @Override
    protected boolean isNA_impl(int i) {
        int off = this.findOffset(i);
        return this.getId(off) == i && this.getIValue(off) == NAS[this._valsz_log];
    }

    @Override
    public NewChunk inflate_impl(NewChunk nc) {
        nc.set_len(this._len);
        nc.set_sparseLen(this._sparseLen);
        nc.alloc_mantissa(this._sparseLen);
        nc.alloc_exponent(this._sparseLen);
        nc.alloc_indices(this._sparseLen);
        int off = 6;
        int i = 0;
        while (i < this._sparseLen) {
            nc.indices()[i] = this.getId(off);
            long v = this.getIValue(off);
            if (v == NAS[this._valsz_log]) {
                nc.setNA_impl2(i);
            } else {
                nc.mantissa()[i] = v;
            }
            ++i;
            off += this._ridsz + this._valsz;
        }
        return nc;
    }

    protected final int getId(int off) {
        return this._ridsz == 2 ? UnsafeUtils.get2(this._mem, off) & 0xFFFF : UnsafeUtils.get4(this._mem, off);
    }

    private int getOff(int n) {
        return 6 + (this._ridsz + this._valsz) * n;
    }

    protected double getFValue(int off) {
        return this.getIValue(off);
    }

    protected final long getIValue(int off) {
        switch (this._valsz) {
            case 1: {
                return this._mem[off + this._ridsz] & 0xFF;
            }
            case 2: {
                return UnsafeUtils.get2(this._mem, off + this._ridsz);
            }
            case 4: {
                return UnsafeUtils.get4(this._mem, off + this._ridsz);
            }
            case 8: {
                return UnsafeUtils.get8(this._mem, off + this._ridsz);
            }
        }
        throw H2O.fail();
    }

    protected final int findOffset(int idx) {
        int y;
        byte[] mem = this._mem;
        if (idx >= this._len) {
            throw new IndexOutOfBoundsException();
        }
        if (idx <= this.getId(6)) {
            return 6;
        }
        int last = mem.length - this._ridsz - this._valsz;
        if (idx >= this.getId(last)) {
            return last;
        }
        int off = this._lastOff;
        int lastIdx = this.getId(off);
        if (idx == lastIdx) {
            return off;
        }
        if (idx > lastIdx) {
            int nextOff = off + this._ridsz + this._valsz;
            int nextId = this.getId(nextOff);
            if (idx < nextId) {
                return off;
            }
            if (idx == nextId) {
                this._lastOff = nextOff;
                return nextOff;
            }
        }
        int lo = 0;
        int hi = this._sparseLen;
        while (lo + 1 != hi) {
            int mid = hi + lo >>> 1;
            if (idx < this.getId(this.getOff(mid))) {
                hi = mid;
                continue;
            }
            lo = mid;
        }
        this._lastOff = y = this.getOff(lo);
        return y;
    }

    @Override
    public final void initFromBytes() {
        this._start = -1L;
        this._cidx = -1;
        this.set_len(UnsafeUtils.get4(this._mem, 0));
        this._ridsz = this._mem[4];
        int x = this._valsz = this._mem[5];
        int log = 0;
        while (x > 1) {
            x >>>= 1;
            ++log;
        }
        this._valsz_log = log;
        this._sparseLen = (this._mem.length - 6) / (this._valsz + this._ridsz);
        assert ((this._mem.length - 6) % (this._valsz + this._ridsz) == 0) : "unexpected mem buffer length: meme.length = " + this._mem.length + ", off = " + 6 + ", valSz = " + this._valsz + "ridsz = " + this._ridsz;
    }

    public Iterator<Value> values() {
        return new SparseIterator(new Value(){

            @Override
            public final long asLong() {
                long v = CXIChunk.this.getIValue(this._off);
                if (v == NAS[(CXIChunk.this._valsz >>> 1) - 1]) {
                    throw new IllegalArgumentException("at8_abs but value is missing");
                }
                return v;
            }

            @Override
            public final double asDouble() {
                long v = CXIChunk.this.getIValue(this._off);
                return v == NAS[CXIChunk.this._valsz_log - 1] ? Double.NaN : (double)v;
            }

            @Override
            public final boolean isNA() {
                long v = CXIChunk.this.getIValue(this._off);
                return v == NAS[CXIChunk.this._valsz_log];
            }
        });
    }

    @Override
    public boolean hasFloat() {
        return false;
    }

    public final class SparseIterator
    implements Iterator<Value> {
        final Value _val;

        public SparseIterator(Value v) {
            this._val = v;
        }

        @Override
        public final boolean hasNext() {
            return this._val._off < CXIChunk.this._mem.length - (CXIChunk.this._ridsz + CXIChunk.this._valsz);
        }

        @Override
        public final Value next() {
            this._val._off = this._val._off == 0 ? 6 : (this._val._off += CXIChunk.this._ridsz + CXIChunk.this._valsz);
            return this._val;
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public abstract class Value {
        protected int _off = 0;

        public int rowInChunk() {
            return CXIChunk.this.getId(this._off);
        }

        public abstract long asLong();

        public abstract double asDouble();

        public abstract boolean isNA();
    }
}

