/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import org.apache.commons.lang.StringUtils;
import water.MRTask;
import water.fvec.C0DChunk;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.parser.BufferedString;
import water.rapids.AST;
import water.rapids.ASTPrim;
import water.rapids.ASTStrList;
import water.rapids.Env;
import water.rapids.ValFrame;

class ASTCountMatches
extends ASTPrim {
    ASTCountMatches() {
    }

    @Override
    public String[] args() {
        return new String[]{"ary", "pattern"};
    }

    @Override
    int nargs() {
        return 3;
    }

    @Override
    public String str() {
        return "countmatches";
    }

    @Override
    public ValFrame apply(Env env, Env.StackHelp stk, AST[] asts) {
        String[] stringArray;
        Frame fr = stk.track(asts[1].exec(env)).getFrame();
        if (asts[2] instanceof ASTStrList) {
            stringArray = ((ASTStrList)asts[2])._strs;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = asts[2].exec(env).getStr();
        }
        String[] pattern = stringArray;
        for (Vec v : fr.vecs()) {
            if (v.isCategorical() || v.isString()) continue;
            throw new IllegalArgumentException("countmatches() requires a string or categorical column. Received " + fr.anyVec().get_type_str() + ". Please convert column to a string or categorical first.");
        }
        Vec[] nvs = new Vec[fr.numCols()];
        int i = 0;
        for (Vec v : fr.vecs()) {
            nvs[i] = v.isCategorical() ? this.countMatchesCategoricalCol(v, pattern) : this.countMatchesStringCol(v, pattern);
            ++i;
        }
        return new ValFrame(new Frame(nvs));
    }

    private Vec countMatchesCategoricalCol(Vec vec, String[] pattern) {
        final int[] matchCounts = this.countDomainMatches(vec.domain(), pattern);
        return ((MRTask)new MRTask(){

            @Override
            public void map(Chunk[] cs, NewChunk[] ncs) {
                Chunk c = cs[0];
                for (int i = 0; i < c._len; ++i) {
                    if (!c.isNA(i)) {
                        int idx = (int)c.at8(i);
                        ncs[0].addNum(matchCounts[idx]);
                        continue;
                    }
                    ncs[0].addNA();
                }
            }
        }.doAll(1, (byte)3, new Frame(vec))).outputFrame().anyVec();
    }

    int[] countDomainMatches(String[] domain, String[] pattern) {
        int[] res = new int[domain.length];
        for (int i = 0; i < domain.length; ++i) {
            for (String aPattern : pattern) {
                int n = i;
                res[n] = res[n] + StringUtils.countMatches((String)domain[i], (String)aPattern);
            }
        }
        return res;
    }

    private Vec countMatchesStringCol(Vec vec, String[] pat) {
        final String[] pattern = pat;
        return ((MRTask)new MRTask(){

            @Override
            public void map(Chunk chk, NewChunk newChk) {
                if (chk instanceof C0DChunk) {
                    for (int i = 0; i < chk.len(); ++i) {
                        newChk.addNA();
                    }
                } else {
                    BufferedString tmpStr = new BufferedString();
                    for (int i = 0; i < chk._len; ++i) {
                        if (chk.isNA(i)) {
                            newChk.addNA();
                            continue;
                        }
                        int cnt = 0;
                        for (String aPattern : pattern) {
                            cnt += StringUtils.countMatches((String)chk.atStr(tmpStr, i).toString(), (String)aPattern);
                        }
                        newChk.addNum(cnt, 0);
                    }
                }
            }
        }.doAll((byte)3, new Frame(vec))).outputFrame().anyVec();
    }
}

