/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import java.util.ArrayList;
import java.util.Arrays;
import water.H2O;
import water.rapids.ASTParameter;
import water.rapids.Env;
import water.rapids.Exec;
import water.rapids.Val;
import water.util.ArrayUtils;

public class ASTStrList
extends ASTParameter {
    public String[] _strs;

    ASTStrList(Exec e) {
        char c;
        ArrayList<String> strs = new ArrayList<String>();
        while ((c = e.skipWS()) != ']') {
            if (Exec.isQuote(c)) {
                strs.add(e.match(c));
                continue;
            }
            throw new IllegalArgumentException("Expecting the start of a string");
        }
        e.xpeek(']');
        this._strs = strs.toArray(new String[strs.size()]);
    }

    @Override
    int nargs() {
        return -1;
    }

    @Override
    public Val exec(Env env) {
        throw H2O.fail();
    }

    @Override
    public String str() {
        return Arrays.toString(this._strs);
    }

    @Override
    int[] columns(String[] names) {
        int[] idxs = new int[this._strs.length];
        for (int i = 0; i < this._strs.length; ++i) {
            idxs[i] = ArrayUtils.find(names, this._strs[i]);
            int idx = idxs[i];
            if (idx != -1) continue;
            throw new IllegalArgumentException("Column " + this._strs[i] + " not found");
        }
        return idxs;
    }
}

