/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import java.util.Arrays;
import water.Key;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.Vec;
import water.rapids.AST;
import water.rapids.ASTPrim;
import water.rapids.Env;
import water.rapids.Val;
import water.rapids.ValFrame;
import water.rapids.ValNum;
import water.util.ArrayUtils;

class ASTVariance
extends ASTPrim {
    ASTVariance() {
    }

    @Override
    public String[] args() {
        return new String[]{"ary", "x", "y", "use", "symmetric"};
    }

    @Override
    int nargs() {
        return 5;
    }

    @Override
    public String str() {
        return "var";
    }

    @Override
    public Val apply(Env env, Env.StackHelp stk, AST[] asts) {
        Mode mode;
        Frame frx = stk.track(asts[1].exec(env)).getFrame();
        Frame fry = stk.track(asts[2].exec(env)).getFrame();
        if (frx.numRows() != fry.numRows()) {
            throw new IllegalArgumentException("Frames must have the same number of rows, found " + frx.numRows() + " and " + fry.numRows());
        }
        String use = stk.track(asts[3].exec(env)).getStr();
        boolean symmetric = asts[4].exec(env).getNum() == 1.0;
        String string = use;
        int n = -1;
        switch (string.hashCode()) {
            case 401590963: {
                if (!string.equals("everything")) break;
                n = 0;
                break;
            }
            case -913287373: {
                if (!string.equals("all.obs")) break;
                n = 1;
                break;
            }
            case -411139381: {
                if (!string.equals("complete.obs")) break;
                n = 2;
            }
        }
        switch (n) {
            case 0: {
                mode = Mode.Everything;
                break;
            }
            case 1: {
                mode = Mode.AllObs;
                break;
            }
            case 2: {
                mode = Mode.CompleteObs;
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown use mode: " + use);
            }
        }
        return fry.numRows() == 1L ? this.scalar(frx, fry, mode) : this.array(frx, fry, mode, symmetric);
    }

    private ValNum scalar(Frame frx, Frame fry, Mode mode) {
        double yval;
        double xval;
        if (frx.numCols() != fry.numCols()) {
            throw new IllegalArgumentException("Single rows must have the same number of columns, found " + frx.numCols() + " and " + fry.numCols());
        }
        Vec[] vecxs = frx.vecs();
        Vec[] vecys = fry.vecs();
        double xmean = 0.0;
        double ymean = 0.0;
        double ncols = frx.numCols();
        double NACount = 0.0;
        double ss = 0.0;
        int r = 0;
        while ((double)r < ncols) {
            xval = vecxs[r].at(0L);
            yval = vecys[r].at(0L);
            if (Double.isNaN(xval) || Double.isNaN(yval)) {
                NACount += 1.0;
            } else {
                xmean += xval;
                ymean += yval;
            }
            ++r;
        }
        xmean /= ncols - NACount;
        ymean /= ncols - NACount;
        if (NACount != 0.0) {
            if (mode.equals((Object)Mode.AllObs)) {
                throw new IllegalArgumentException("Mode is 'all.obs' but NAs are present");
            }
            if (mode.equals((Object)Mode.Everything)) {
                return new ValNum(Double.NaN);
            }
        }
        r = 0;
        while ((double)r < ncols) {
            xval = vecxs[r].at(0L);
            yval = vecys[r].at(0L);
            if (!Double.isNaN(xval) && !Double.isNaN(yval)) {
                ss += (vecxs[r].at(0L) - xmean) * (vecys[r].at(0L) - ymean);
            }
            ++r;
        }
        return new ValNum(ss / (ncols - NACount - 1.0));
    }

    private Val array(Frame frx, Frame fry, Mode mode, boolean symmetric) {
        Vec[] vecxs = frx.vecs();
        int ncolx = vecxs.length;
        Vec[] vecys = fry.vecs();
        int ncoly = vecys.length;
        if (mode.equals((Object)Mode.Everything) || mode.equals((Object)Mode.AllObs)) {
            if (mode.equals((Object)Mode.AllObs)) {
                for (Vec v : vecxs) {
                    if (v.naCnt() == 0L) continue;
                    throw new IllegalArgumentException("Mode is 'all.obs' but NAs are present");
                }
                if (!symmetric) {
                    for (Vec v : vecys) {
                        if (v.naCnt() == 0L) continue;
                        throw new IllegalArgumentException("Mode is 'all.obs' but NAs are present");
                    }
                }
            }
            CoVarTaskEverything[] cvs = new CoVarTaskEverything[ncoly];
            double[] xmeans = new double[ncolx];
            for (int x = 0; x < ncoly; ++x) {
                xmeans[x] = vecxs[x].mean();
            }
            if (symmetric) {
                int y;
                if (ncoly == 1) {
                    return new ValNum(vecys[0].naCnt() == 0L ? vecys[0].sigma() * vecys[0].sigma() : Double.NaN);
                }
                int[] idx = new int[ncoly];
                for (int y2 = 1; y2 < ncoly; ++y2) {
                    idx[y2] = y2;
                }
                int[] first_index = new int[]{0};
                for (int y3 = 0; y3 < ncoly - 1; ++y3) {
                    idx = ArrayUtils.removeIds(idx, first_index);
                    Frame reduced_fr = new Frame(frx.vecs(idx));
                    cvs[y3] = (CoVarTaskEverything)new CoVarTaskEverything(vecys[y3].mean(), xmeans).dfork(new Frame(vecys[y3]).add(reduced_fr));
                }
                double[][] res_array = new double[ncoly][ncoly];
                for (y = 0; y < ncoly; ++y) {
                    res_array[y][y] = vecys[y].naCnt() == 0L ? vecys[y].sigma() * vecys[y].sigma() : Double.NaN;
                }
                for (y = 0; y < ncoly - 1; ++y) {
                    System.arraycopy(ArrayUtils.div(((CoVarTaskEverything)cvs[y].getResult())._covs, (double)(fry.numRows() - 1L)), 0, res_array[y], y + 1, ncoly - y - 1);
                }
                for (y = 0; y < ncoly - 1; ++y) {
                    for (int x = y + 1; x < ncoly; ++x) {
                        res_array[x][y] = res_array[y][x];
                    }
                }
                Vec[] res = new Vec[ncoly];
                Key<Vec>[] keys = Vec.VectorGroup.VG_LEN1.addVecs(ncoly);
                for (int y4 = 0; y4 < ncoly; ++y4) {
                    res[y4] = Vec.makeVec(res_array[y4], keys[y4]);
                }
                return new ValFrame(new Frame(fry._names, res));
            }
            for (int y = 0; y < ncoly; ++y) {
                cvs[y] = (CoVarTaskEverything)new CoVarTaskEverything(vecys[y].mean(), xmeans).dfork(new Frame(vecys[y]).add(frx));
            }
            if (ncolx == 1 && ncoly == 1) {
                return new ValNum(((CoVarTaskEverything)cvs[0].getResult())._covs[0] / (double)(fry.numRows() - 1L));
            }
            Vec[] res = new Vec[ncoly];
            Key<Vec>[] keys = Vec.VectorGroup.VG_LEN1.addVecs(ncoly);
            for (int y = 0; y < ncoly; ++y) {
                res[y] = Vec.makeVec(ArrayUtils.div(((CoVarTaskEverything)cvs[y].getResult())._covs, (double)(fry.numRows() - 1L)), keys[y]);
            }
            return new ValFrame(new Frame(fry._names, res));
        }
        if (symmetric) {
            int y;
            if (ncoly == 1) {
                return new ValNum(vecys[0].sigma() * vecys[0].sigma());
            }
            CoVarTaskCompleteObsMeanSym taskCompleteObsMeanSym = (CoVarTaskCompleteObsMeanSym)new CoVarTaskCompleteObsMeanSym().doAll(fry);
            long NACount = taskCompleteObsMeanSym._NACount;
            double[] ymeans = ArrayUtils.div(taskCompleteObsMeanSym._ysum, (double)(fry.numRows() - NACount));
            CoVarTaskCompleteObsSym cvs = (CoVarTaskCompleteObsSym)new CoVarTaskCompleteObsSym(ymeans).doAll(new Frame(fry));
            double[][] res_array = new double[ncoly][ncoly];
            for (y = 0; y < ncoly; ++y) {
                System.arraycopy(ArrayUtils.div(cvs._covs[y], (double)(fry.numRows() - 1L - NACount)), y, res_array[y], y, ncoly - y);
            }
            for (y = 0; y < ncoly - 1; ++y) {
                for (int x = y + 1; x < ncoly; ++x) {
                    res_array[x][y] = res_array[y][x];
                }
            }
            Vec[] res = new Vec[ncoly];
            Key<Vec>[] keys = Vec.VectorGroup.VG_LEN1.addVecs(ncoly);
            for (int y5 = 0; y5 < ncoly; ++y5) {
                res[y5] = Vec.makeVec(res_array[y5], keys[y5]);
            }
            return new ValFrame(new Frame(fry._names, res));
        }
        CoVarTaskCompleteObsMean taskCompleteObsMean = (CoVarTaskCompleteObsMean)new CoVarTaskCompleteObsMean(ncoly, ncolx).doAll(new Frame(fry).add(frx));
        long NACount = taskCompleteObsMean._NACount;
        double[] ymeans = ArrayUtils.div(taskCompleteObsMean._ysum, (double)(fry.numRows() - NACount));
        double[] xmeans = ArrayUtils.div(taskCompleteObsMean._xsum, (double)(fry.numRows() - NACount));
        CoVarTaskCompleteObs cvs = (CoVarTaskCompleteObs)new CoVarTaskCompleteObs(ymeans, xmeans).doAll(new Frame(fry).add(frx));
        if (ncolx == 1 && ncoly == 1) {
            return new ValNum(cvs._covs[0][0] / (double)(fry.numRows() - 1L - NACount));
        }
        Vec[] res = new Vec[ncoly];
        Key<Vec>[] keys = Vec.VectorGroup.VG_LEN1.addVecs(ncoly);
        for (int y = 0; y < ncoly; ++y) {
            res[y] = Vec.makeVec(ArrayUtils.div(cvs._covs[y], (double)(fry.numRows() - 1L - NACount)), keys[y]);
        }
        return new ValFrame(new Frame(fry._names, res));
    }

    static double getVar(Vec v) {
        return v.naCnt() == 0L ? v.sigma() * v.sigma() : Double.NaN;
    }

    private static class CoVarTaskCompleteObsSym
    extends MRTask<CoVarTaskCompleteObsSym> {
        double[][] _covs;
        final double[] _ymeans;

        CoVarTaskCompleteObsSym(double[] ymeans) {
            this._ymeans = ymeans;
        }

        @Override
        public void map(Chunk[] cs) {
            int ncoly = this._ymeans.length;
            double[] yvals = new double[ncoly];
            this._covs = new double[ncoly][ncoly];
            int len = cs[0]._len;
            for (int row = 0; row < len; ++row) {
                double yval;
                int y;
                boolean add = true;
                Arrays.fill(yvals, 0.0);
                for (y = 0; y < ncoly; ++y) {
                    Chunk cy = cs[y];
                    yval = cy.atd(row);
                    if (Double.isNaN(yval)) {
                        add = false;
                        break;
                    }
                    yvals[y] = yval;
                }
                if (!add) continue;
                for (y = 0; y < ncoly; ++y) {
                    double[] _covs_y = this._covs[y];
                    yval = yvals[y];
                    double ymean = this._ymeans[y];
                    for (int x = y; x < ncoly; ++x) {
                        int n = x;
                        _covs_y[n] = _covs_y[n] + (yvals[x] - this._ymeans[x]) * (yval - ymean);
                    }
                }
            }
        }

        @Override
        public void reduce(CoVarTaskCompleteObsSym cvt) {
            ArrayUtils.add(this._covs, cvt._covs);
        }
    }

    private static class CoVarTaskCompleteObsMeanSym
    extends MRTask<CoVarTaskCompleteObsMeanSym> {
        double[] _ysum;
        long _NACount;

        private CoVarTaskCompleteObsMeanSym() {
        }

        @Override
        public void map(Chunk[] cs) {
            int ncoly = cs.length;
            this._ysum = new double[ncoly];
            double[] yvals = new double[ncoly];
            int len = cs[0]._len;
            for (int row = 0; row < len; ++row) {
                boolean add = true;
                Arrays.fill(yvals, 0.0);
                for (int y = 0; y < ncoly; ++y) {
                    Chunk cy = cs[y];
                    double yval = cy.atd(row);
                    if (Double.isNaN(yval)) {
                        ++this._NACount;
                        add = false;
                        break;
                    }
                    yvals[y] = yval;
                }
                if (!add) continue;
                ArrayUtils.add(this._ysum, yvals);
            }
        }

        @Override
        public void reduce(CoVarTaskCompleteObsMeanSym cvt) {
            ArrayUtils.add(this._ysum, cvt._ysum);
            this._NACount += cvt._NACount;
        }
    }

    private static class CoVarTaskCompleteObs
    extends MRTask<CoVarTaskCompleteObs> {
        double[][] _covs;
        final double[] _xmeans;
        final double[] _ymeans;

        CoVarTaskCompleteObs(double[] ymeans, double[] xmeans) {
            this._ymeans = ymeans;
            this._xmeans = xmeans;
        }

        @Override
        public void map(Chunk[] cs) {
            int ncolx = this._xmeans.length;
            int ncoly = this._ymeans.length;
            double[] xvals = new double[ncolx];
            double[] yvals = new double[ncoly];
            this._covs = new double[ncoly][ncolx];
            int len = cs[0]._len;
            for (int row = 0; row < len; ++row) {
                double yval;
                int y;
                boolean add = true;
                Arrays.fill(xvals, 0.0);
                Arrays.fill(yvals, 0.0);
                for (y = 0; y < ncoly; ++y) {
                    Chunk cy = cs[y];
                    yval = cy.atd(row);
                    if (Double.isNaN(yval)) {
                        add = false;
                        break;
                    }
                    yvals[y] = yval;
                }
                if (add) {
                    for (int x = 0; x < ncolx; ++x) {
                        Chunk cx = cs[x + ncoly];
                        double xval = cx.atd(row);
                        if (Double.isNaN(xval)) {
                            add = false;
                            break;
                        }
                        xvals[x] = xval;
                    }
                }
                if (!add) continue;
                for (y = 0; y < ncoly; ++y) {
                    double[] _covs_y = this._covs[y];
                    yval = yvals[y];
                    double ymean = this._ymeans[y];
                    for (int x = 0; x < ncolx; ++x) {
                        int n = x;
                        _covs_y[n] = _covs_y[n] + (xvals[x] - this._xmeans[x]) * (yval - ymean);
                    }
                }
            }
        }

        @Override
        public void reduce(CoVarTaskCompleteObs cvt) {
            ArrayUtils.add(this._covs, cvt._covs);
        }
    }

    private static class CoVarTaskCompleteObsMean
    extends MRTask<CoVarTaskCompleteObsMean> {
        double[] _xsum;
        double[] _ysum;
        long _NACount;
        int _ncolx;
        int _ncoly;

        CoVarTaskCompleteObsMean(int ncoly, int ncolx) {
            this._ncolx = ncolx;
            this._ncoly = ncoly;
        }

        @Override
        public void map(Chunk[] cs) {
            this._xsum = new double[this._ncolx];
            this._ysum = new double[this._ncoly];
            double[] xvals = new double[this._ncolx];
            double[] yvals = new double[this._ncoly];
            int len = cs[0]._len;
            for (int row = 0; row < len; ++row) {
                boolean add = true;
                Arrays.fill(xvals, 0.0);
                Arrays.fill(yvals, 0.0);
                for (int y = 0; y < this._ncoly; ++y) {
                    Chunk cy = cs[y];
                    double yval = cy.atd(row);
                    if (Double.isNaN(yval)) {
                        ++this._NACount;
                        add = false;
                        break;
                    }
                    yvals[y] = yval;
                }
                if (add) {
                    for (int x = 0; x < this._ncolx; ++x) {
                        Chunk cx = cs[x + this._ncoly];
                        double xval = cx.atd(row);
                        if (Double.isNaN(xval)) {
                            ++this._NACount;
                            add = false;
                            break;
                        }
                        xvals[x] = xval;
                    }
                }
                if (!add) continue;
                ArrayUtils.add(this._xsum, xvals);
                ArrayUtils.add(this._ysum, yvals);
            }
        }

        @Override
        public void reduce(CoVarTaskCompleteObsMean cvt) {
            ArrayUtils.add(this._xsum, cvt._xsum);
            ArrayUtils.add(this._ysum, cvt._ysum);
            this._NACount += cvt._NACount;
        }
    }

    private static class CoVarTaskEverything
    extends MRTask<CoVarTaskEverything> {
        double[] _covs;
        final double[] _xmeans;
        final double _ymean;

        CoVarTaskEverything(double ymean, double[] xmeans) {
            this._ymean = ymean;
            this._xmeans = xmeans;
        }

        @Override
        public void map(Chunk[] cs) {
            int ncolsx = cs.length - 1;
            Chunk cy = cs[0];
            int len = cy._len;
            this._covs = new double[ncolsx];
            for (int x = 0; x < ncolsx; ++x) {
                double sum = 0.0;
                Chunk cx = cs[x + 1];
                double xmean = this._xmeans[x];
                for (int row = 0; row < len; ++row) {
                    sum += (cx.atd(row) - xmean) * (cy.atd(row) - this._ymean);
                }
                this._covs[x] = sum;
            }
        }

        @Override
        public void reduce(CoVarTaskEverything cvt) {
            ArrayUtils.add(this._covs, cvt._covs);
        }
    }

    private static enum Mode {
        Everything,
        AllObs,
        CompleteObs;

    }
}

