/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import water.H2O;
import water.fvec.Frame;
import water.rapids.AST;
import water.rapids.ASTExec;
import water.rapids.ASTFun;
import water.rapids.ASTId;
import water.rapids.ASTNum;
import water.rapids.ASTNumList;
import water.rapids.ASTStr;
import water.rapids.ASTStrList;
import water.rapids.Session;
import water.rapids.Val;

public class Exec {
    final String _str;
    int _x;

    public Exec(String str) {
        this._str = str;
    }

    public static Val exec(String rapids) {
        Session ses = new Session();
        try {
            AST ast = new Exec(rapids).parse();
            Val val = ses.exec(ast, null);
            return ses.end(val);
        }
        catch (Throwable ex) {
            throw ses.endQuietly(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Val exec(String rapids, Session ses) {
        AST ast = new Exec(rapids).parse();
        Session session = ses;
        synchronized (session) {
            Val val = ses.exec(ast, null);
            if (val.isFrame()) {
                Frame fr = val.getFrame();
                assert (fr._key != null);
                if (ses.FRAMES.containsKey(fr)) {
                    throw H2O.unimpl();
                }
                ses.addRefCnt(fr, -1);
            }
            return val;
        }
    }

    public AST parse() {
        switch (this.skipWS()) {
            case '(': {
                return new ASTExec(this);
            }
            case '{': {
                return new ASTFun(this);
            }
            case '#': {
                ++this._x;
            }
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return new ASTNum(this);
            }
            case '\"': {
                return new ASTStr(this, '\"');
            }
            case '\'': {
                return new ASTStr(this, '\'');
            }
            case '[': {
                return Exec.isQuote(this.xpeek('[').skipWS()) ? new ASTStrList(this) : new ASTNumList(this);
            }
            case ' ': {
                throw new IllegalASTException("Expected an expression but ran out of text");
            }
            case '-': {
                return this.peek(1) >= '0' && this.peek(1) <= '9' ? new ASTNum(this) : new ASTId(this);
            }
        }
        return new ASTId(this);
    }

    char peek() {
        return this._x < this._str.length() ? this._str.charAt(this._x) : (char)' ';
    }

    char peek(int off) {
        return this._x + off < this._str.length() ? this._str.charAt(this._x + off) : (char)' ';
    }

    Exec xpeek(char c) {
        if (this.peek() != c) {
            throw new IllegalASTException("Expected '" + c + "'. Got: '" + this.peek() + "'.  unparsed: " + this.unparsed() + " ; _x = " + this._x);
        }
        ++this._x;
        return this;
    }

    char skipWS() {
        char c = ' ';
        while (this._x < this._str.length() && Exec.isWS(c = this.peek())) {
            ++this._x;
        }
        return c;
    }

    String token() {
        char c;
        int start = this._x;
        while (!Exec.isWS(c = this.peek()) && c != ')' && c != '}') {
            ++this._x;
        }
        if (start == this._x) {
            throw new IllegalArgumentException("Missing token");
        }
        return this._str.substring(start, this._x);
    }

    double number() {
        char c;
        int start = this._x;
        while (!Exec.isWS(c = this.peek()) && c != ')' && c != ']' && c != ',' && c != ':') {
            ++this._x;
        }
        return Double.valueOf(this._str.substring(start, this._x));
    }

    String match(char c) {
        int start = ++this._x;
        while (this.peek() != c) {
            ++this._x;
        }
        ++this._x;
        return this._str.substring(start, this._x - 1);
    }

    String unparsed() {
        return this._str.substring(this._x, this._str.length());
    }

    static boolean isWS(char c) {
        return c == ' ';
    }

    static boolean isQuote(char c) {
        return c == '\'' || c == '\"';
    }

    AST throwErr(String msg) {
        int i;
        int idx = this._str.length() - 1;
        int lo = this._x;
        int hi = idx;
        String str = this._str;
        if (idx < lo) {
            hi = lo = idx;
        }
        String s = msg + '\n' + str + '\n';
        for (i = 0; i < lo; ++i) {
            s = s + ' ';
        }
        s = s + '^';
        ++i;
        while (i < hi) {
            s = s + '-';
            ++i;
        }
        if (i <= hi) {
            s = s + '^';
        }
        s = s + '\n';
        throw new IllegalASTException(s);
    }

    static class IllegalASTException
    extends IllegalArgumentException {
        IllegalASTException(String s) {
            super(s);
        }
    }
}

