/*
 * Decompiled with CFR 0.152.
 */
package water.util;

import java.util.Arrays;
import water.AutoBuffer;
import water.Iced;
import water.IcedWrapper;

public class TwoDimTable
extends Iced {
    private String tableHeader;
    private String tableDescription;
    private String[] rowHeaders;
    private String[] colHeaders;
    private String[] colTypes;
    private String[] colFormats;
    private IcedWrapper[][] cellValues;
    private String colHeaderForRowHeaders;
    public static final double emptyDouble = 9.9E-324;
    private static int PRINTOUT_ROW_LIMIT = 20;

    public static boolean isEmpty(double d) {
        return Double.doubleToRawLongBits(d) == Double.doubleToRawLongBits(9.9E-324);
    }

    public TwoDimTable(String tableHeader, String tableDescription, String[] rowHeaders, String[] colHeaders, String[] colTypes, String[] colFormats, String colHeaderForRowHeaders) {
        if (tableHeader == null) {
            tableHeader = "";
        }
        if (tableDescription == null) {
            tableDescription = "";
        }
        this.colHeaderForRowHeaders = colHeaderForRowHeaders;
        if (rowHeaders == null) {
            throw new IllegalArgumentException("rowHeaders is null");
        }
        for (int r = 0; r < rowHeaders.length; ++r) {
            if (rowHeaders[r] != null) continue;
            rowHeaders[r] = "";
        }
        if (colHeaders == null) {
            throw new IllegalArgumentException("colHeaders is null");
        }
        for (int c = 0; c < colHeaders.length; ++c) {
            if (colHeaders[c] != null) continue;
            colHeaders[c] = "";
        }
        int rowDim = rowHeaders.length;
        int colDim = colHeaders.length;
        if (colTypes == null) {
            colTypes = new String[colDim];
            Arrays.fill(colTypes, "string");
        } else {
            if (colTypes.length != colDim) {
                throw new IllegalArgumentException("colTypes must have the same length as colHeaders");
            }
            for (int c = 0; c < colDim; ++c) {
                colTypes[c] = colTypes[c].toLowerCase();
                if (colTypes[c].equals("double") || colTypes[c].equals("float") || colTypes[c].equals("int") || colTypes[c].equals("long") || colTypes[c].equals("string")) continue;
                throw new IllegalArgumentException("colTypes values must be one of \"double\", \"float\", \"int\", \"long\", or \"string\"");
            }
        }
        if (colFormats == null) {
            colFormats = new String[colDim];
            Arrays.fill(colFormats, "%s");
        } else if (colFormats.length != colDim) {
            throw new IllegalArgumentException("colFormats must have the same length as colHeaders");
        }
        this.tableHeader = tableHeader;
        this.tableDescription = tableDescription;
        this.rowHeaders = rowHeaders;
        this.colHeaders = colHeaders;
        this.colTypes = colTypes;
        this.colFormats = colFormats;
        this.cellValues = new IcedWrapper[rowDim][colDim];
    }

    /*
     * WARNING - void declaration
     */
    public TwoDimTable(String tableHeader, String tableDescription, String[] rowHeaders, String[] colHeaders, String[] colTypes, String[] colFormats, String colHeaderForRowHeaders, String[][] strCellValues, double[][] dblCellValues) {
        this(tableHeader, tableDescription, rowHeaders, colHeaders, colTypes, colFormats, colHeaderForRowHeaders);
        int c;
        assert (TwoDimTable.isEmpty(9.9E-324));
        assert (!Arrays.equals(new AutoBuffer().put8d(9.9E-324).buf(), new AutoBuffer().put8d(Double.NaN).buf()));
        int rowDim = rowHeaders.length;
        int colDim = colHeaders.length;
        for (c = 0; c < colDim; ++c) {
            if (!colTypes[c].equalsIgnoreCase("string")) continue;
            for (Object[] vec : strCellValues) {
                if (vec == null) {
                    throw new IllegalArgumentException("Null string in strCellValues");
                }
                if (vec.length == colDim) continue;
                throw new IllegalArgumentException("Each row in strCellValues must have the same length as colHeaders");
            }
            break;
        }
        for (c = 0; c < colDim; ++c) {
            if (colTypes[c].equalsIgnoreCase("string")) continue;
            double[][] dArray = dblCellValues;
            int len$ = dArray.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                Object[] vec;
                vec = dArray[i$];
                if (vec.length == colDim) continue;
                throw new IllegalArgumentException("Each row in dblCellValues must have the same length as colHeaders");
            }
            break;
        }
        for (int r = 0; r < rowDim; ++r) {
            void var13_17;
            boolean bl = false;
            while (var13_17 < colDim) {
                if (strCellValues[r] != null && strCellValues[r][var13_17] != null && dblCellValues[r] != null && !TwoDimTable.isEmpty(dblCellValues[r][var13_17])) {
                    throw new IllegalArgumentException("Cannot provide both a String and a Double at row " + r + " and column " + (int)var13_17 + ".");
                }
                ++var13_17;
            }
        }
        block19: for (c = 0; c < colDim; ++c) {
            String string = colTypes[c];
            int n = -1;
            switch (string.hashCode()) {
                case -1325958191: {
                    if (!string.equals("double")) break;
                    n = 0;
                    break;
                }
                case 97526364: {
                    if (!string.equals("float")) break;
                    n = 1;
                    break;
                }
                case 104431: {
                    if (!string.equals("int")) break;
                    n = 2;
                    break;
                }
                case 3327612: {
                    if (!string.equals("long")) break;
                    n = 3;
                    break;
                }
                case -891985903: {
                    if (!string.equals("string")) break;
                    n = 4;
                }
            }
            switch (n) {
                case 0: 
                case 1: {
                    int r;
                    for (r = 0; r < rowDim; ++r) {
                        this.set(r, c, dblCellValues[r][c]);
                    }
                    continue block19;
                }
                case 2: {
                    int r;
                    for (r = 0; r < rowDim; ++r) {
                        this.set(r, c, (int)dblCellValues[r][c]);
                    }
                    continue block19;
                }
                case 3: {
                    int r;
                    for (r = 0; r < rowDim; ++r) {
                        this.set(r, c, (long)dblCellValues[r][c]);
                    }
                    continue block19;
                }
                case 4: {
                    int r;
                    for (r = 0; r < rowDim; ++r) {
                        this.set(r, c, strCellValues[r][c]);
                    }
                    continue block19;
                }
                default: {
                    throw new IllegalArgumentException("Column type " + colTypes[c] + " is not supported.");
                }
            }
        }
    }

    public Object get(int row, int col) {
        return this.cellValues[row][col] == null ? null : this.cellValues[row][col].get();
    }

    public String getTableHeader() {
        return this.tableHeader;
    }

    public String getTableDescription() {
        return this.tableDescription;
    }

    public String[] getRowHeaders() {
        return this.rowHeaders;
    }

    public String[] getColHeaders() {
        return this.colHeaders;
    }

    public String getColHeaderForRowHeaders() {
        return this.colHeaderForRowHeaders;
    }

    public String[] getColTypes() {
        return this.colTypes;
    }

    public String[] getColFormats() {
        return this.colFormats;
    }

    public IcedWrapper[][] getCellValues() {
        return this.cellValues;
    }

    public int getRowDim() {
        return this.rowHeaders.length;
    }

    public int getColDim() {
        return this.colHeaders.length;
    }

    public void set(int row, int col, Object o) {
        if (o == null) {
            this.cellValues[row][col] = null;
            return;
        }
        this.cellValues[row][col] = this.colTypes[col].equals("double") ? new IcedWrapper(new Double(o.toString())) : (this.colTypes[col].equals("float") ? new IcedWrapper(new Float(o.toString())) : (this.colTypes[col].equals("int") ? new IcedWrapper(new Integer(o.toString())) : (this.colTypes[col].equals("long") ? new IcedWrapper(new Long(o.toString())) : new IcedWrapper(o))));
    }

    public String toString() {
        return this.toString(2, true);
    }

    public String toString(int pad) {
        return this.toString(pad, true);
    }

    private boolean skip(int row) {
        assert (PRINTOUT_ROW_LIMIT % 2 == 0);
        if (this.getRowDim() <= PRINTOUT_ROW_LIMIT) {
            return false;
        }
        if (row <= PRINTOUT_ROW_LIMIT / 2) {
            return false;
        }
        return row < this.getRowDim() - PRINTOUT_ROW_LIMIT / 2;
    }

    /*
     * WARNING - void declaration
     */
    public String toString(int pad, boolean full) {
        void var10_18;
        int c;
        String[][] cellStrings;
        if (pad < 0) {
            throw new IllegalArgumentException("pad must be a non-negative integer");
        }
        int rowDim = this.getRowDim();
        int colDim = this.getColDim();
        int actualRowDim = full ? rowDim : Math.min(PRINTOUT_ROW_LIMIT + 1, rowDim);
        for (Object[] objectArray : cellStrings = new String[actualRowDim + 1][colDim + 1]) {
            Arrays.fill(objectArray, "");
        }
        cellStrings[0][0] = this.colHeaderForRowHeaders != null ? this.colHeaderForRowHeaders : "";
        int row = 0;
        for (int r = 0; r < rowDim; ++r) {
            if (!full && this.skip(r)) continue;
            cellStrings[row + 1][0] = this.rowHeaders[r];
            ++row;
        }
        for (c = 0; c < colDim; ++c) {
            cellStrings[0][c + 1] = this.colHeaders[c];
        }
        for (c = 0; c < colDim; ++c) {
            String formatString = this.colFormats[c];
            row = 0;
            for (int i = 0; i < rowDim; ++i) {
                if (!full && this.skip(i)) continue;
                String string = this.colTypes[c];
                int n = -1;
                switch (string.hashCode()) {
                    case -1325958191: {
                        if (!string.equals("double")) break;
                        n = 0;
                        break;
                    }
                    case 97526364: {
                        if (!string.equals("float")) break;
                        n = 1;
                        break;
                    }
                    case 104431: {
                        if (!string.equals("int")) break;
                        n = 2;
                        break;
                    }
                    case 3327612: {
                        if (!string.equals("long")) break;
                        n = 3;
                    }
                }
                switch (n) {
                    case 0: {
                        cellStrings[row + 1][c + 1] = this.get(i, c) == null || TwoDimTable.isEmpty((Double)this.get(i, c)) ? "" : String.format(formatString, (Double)this.cellValues[i][c].get());
                        break;
                    }
                    case 1: {
                        cellStrings[row + 1][c + 1] = this.get(i, c) == null ? "" : String.format(formatString, (Float)this.cellValues[i][c].get());
                        break;
                    }
                    case 2: {
                        cellStrings[row + 1][c + 1] = this.get(i, c) == null ? "" : String.format(formatString, (Integer)this.cellValues[i][c].get());
                        break;
                    }
                    case 3: {
                        cellStrings[row + 1][c + 1] = this.get(i, c) == null ? "" : String.format(formatString, (Long)this.cellValues[i][c].get());
                        break;
                    }
                    default: {
                        if (this.get(i, c) == null) break;
                        cellStrings[row + 1][c + 1] = String.format(formatString, this.cellValues[i][c]);
                    }
                }
                ++row;
            }
        }
        int[] colLen = new int[colDim + 1];
        for (int c2 = 0; c2 <= colDim; ++c2) {
            for (int i = 0; i <= actualRowDim; ++i) {
                colLen[c2] = Math.max(colLen[c2], cellStrings[i][c2].length());
            }
        }
        StringBuilder sb = new StringBuilder();
        if (this.tableHeader.length() > 0) {
            sb.append(this.tableHeader);
        }
        if (this.tableDescription.length() > 0) {
            sb.append(" (").append(this.tableDescription).append(")");
        }
        sb.append(":\n");
        boolean bl = false;
        while (var10_18 <= actualRowDim) {
            int len = colLen[0];
            if (actualRowDim != rowDim && var10_18 - true == PRINTOUT_ROW_LIMIT / 2) {
                assert (!full);
                sb.append("---");
            } else {
                if (len > 0) {
                    sb.append(String.format("%" + colLen[0] + "s", cellStrings[var10_18][0]));
                }
                for (int c3 = 1; c3 <= colDim; ++c3) {
                    len = colLen[c3];
                    if (len <= 0) continue;
                    sb.append(String.format("%" + (len + pad) + "s", cellStrings[var10_18][c3].equals("null") ? "" : cellStrings[var10_18][c3]));
                }
            }
            sb.append("\n");
            ++var10_18;
        }
        return sb.toString();
    }
}

