/*
 * Decompiled with CFR 0.152.
 */
package hex;

import hex.ClusteringModel;
import hex.Model;
import hex.ModelMetrics;
import hex.ModelMetricsUnsupervised;
import hex.genmodel.GenModel;
import java.util.ArrayList;
import java.util.Arrays;
import water.exceptions.H2OIllegalArgumentException;
import water.fvec.Frame;
import water.util.ArrayUtils;
import water.util.TwoDimTable;

public class ModelMetricsClustering
extends ModelMetricsUnsupervised {
    public long[] _size = null;
    public double[] _withinss = null;
    public double _totss;
    public double _tot_withinss;
    public double _betweenss = Double.NaN;

    public double totss() {
        return this._totss;
    }

    public double tot_withinss() {
        return this._tot_withinss;
    }

    public double betweenss() {
        return this._betweenss;
    }

    public ModelMetricsClustering(Model model, Frame frame) {
        super(model, frame, Double.NaN);
        this._tot_withinss = Double.NaN;
        this._totss = Double.NaN;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append(" total sum of squares: " + (float)this._totss + "\n");
        sb.append(" total within sum of squares: " + (float)this._tot_withinss + "\n");
        sb.append(" total between sum of squares: " + (float)this._betweenss + "\n");
        if (this._size != null) {
            sb.append(" per cluster sizes: " + Arrays.toString(this._size) + "\n");
        }
        if (this._withinss != null) {
            sb.append(" per cluster within sum of squares: " + Arrays.toString(this._withinss) + "\n");
        }
        return sb.toString();
    }

    public TwoDimTable createCentroidStatsTable() {
        if (this._size == null || this._withinss == null) {
            return null;
        }
        ArrayList<String> colHeaders = new ArrayList<String>();
        ArrayList<String> colTypes = new ArrayList<String>();
        ArrayList<String> colFormat = new ArrayList<String>();
        colHeaders.add("Centroid");
        colTypes.add("long");
        colFormat.add("%d");
        colHeaders.add("Size");
        colTypes.add("double");
        colFormat.add("%.5f");
        colHeaders.add("Within Cluster Sum of Squares");
        colTypes.add("double");
        colFormat.add("%.5f");
        int K = this._size.length;
        assert (this._withinss.length == K);
        TwoDimTable table = new TwoDimTable("Centroid Statistics", null, new String[K], colHeaders.toArray(new String[0]), colTypes.toArray(new String[0]), colFormat.toArray(new String[0]), "");
        for (int k = 0; k < K; ++k) {
            int col = 0;
            table.set(k, col++, k + 1);
            table.set(k, col++, this._size[k]);
            table.set(k, col++, this._withinss[k]);
        }
        return table;
    }

    public static class MetricBuilderClustering
    extends ModelMetricsUnsupervised.MetricBuilderUnsupervised {
        public long[] _size;
        public double[] _within_sumsqe;
        private double[] _colSum;
        private double[] _colSumSq;

        public MetricBuilderClustering(int ncol, int nclust) {
            this._work = new double[ncol];
            this._size = new long[nclust];
            this._within_sumsqe = new double[nclust];
            Arrays.fill(this._size, 0L);
            Arrays.fill(this._within_sumsqe, 0.0);
            this._colSum = new double[ncol];
            this._colSumSq = new double[ncol];
            Arrays.fill(this._colSum, 0.0);
            Arrays.fill(this._colSumSq, 0.0);
        }

        @Override
        public double[] perRow(double[] preds, float[] dataRow, Model m) {
            assert (m instanceof ClusteringModel);
            assert (!Double.isNaN(preds[0]));
            ClusteringModel clm = (ClusteringModel)m;
            boolean standardize = ((ClusteringModel.ClusteringOutput)clm._output)._centers_std_raw != null;
            double[][] centers = standardize ? ((ClusteringModel.ClusteringOutput)clm._output)._centers_std_raw : ((ClusteringModel.ClusteringOutput)clm._output)._centers_raw;
            double[] sub = standardize ? ((ClusteringModel.ClusteringOutput)clm._output)._normSub : null;
            double[] mul = standardize ? ((ClusteringModel.ClusteringOutput)clm._output)._normMul : null;
            int clus = (int)preds[0];
            double[] colSum = new double[this._colSum.length];
            double[] colSumSq = new double[this._colSumSq.length];
            double sqr = GenModel.KMeans_distance((double[])centers[clus], (float[])dataRow, (String[][])clm._output._domains, (double[])sub, (double[])mul, (double[])colSum, (double[])colSumSq);
            ArrayUtils.add(this._colSum, colSum);
            ArrayUtils.add(this._colSumSq, colSumSq);
            ++this._count;
            int n = clus;
            this._size[n] = this._size[n] + 1L;
            this._sumsqe += sqr;
            int n2 = clus;
            this._within_sumsqe[n2] = this._within_sumsqe[n2] + sqr;
            if (Double.isNaN(this._sumsqe)) {
                throw new H2OIllegalArgumentException("Sum of Squares is invalid (Double.NaN) - Check for missing values in the dataset.");
            }
            return preds;
        }

        public void reduce(ModelMetrics.MetricBuilder mb) {
            MetricBuilderClustering mm = (MetricBuilderClustering)mb;
            super.reduce(mm);
            ArrayUtils.add(this._size, mm._size);
            ArrayUtils.add(this._within_sumsqe, mm._within_sumsqe);
            ArrayUtils.add(this._colSum, mm._colSum);
            ArrayUtils.add(this._colSumSq, mm._colSumSq);
        }

        @Override
        public ModelMetrics makeModelMetrics(Model m, Frame f, Frame adaptedFrame, Frame preds) {
            int i;
            assert (m instanceof ClusteringModel);
            ClusteringModel clm = (ClusteringModel)m;
            ModelMetricsClustering mm = new ModelMetricsClustering(m, f);
            mm._size = this._size;
            mm._tot_withinss = this._sumsqe;
            mm._withinss = new double[this._size.length];
            for (i = 0; i < mm._withinss.length; ++i) {
                mm._withinss[i] = this._within_sumsqe[i];
            }
            if (((ClusteringModel.ClusteringParameters)clm._parms)._k == 1) {
                mm._totss = mm._tot_withinss;
            } else {
                mm._totss = 0.0;
                for (i = 0; i < this._colSum.length; ++i) {
                    mm._totss += this._colSumSq[i] - this._colSum[i] * this._colSum[i] / (double)f.numRows();
                }
            }
            mm._betweenss = mm._totss - mm._tot_withinss;
            return m.addMetrics(mm);
        }
    }
}

