/*
 * Decompiled with CFR 0.152.
 */
package hex;

import hex.Model;
import hex.ModelMetrics;
import hex.ModelMetricsSupervised;
import water.exceptions.H2OIllegalArgumentException;
import water.fvec.Frame;
import water.util.ArrayUtils;

public class ModelMetricsRegression
extends ModelMetricsSupervised {
    public final double _mean_residual_deviance;

    public double residual_deviance() {
        return this._mean_residual_deviance;
    }

    public ModelMetricsRegression(Model model, Frame frame, double mse, double sigma, double meanResidualDeviance) {
        super(model, frame, mse, null, sigma);
        this._mean_residual_deviance = meanResidualDeviance;
    }

    public static ModelMetricsRegression getFromDKV(Model model, Frame frame) {
        ModelMetrics mm = ModelMetrics.getFromDKV(model, frame);
        if (!(mm instanceof ModelMetricsRegression)) {
            throw new H2OIllegalArgumentException("Expected to find a Regression ModelMetrics for model: " + model._key.toString() + " and frame: " + frame._key.toString(), "Expected to find a ModelMetricsRegression for model: " + model._key.toString() + " and frame: " + frame._key.toString() + " but found a: " + mm.getClass());
        }
        return (ModelMetricsRegression)mm;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append(" mean residual deviance: " + (float)this._mean_residual_deviance + "\n");
        return sb.toString();
    }

    public static class MetricBuilderRegression<T extends MetricBuilderRegression<T>>
    extends ModelMetricsSupervised.MetricBuilderSupervised<T> {
        double _sumdeviance;

        public MetricBuilderRegression() {
            super(1, null);
        }

        @Override
        public double[] perRow(double[] ds, float[] yact, Model m) {
            return this.perRow(ds, yact, 1.0, 0.0, m);
        }

        @Override
        public double[] perRow(double[] ds, float[] yact, double w, double o, Model m) {
            if (Float.isNaN(yact[0])) {
                return ds;
            }
            if (ArrayUtils.hasNaNs(ds)) {
                return ds;
            }
            if (w == 0.0 || Double.isNaN(w)) {
                return ds;
            }
            double err = (double)yact[0] - ds[0];
            this._sumsqe += w * err * err;
            assert (!Double.isNaN(this._sumsqe));
            if (m != null) {
                this._sumdeviance += m.deviance(w, yact[0], ds[0]);
            }
            ++this._count;
            this._wcount += w;
            this._wY += w * (double)yact[0];
            this._wYY += w * (double)yact[0] * (double)yact[0];
            return ds;
        }

        @Override
        public void reduce(T mb) {
            super.reduce(mb);
            this._sumdeviance += ((MetricBuilderRegression)mb)._sumdeviance;
        }

        @Override
        public ModelMetrics makeModelMetrics(Model m, Frame f, Frame adaptedFrame, Frame preds) {
            double mse = this._sumsqe / this._wcount;
            double meanResDeviance = this._sumdeviance / this._wcount;
            return ((Model.Output)m._output).addModelMetrics(new ModelMetricsRegression(m, f, mse, this.weightedSigma(), meanResDeviance));
        }

        public String toString() {
            return " mse = " + this._sumsqe / this._wcount;
        }
    }
}

