/*
 * Decompiled with CFR 0.152.
 */
package water;

import java.util.Iterator;
import water.Futures;
import water.fvec.Chunk;
import water.fvec.NewChunk;
import water.util.Log;

public class ChunkSplitter {
    public static void extractChunkPart(Chunk ic, Chunk oc, int startRow, int nrows, Futures fs) {
        try {
            NewChunk dst = new NewChunk(oc);
            dst._sparseLen = 0;
            dst._len = 0;
            NewChunk src = new NewChunk(ic);
            src = ic.inflate_impl(src);
            assert (src._len == ic._len);
            int remain = nrows;
            Iterator<NewChunk.Value> it = src.values(startRow, startRow + nrows);
            int off = startRow - 1;
            while (it.hasNext()) {
                NewChunk.Value v = it.next();
                int rid = v.rowId0();
                assert (rid < startRow + nrows);
                int add = rid - off;
                off = rid;
                if (src.isSparseNA()) {
                    dst.addNAs(add - 1);
                } else {
                    dst.addZeros(add - 1);
                }
                v.add2Chunk(dst);
                assert ((remain -= add) >= 0);
            }
            if (src.isSparseNA()) {
                dst.addNAs(remain);
            } else {
                dst.addZeros(remain);
            }
            assert (dst._len == oc._len) : "NewChunk.dst.len = " + dst._len + ", oc._len = " + oc._len;
            dst.close(dst.cidx(), fs);
        }
        catch (RuntimeException t) {
            Log.err("gor exception in chunkSplitter, ic = " + ic + ", oc = " + oc + " startRow = " + startRow + " nrows = " + nrows);
            throw t;
        }
    }
}

