/*
 * Decompiled with CFR 0.152.
 */
package water;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import water.AutoBuffer;
import water.Freezable;
import water.Icer;
import water.MemoryManager;
import water.TypeMap;
import water.util.Log;

public abstract class Iced<D extends Iced>
implements Freezable<D>,
Externalizable {
    private volatile transient short _ice_id = 0;

    @Override
    public byte[] asBytes() {
        return this.write(new AutoBuffer()).buf();
    }

    @Override
    public D reloadFromBytes(byte[] ary) {
        return (D)this.read(new AutoBuffer(ary));
    }

    private Icer<D> icer() {
        int tyid;
        short id = this._ice_id;
        if (id != 0) assert (id == (tyid = TypeMap.onIce(this))) : "incorrectly cashed id " + id + ", typemap has " + tyid + ", type = " + this.getClass().getName();
        return TypeMap.getIcer((int)(id != 0 ? id : (this._ice_id = (short)TypeMap.onIce(this))), this);
    }

    @Override
    public final AutoBuffer write(AutoBuffer ab) {
        return this.icer().write(ab, this);
    }

    @Override
    public final AutoBuffer writeJSON(AutoBuffer ab) {
        return this.icer().writeJSON(ab, this);
    }

    @Override
    public final D read(AutoBuffer ab) {
        return (D)this.icer().read(ab, this);
    }

    @Override
    public final D readJSON(AutoBuffer ab) {
        return (D)this.icer().readJSON(ab, this);
    }

    public final String toJsonString() {
        return new String(this.writeJSON(new AutoBuffer()).buf());
    }

    @Override
    public final int frozenType() {
        return this.icer().frozenType();
    }

    @Override
    public final D clone() {
        try {
            return (D)((Iced)super.clone());
        }
        catch (CloneNotSupportedException e) {
            throw Log.throwErr(e);
        }
    }

    protected void copyOver(D src) {
        this.icer().copyOver(this, src);
    }

    @Override
    public void readExternal(ObjectInput ois) throws IOException, ClassNotFoundException {
        int x = ois.readInt();
        byte[] buf = MemoryManager.malloc1(x);
        ois.readFully(buf);
        this.read(new AutoBuffer(buf));
    }

    @Override
    public void writeExternal(ObjectOutput oos) throws IOException {
        byte[] buf = this.write(new AutoBuffer()).buf();
        oos.writeInt(buf.length);
        oos.write(buf);
    }
}

