/*
 * Decompiled with CFR 0.152.
 */
package water;

import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.plus.jaas.JAASLoginService;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.DefaultIdentityService;
import org.eclipse.jetty.security.HashLoginService;
import org.eclipse.jetty.security.IdentityService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.authentication.BasicAuthenticator;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.bio.SocketConnector;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.server.ssl.SslSocketConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.security.Constraint;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import water.DKV;
import water.H2O;
import water.H2OError;
import water.H2ONode;
import water.Iced;
import water.Key;
import water.NanoHTTPD;
import water.RPC;
import water.UDPRebooted;
import water.api.H2OErrorV3;
import water.api.RequestServer;
import water.exceptions.H2OAbstractRuntimeException;
import water.exceptions.H2OFailException;
import water.fvec.Frame;
import water.fvec.UploadFileVec;
import water.init.NodePersistentStorage;
import water.util.FileUtils;
import water.util.HttpResponseStatus;
import water.util.Log;

public class JettyHTTPD {
    private static final ThreadLocal<Long> _startMillis = new ThreadLocal();
    private static final ThreadLocal<Integer> _status = new ThreadLocal();
    private static final ThreadLocal<String> _userAgent = new ThreadLocal();
    private static volatile boolean _acceptRequests = false;
    private String _ip;
    private int _port;
    private Server _server;

    private static void startRequestLifecycle() {
        _startMillis.set(System.currentTimeMillis());
        _status.set(999);
    }

    private static void setStatus(int sc) {
        _status.set(sc);
    }

    private static int getStatus() {
        return _status.get();
    }

    protected static long getStartMillis() {
        return _startMillis.get();
    }

    private static void startTransaction(String userAgent) {
        _userAgent.set(userAgent);
    }

    private static void endTransaction() {
        _userAgent.remove();
    }

    public static String getUserAgent() {
        return _userAgent.get();
    }

    protected static void setResponseStatus(HttpServletResponse response, int sc) {
        JettyHTTPD.setStatus(sc);
        response.setStatus(sc);
    }

    protected static void sendResponseError(HttpServletResponse response, int sc, String msg) throws IOException {
        JettyHTTPD.setStatus(sc);
        response.sendError(sc, msg);
    }

    public String getScheme() {
        if (H2O.ARGS.jks != null) {
            return "https";
        }
        return "http";
    }

    public int getPort() {
        return this._port;
    }

    public String getIp() {
        return this._ip;
    }

    public Server getServer() {
        return this._server;
    }

    public void setServer(Server value) {
        this._server = value;
    }

    public void setup(String ip, int port) {
        this._ip = ip;
        this._port = port;
        System.setProperty("org.eclipse.jetty.server.Request.maxFormContentSize", Integer.toString(Integer.MAX_VALUE));
    }

    public void start(String ip, int port) throws Exception {
        this.setup(ip, port);
        if (H2O.ARGS.jks != null) {
            this.startHttps();
        } else {
            this.startHttp();
        }
    }

    public void acceptRequests() {
        _acceptRequests = true;
    }

    protected void createServer(Connector connector) throws Exception {
        this._server.setConnectors(new Connector[]{connector});
        if (H2O.ARGS.hash_login || H2O.ARGS.ldap_login || H2O.ARGS.kerberos_login) {
            HashLoginService loginService;
            if (H2O.ARGS.login_conf == null) {
                Log.err("Must specify -login_conf argument");
                H2O.exit(1);
            }
            if (H2O.ARGS.hash_login) {
                Log.info("Configuring HashLoginService");
                loginService = new HashLoginService("H2O", H2O.ARGS.login_conf);
            } else if (H2O.ARGS.ldap_login) {
                Log.info("Configuring JAASLoginService (with LDAP)");
                System.setProperty("java.security.auth.login.config", H2O.ARGS.login_conf);
                loginService = new JAASLoginService("ldaploginmodule");
            } else if (H2O.ARGS.kerberos_login) {
                Log.info("Configuring JAASLoginService (with Kerberos)");
                System.setProperty("java.security.auth.login.config", H2O.ARGS.login_conf);
                loginService = new JAASLoginService("krb5loginmodule");
            } else {
                throw H2O.fail();
            }
            DefaultIdentityService identityService = new DefaultIdentityService();
            loginService.setIdentityService((IdentityService)identityService);
            this._server.addBean((Object)loginService);
            ConstraintSecurityHandler security = new ConstraintSecurityHandler();
            Constraint constraint = new Constraint();
            constraint.setName("auth");
            constraint.setAuthenticate(true);
            security.setStrict(false);
            constraint.setRoles(new String[]{"*"});
            ConstraintMapping mapping = new ConstraintMapping();
            mapping.setPathSpec("/*");
            mapping.setConstraint(constraint);
            security.setConstraintMappings(Collections.singletonList(mapping));
            security.setAuthenticator((Authenticator)new BasicAuthenticator());
            security.setLoginService((LoginService)loginService);
            this.registerHandlers((HandlerWrapper)security);
            this._server.setHandler((Handler)security);
        } else {
            this.registerHandlers((HandlerWrapper)this._server);
        }
        this._server.start();
    }

    protected void startHttp() throws Exception {
        this._server = new Server();
        SocketConnector connector = new SocketConnector();
        connector.setHost(this._ip);
        connector.setPort(this._port);
        this.createServer((Connector)connector);
    }

    private void startHttps() throws Exception {
        this._server = new Server();
        SslContextFactory sslContextFactory = new SslContextFactory(H2O.ARGS.jks);
        sslContextFactory.setKeyStorePassword(H2O.ARGS.jks_pass);
        SslSocketConnector httpsConnector = new SslSocketConnector(sslContextFactory);
        if (this.getIp() != null) {
            httpsConnector.setHost(this.getIp());
        }
        httpsConnector.setPort(this.getPort());
        this.createServer((Connector)httpsConnector);
    }

    public void stop() throws Exception {
        if (this._server != null) {
            this._server.stop();
        }
    }

    public void registerHandlers(HandlerWrapper s) {
        GateHandler gh = new GateHandler();
        AddCommonResponseHeadersHandler rhh = new AddCommonResponseHeadersHandler();
        AuthenticationHandler authh = new AuthenticationHandler();
        ExtensionHandler1 eh1 = new ExtensionHandler1();
        ServletContextHandler context = new ServletContextHandler(3);
        context.setContextPath("/");
        context.addServlet(H2oNpsBinServlet.class, "/3/NodePersistentStorage.bin/*");
        context.addServlet(H2oPostFileServlet.class, "/3/PostFile.bin");
        context.addServlet(H2oPostFileServlet.class, "/3/PostFile");
        context.addServlet(H2oDatasetServlet.class, "/3/DownloadDataset");
        context.addServlet(H2oDatasetServlet.class, "/3/DownloadDataset.bin");
        context.addServlet(H2oDefaultServlet.class, "/");
        Handler[] handlers = new Handler[]{gh, rhh, authh, eh1, context};
        HandlerCollection hc = new HandlerCollection();
        hc.setHandlers(handlers);
        s.setHandler((Handler)hc);
    }

    protected void handle1(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
    }

    private static InputStream extractPartInputStream(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String ct = request.getContentType();
        if (!ct.startsWith("multipart/form-data")) {
            JettyHTTPD.setResponseStatus(response, 400);
            response.getWriter().write("Content type must be multipart/form-data");
            return null;
        }
        int idx = ct.indexOf("boundary=");
        if (idx < 0) {
            JettyHTTPD.setResponseStatus(response, 400);
            response.getWriter().write("Boundary missing");
            return null;
        }
        String boundaryString = ct.substring(idx + "boundary=".length());
        byte[] boundary = boundaryString.getBytes();
        ServletInputStream is = request.getInputStream();
        String line = JettyHTTPD.readLine((InputStream)is);
        while (line != null && line.trim().length() > 0) {
            line = JettyHTTPD.readLine((InputStream)is);
        }
        return new InputStreamWrapper((InputStream)is, boundary);
    }

    private static boolean validKeyName(String name) {
        byte[] arr;
        for (byte b : arr = name.getBytes()) {
            if (b == 34) {
                return false;
            }
            if (b != 92) continue;
            return false;
        }
        return true;
    }

    private static void sendErrorResponse(HttpServletResponse response, Exception e, String uri) {
        if (e instanceof H2OFailException) {
            H2OFailException ee = (H2OFailException)e;
            H2OError error = ee.toH2OError(uri);
            Log.fatal("Caught exception (fatal to the cluster): " + error.toString());
            throw H2O.fail(error.toString());
        }
        if (e instanceof H2OAbstractRuntimeException) {
            H2OAbstractRuntimeException ee = (H2OAbstractRuntimeException)e;
            H2OError error = ee.toH2OError(uri);
            Log.warn("Caught exception: " + error.toString());
            JettyHTTPD.setResponseStatus(response, 500);
            try {
                String s = ((Iced)new H2OErrorV3().fillFromImpl(error)).toJsonString();
                response.getWriter().write(s);
            }
            catch (Exception ignore) {}
        } else {
            H2OError error = new H2OError(e, uri);
            if (e instanceof IllegalArgumentException) {
                error._http_status = HttpResponseStatus.BAD_REQUEST.getCode();
            } else if (e instanceof FileNotFoundException) {
                error._http_status = HttpResponseStatus.BAD_REQUEST.getCode();
            } else if (e instanceof MalformedURLException) {
                error._http_status = HttpResponseStatus.BAD_REQUEST.getCode();
            }
            JettyHTTPD.setResponseStatus(response, error._http_status);
            Log.warn("Caught exception: " + error.toString());
            try {
                String s = ((Iced)new H2OErrorV3().fillFromImpl(error)).toJsonString();
                response.getWriter().write(s);
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
    }

    private static String getDecodedUri(HttpServletRequest request) {
        try {
            return URLDecoder.decode(request.getRequestURI(), "UTF-8");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void setCommonResponseHttpHeaders(HttpServletResponse response) {
        response.setHeader("X-h2o-build-project-version", H2O.ABV.projectVersion());
        response.setHeader("X-h2o-rest-api-version-max", Integer.toString(3));
        response.setHeader("X-h2o-cluster-id", Long.toString(H2O.CLUSTER_ID));
        response.setHeader("X-h2o-cluster-good", Boolean.toString(H2O.CLOUD.healthy()));
    }

    protected static void logRequest(String method, HttpServletRequest request, HttpServletResponse response) {
        Log.httpd(method, request.getRequestURI(), JettyHTTPD.getStatus(), System.currentTimeMillis() - JettyHTTPD.getStartMillis());
    }

    private static String readLine(InputStream in) throws IOException {
        int sz;
        StringBuilder sb = new StringBuilder();
        byte[] mem = new byte[1024];
        do {
            sz = JettyHTTPD.readBufOrLine(in, mem);
            sb.append(new String(mem, 0, sz));
        } while (sz >= mem.length && mem[sz - 1] != 10);
        if (sb.length() == 0) {
            return null;
        }
        String line = sb.toString();
        if (line.endsWith("\r\n")) {
            line = line.substring(0, line.length() - 2);
        } else if (line.endsWith("\n")) {
            line = line.substring(0, line.length() - 1);
        }
        return line;
    }

    private static int readBufOrLine(InputStream in, byte[] mem) throws IOException {
        byte[] bb = new byte[1];
        int sz = 0;
        while (sz != mem.length) {
            byte b2;
            byte b;
            try {
                in.read(bb, 0, 1);
                b = bb[0];
                mem[sz++] = b;
            }
            catch (EOFException e) {
                break;
            }
            if (b == 10 || sz == mem.length) break;
            if (b != 13) continue;
            try {
                in.read(bb, 0, 1);
                b2 = bb[0];
                mem[sz++] = b2;
            }
            catch (EOFException e) {
                break;
            }
            if (b2 != 10) continue;
            break;
        }
        return sz;
    }

    private static final class InputStreamWrapper
    extends InputStream {
        static final byte[] BOUNDARY_PREFIX = new byte[]{13, 10, 45, 45};
        final InputStream _wrapped;
        final byte[] _boundary;
        final byte[] _lookAheadBuf;
        int _lookAheadLen;

        public InputStreamWrapper(InputStream is, byte[] boundary) {
            this._wrapped = is;
            this._boundary = Arrays.copyOf(BOUNDARY_PREFIX, BOUNDARY_PREFIX.length + boundary.length);
            System.arraycopy(boundary, 0, this._boundary, BOUNDARY_PREFIX.length, boundary.length);
            this._lookAheadBuf = new byte[this._boundary.length];
            this._lookAheadLen = 0;
        }

        @Override
        public void close() throws IOException {
            this._wrapped.close();
        }

        @Override
        public int available() throws IOException {
            return this._wrapped.available();
        }

        @Override
        public long skip(long n) throws IOException {
            return this._wrapped.skip(n);
        }

        @Override
        public void mark(int readlimit) {
            this._wrapped.mark(readlimit);
        }

        @Override
        public void reset() throws IOException {
            this._wrapped.reset();
        }

        @Override
        public boolean markSupported() {
            return this._wrapped.markSupported();
        }

        @Override
        public int read() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int pos;
            if (this._lookAheadLen == -1) {
                return -1;
            }
            int readLen = this.readInternal(b, off, len);
            if (readLen != -1 && (pos = this.findBoundary(b, off, readLen)) != -1) {
                this._lookAheadLen = -1;
                return pos - off;
            }
            return readLen;
        }

        private int readInternal(byte[] b, int off, int len) throws IOException {
            if (len < this._lookAheadLen) {
                System.arraycopy(this._lookAheadBuf, 0, b, off, len);
                this._lookAheadLen -= len;
                System.arraycopy(this._lookAheadBuf, len, this._lookAheadBuf, 0, this._lookAheadLen);
                return len;
            }
            if (this._lookAheadLen > 0) {
                System.arraycopy(this._lookAheadBuf, 0, b, off, this._lookAheadLen);
                int r = Math.max(this._wrapped.read(b, off += this._lookAheadLen, len -= this._lookAheadLen), 0) + this._lookAheadLen;
                this._lookAheadLen = 0;
                return r;
            }
            return this._wrapped.read(b, off, len);
        }

        private int findBoundary(byte[] b, int off, int len) throws IOException {
            int bidx = -1;
            int idx = 0;
            for (int i = off; i < off + len; ++i) {
                if (this._boundary[idx] != b[i]) {
                    idx = 0;
                    bidx = -1;
                }
                if (this._boundary[idx] != b[i]) continue;
                if (idx == 0) {
                    bidx = i;
                }
                if (++idx != this._boundary.length) continue;
                return bidx;
            }
            if (bidx != -1) {
                assert (this._lookAheadLen == 0);
                this._lookAheadLen = this._boundary.length - idx;
                int readLen = this._wrapped.read(this._lookAheadBuf, 0, this._lookAheadLen);
                if (readLen < this._boundary.length - idx) {
                    this._lookAheadLen = readLen;
                    return -1;
                }
                for (int i = 0; i < this._boundary.length - idx; ++i) {
                    if (this._boundary[i + idx] == this._lookAheadBuf[i]) continue;
                    return -1;
                }
            }
            return bidx;
        }
    }

    public static class H2oDefaultServlet
    extends HttpServlet {
        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            this.doGeneric("GET", request, response);
        }

        protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            this.doGeneric("POST", request, response);
        }

        protected void doHead(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            this.doGeneric("HEAD", request, response);
        }

        protected void doDelete(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            this.doGeneric("DELETE", request, response);
        }

        protected void doPut(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            this.doGeneric("PUT", request, response);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doGeneric(String method, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            block12: {
                try {
                    JettyHTTPD.startTransaction(request.getHeader("User-Agent"));
                    String uri = request.getServletPath();
                    Properties headers = new Properties();
                    Enumeration en = request.getHeaderNames();
                    while (en.hasMoreElements()) {
                        String key = (String)en.nextElement();
                        String value = request.getHeader(key);
                        headers.put(key, value);
                    }
                    Properties parms = new Properties();
                    Map parameterMap = request.getParameterMap();
                    for (Map.Entry entry : parameterMap.entrySet()) {
                        String key = (String)entry.getKey();
                        String[] values = (String[])entry.getValue();
                        if (values.length == 1) {
                            parms.put(key, values[0]);
                            continue;
                        }
                        if (values.length <= 1) continue;
                        StringBuilder sb = new StringBuilder();
                        sb.append("[");
                        boolean first = true;
                        for (String value : values) {
                            if (!first) {
                                sb.append(",");
                            }
                            sb.append("\"").append(value).append("\"");
                            first = false;
                        }
                        sb.append("]");
                        parms.put(key, sb.toString());
                    }
                    NanoHTTPD.Response resp = RequestServer.SERVER.serve(uri, method, headers, parms);
                    String choppedNanoStatus = resp.status.substring(0, 3);
                    assert (choppedNanoStatus.length() == 3);
                    int sc = Integer.parseInt(choppedNanoStatus);
                    JettyHTTPD.setResponseStatus(response, sc);
                    response.setContentType(resp.mimeType);
                    Properties header = resp.header;
                    Enumeration<Object> en2 = header.keys();
                    while (en2.hasMoreElements()) {
                        String key = (String)en2.nextElement();
                        String value = header.getProperty(key);
                        response.setHeader(key, value);
                    }
                    ServletOutputStream os = response.getOutputStream();
                    if (resp instanceof NanoHTTPD.StreamResponse) {
                        NanoHTTPD.StreamResponse ssr = (NanoHTTPD.StreamResponse)resp;
                        ssr.streamWriter.writeTo((OutputStream)os);
                        break block12;
                    }
                    InputStream is = resp.data;
                    FileUtils.copyStream(is, (OutputStream)os, 1024);
                }
                catch (Throwable throwable) {
                    JettyHTTPD.logRequest(method, request, response);
                    if (H2O.getShutdownRequested()) {
                        new Thread(){

                            @Override
                            public void run() {
                                boolean[] confirmations = new boolean[H2O.CLOUD.size()];
                                if (H2O.SELF.index() >= 0) {
                                    confirmations[H2O.SELF.index()] = true;
                                }
                                for (H2ONode n : H2O.CLOUD._memary) {
                                    if (n == H2O.SELF) continue;
                                    new RPC<UDPRebooted.ShutdownTsk>(n, new UDPRebooted.ShutdownTsk(H2O.SELF, n.index(), 1000, confirmations)).call();
                                }
                                try {
                                    Thread.sleep(2000L);
                                }
                                catch (Exception ignore) {
                                    // empty catch block
                                }
                                int failedToShutdown = 0;
                                for (boolean b : confirmations) {
                                    if (b) continue;
                                    ++failedToShutdown;
                                }
                                Log.info("Orderly shutdown: " + (failedToShutdown > 0 ? failedToShutdown + " nodes failed to shut down! " : "") + " Shutting down now.");
                                H2O.closeAll();
                                H2O.exit(failedToShutdown);
                            }
                        }.start();
                    }
                    JettyHTTPD.endTransaction();
                    throw throwable;
                }
            }
            JettyHTTPD.logRequest(method, request, response);
            if (H2O.getShutdownRequested()) {
                new /* invalid duplicate definition of identical inner class */.start();
            }
            JettyHTTPD.endTransaction();
        }
    }

    public static class H2oDatasetServlet
    extends HttpServlet {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            String uri = JettyHTTPD.getDecodedUri(request);
            try {
                String suggested_fname;
                int x;
                boolean use_hex = false;
                String f_name = request.getParameter("frame_id");
                String hex_string = request.getParameter("hex_string");
                if (f_name == null) {
                    throw new RuntimeException("Cannot find value for parameter 'frame_id'");
                }
                if (hex_string != null && hex_string.toLowerCase().equals("true")) {
                    use_hex = true;
                }
                Frame dataset = (Frame)DKV.getGet(f_name);
                InputStream is = dataset.toCSV(true, use_hex);
                response.setContentType("application/octet-stream");
                boolean dot = false;
                for (x = f_name.length() - 1; x >= 0; --x) {
                    if (Character.isLetterOrDigit(f_name.charAt(x)) || f_name.charAt(x) == '_') continue;
                    if (f_name.charAt(x) != '.' || dot) break;
                    dot = true;
                }
                if (!(suggested_fname = f_name.substring(x + 1).replace(".hex", ".csv")).endsWith(".csv")) {
                    suggested_fname = suggested_fname + ".csv";
                }
                f_name = suggested_fname;
                response.addHeader("Content-Disposition", "attachment; filename=" + f_name);
                JettyHTTPD.setResponseStatus(response, 200);
                ServletOutputStream os = response.getOutputStream();
                FileUtils.copyStream(is, (OutputStream)os, 2048);
            }
            catch (Exception e) {
                JettyHTTPD.sendErrorResponse(response, e, uri);
            }
            finally {
                JettyHTTPD.logRequest("GET", request, response);
            }
        }
    }

    public static class H2oPostFileServlet
    extends HttpServlet {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            String uri = JettyHTTPD.getDecodedUri(request);
            try {
                String destination_frame = request.getParameter("destination_frame");
                if (destination_frame == null) {
                    destination_frame = "upload" + Key.rand();
                }
                if (!JettyHTTPD.validKeyName(destination_frame)) {
                    JettyHTTPD.setResponseStatus(response, 400);
                    response.getWriter().write("Invalid key name, contains illegal characters");
                    return;
                }
                InputStream is = JettyHTTPD.extractPartInputStream(request, response);
                if (is == null) {
                    return;
                }
                UploadFileVec.ReadPutStats stats = new UploadFileVec.ReadPutStats();
                UploadFileVec.readPut(destination_frame, is, stats);
                String responsePayload = "{ \"destination_frame\": \"" + destination_frame + "\", " + "\"total_bytes\": " + stats.total_bytes + " " + "}\n";
                response.setContentType("application/json");
                response.getWriter().write(responsePayload);
            }
            catch (Exception e) {
                JettyHTTPD.sendErrorResponse(response, e, uri);
            }
            finally {
                JettyHTTPD.logRequest("POST", request, response);
            }
        }
    }

    public static class H2oNpsBinServlet
    extends HttpServlet {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            String uri = JettyHTTPD.getDecodedUri(request);
            try {
                Pattern p = Pattern.compile(".*/NodePersistentStorage.bin/([^/]+)/([^/]+)");
                Matcher m = p.matcher(uri);
                boolean b = m.matches();
                if (!b) {
                    JettyHTTPD.setResponseStatus(response, 400);
                    response.getWriter().write("Improperly formatted URI");
                    return;
                }
                String categoryName = m.group(1);
                String keyName = m.group(2);
                NodePersistentStorage nps = H2O.getNPS();
                AtomicLong length = new AtomicLong();
                InputStream is = nps.get(categoryName, keyName, length);
                if (length.get() > Integer.MAX_VALUE) {
                    throw new Exception("NPS value size exceeds Integer.MAX_VALUE");
                }
                response.setContentType("application/octet-stream");
                response.setContentLength((int)length.get());
                response.addHeader("Content-Disposition", "attachment; filename=" + keyName + ".flow");
                JettyHTTPD.setResponseStatus(response, 200);
                ServletOutputStream os = response.getOutputStream();
                FileUtils.copyStream(is, (OutputStream)os, 2048);
            }
            catch (Exception e) {
                JettyHTTPD.sendErrorResponse(response, e, uri);
            }
            finally {
                JettyHTTPD.logRequest("GET", request, response);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            String uri = JettyHTTPD.getDecodedUri(request);
            try {
                Pattern p = Pattern.compile(".*NodePersistentStorage.bin/([^/]+)/([^/]+)");
                Matcher m = p.matcher(uri);
                boolean b = m.matches();
                if (!b) {
                    JettyHTTPD.setResponseStatus(response, 400);
                    response.getWriter().write("Improperly formatted URI");
                    return;
                }
                String categoryName = m.group(1);
                String keyName = m.group(2);
                InputStream is = JettyHTTPD.extractPartInputStream(request, response);
                if (is == null) {
                    return;
                }
                H2O.getNPS().put(categoryName, keyName, is);
                long length = H2O.getNPS().get_length(categoryName, keyName);
                String responsePayload = "{ \"category\" : \"" + categoryName + "\", " + "\"name\" : " + "\"" + keyName + "\", " + "\"total_bytes\" : " + length + " " + "}\n";
                response.setContentType("application/json");
                response.getWriter().write(responsePayload);
            }
            catch (Exception e) {
                JettyHTTPD.sendErrorResponse(response, e, uri);
            }
            finally {
                JettyHTTPD.logRequest("POST", request, response);
            }
        }
    }

    public class AuthenticationHandler
    extends AbstractHandler {
        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            if (!H2O.ARGS.ldap_login && !H2O.ARGS.kerberos_login) {
                return;
            }
            String loginName = request.getUserPrincipal().getName();
            if (!loginName.equals(H2O.ARGS.user_name)) {
                Log.warn("Login name (" + loginName + ") does not match cluster owner name (" + H2O.ARGS.user_name + ")");
                JettyHTTPD.sendResponseError(response, 401, "Login name does not match cluster owner name");
                baseRequest.setHandled(true);
            }
        }
    }

    public class AddCommonResponseHeadersHandler
    extends AbstractHandler {
        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            JettyHTTPD.setCommonResponseHttpHeaders(response);
        }
    }

    public class ExtensionHandler1
    extends AbstractHandler {
        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            H2O.getJetty().handle1(target, baseRequest, request, response);
        }
    }

    public class GateHandler
    extends AbstractHandler {
        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            JettyHTTPD.startRequestLifecycle();
            while (!_acceptRequests) {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception ignore) {}
            }
        }
    }
}

