/*
 * Decompiled with CFR 0.152.
 */
package water;

import water.AutoBuffer;
import water.DTask;
import water.H2O;
import water.H2ONode;
import water.UDP;
import water.util.Log;

public class UDPRebooted
extends UDP {
    static void checkForSuicide(int first_byte, AutoBuffer ab) {
        if (first_byte != UDP.udp.rebooted.ordinal()) {
            return;
        }
        byte type = ab.get1();
        UDPRebooted.suicide(T.values()[type], ab._h2o);
    }

    static void suicide(T cause, H2ONode killer) {
        String m;
        switch (cause) {
            case none: {
                return;
            }
            case reboot: {
                return;
            }
            case shutdown: {
                Log.warn("Orderly shutdown should be handled via ShutdownTsk. Message is from outside of the cloud? Ignoring it.");
                return;
            }
            case oom: {
                m = "Out of Memory, Heap Space exceeded, increase Heap Size,";
                break;
            }
            case error: {
                m = "Error leading to a cloud kill";
                break;
            }
            case locked: {
                m = "Attempting to join an H2O cloud that is no longer accepting new H2O nodes";
                break;
            }
            case mismatch: {
                m = "Attempting to join an H2O cloud with a different H2O version (is H2O already running?)";
                break;
            }
            default: {
                m = "Received kill " + (Object)((Object)cause);
            }
        }
        H2O.closeAll();
        Log.err(m + " from " + killer);
        H2O.die("Exiting.");
    }

    @Override
    AutoBuffer call(AutoBuffer ab) {
        UDPRebooted.checkForSuicide(UDP.udp.rebooted.ordinal(), ab);
        if (ab._h2o != null) {
            ab._h2o.rebooted();
        }
        return ab;
    }

    @Override
    String print16(AutoBuffer ab) {
        ab.getPort();
        return T.values()[ab.get1()].toString();
    }

    public static class ShutdownTsk
    extends DTask<ShutdownTsk> {
        final H2ONode _killer;
        final int _timeout;
        final transient boolean[] _confirmations;
        final int _nodeId;
        transient boolean _didShutDown;

        public ShutdownTsk(H2ONode killer, int nodeId, int timeout, boolean[] confirmations) {
            super((byte)119);
            this._nodeId = nodeId;
            this._killer = killer;
            this._timeout = timeout;
            this._confirmations = confirmations;
        }

        private synchronized void doShutdown(int exitCode, String msg) {
            if (this._didShutDown) {
                return;
            }
            Log.info(msg);
            H2O.closeAll();
            H2O.exit(exitCode);
        }

        @Override
        public void compute2() {
            Log.info("Orderly shutdown from " + this._killer);
            new Thread(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(ShutdownTsk.this._timeout);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    ShutdownTsk.this.doShutdown(0, "Orderly shutdown may not have been acknowledged to " + ShutdownTsk.this._killer + " (no ackack), still exiting with exit code 0.");
                }
            }.start();
            this.tryComplete();
        }

        @Override
        public void onAck() {
            this._confirmations[this._nodeId] = true;
        }

        @Override
        public void onAckAck() {
            this.doShutdown(0, "Orderly shutdown acknowledged to " + this._killer + ", exiting with exit code 0.");
        }
    }

    public static final class T
    extends Enum<T> {
        public static final /* enum */ T none = new T();
        public static final /* enum */ T reboot = new T();
        public static final /* enum */ T shutdown = new T();
        public static final /* enum */ T oom = new T();
        public static final /* enum */ T error = new T();
        public static final /* enum */ T locked = new T();
        public static final /* enum */ T mismatch = new T();
        private static final /* synthetic */ T[] $VALUES;

        public static T[] values() {
            return (T[])$VALUES.clone();
        }

        public static T valueOf(String name) {
            return Enum.valueOf(T.class, name);
        }

        public void send(H2ONode target) {
            assert (this != none);
            new AutoBuffer(target, UDP.udp.rebooted._prior).putUdp(UDP.udp.rebooted).put1(this.ordinal()).close();
        }

        void broadcast() {
            this.send(H2O.SELF);
        }

        static {
            $VALUES = new T[]{none, reboot, shutdown, oom, error, locked, mismatch};
        }
    }
}

