/*
 * Decompiled with CFR 0.152.
 */
package water;

import java.io.IOException;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.Date;
import java.util.Random;
import water.AutoBuffer;
import water.FJPacket;
import water.H2O;
import water.TimeLine;
import water.UDP;
import water.UDPRebooted;
import water.init.NetworkInit;
import water.util.Log;

public class UDPReceiverThread
extends Thread {
    private static int _unknown_packets_per_sec = 0;
    private static long _unknown_packet_time = 0L;
    static final Random RANDOM_UDP_DROP = new Random();

    public UDPReceiverThread() {
        super("D-UDP-Recv");
    }

    @Override
    public void run() {
        Thread.currentThread().setPriority(9);
        DatagramChannel sock = NetworkInit._udpSocket;
        AbstractInterruptibleChannel errsock = null;
        boolean saw_error = false;
        while (true) {
            try {
                while (true) {
                    if (errsock != null) {
                        AbstractInterruptibleChannel tmp2 = errsock;
                        errsock = null;
                        tmp2.close();
                    }
                    if (saw_error) {
                        Thread.sleep(1000L);
                    }
                    saw_error = false;
                    if (sock == null) {
                        sock = DatagramChannel.open();
                        sock.socket().bind(H2O.SELF._key);
                    }
                    UDPReceiverThread.basic_packet_handling(new AutoBuffer(sock));
                }
            }
            catch (AsynchronousCloseException ex) {
            }
            catch (ClosedChannelException ex) {
            }
            catch (Exception e) {
                Log.err("UDP Receiver error on port " + H2O.H2O_PORT, e);
                saw_error = true;
                errsock = sock;
                sock = null;
                continue;
            }
            break;
        }
    }

    public static void basic_packet_handling(AutoBuffer ab) throws IOException {
        int drop = H2O.ARGS.random_udp_drop && RANDOM_UDP_DROP.nextInt(5) == 0 ? 2 : 0;
        TimeLine.record_recv(ab, false, drop);
        long now = ab._h2o._last_heard_from = System.currentTimeMillis();
        int ctrl = ab.getCtrl();
        ab.getPort();
        if (ctrl == UDP.udp.timeline.ordinal()) {
            UDP.udp.timeline._udp.call(ab);
            return;
        }
        if (ctrl == UDP.udp.rebooted.ordinal()) {
            UDPRebooted.checkForSuicide(ctrl, ab);
        }
        if (drop != 0) {
            return;
        }
        H2O cloud = H2O.CLOUD;
        boolean is_member = cloud.contains(ab._h2o);
        boolean is_client = ab._h2o._heartbeat._client;
        if (!(UDP.udp.UDPS[ctrl]._paxos || is_member || is_client)) {
            ++_unknown_packets_per_sec;
            long timediff = ab._h2o._last_heard_from - _unknown_packet_time;
            if (timediff > 1000L) {
                if (!H2O.ARGS.client || now - H2O.START_TIME_MILLIS.get() >= 1000L) {
                    Log.warn("UDP packets from outside the cloud: " + _unknown_packets_per_sec + "/sec, last one from " + ab._h2o + " @ " + new Date());
                }
                _unknown_packets_per_sec = 0;
                _unknown_packet_time = ab._h2o._last_heard_from;
            }
            ab.close();
            return;
        }
        H2O.submitTask(new FJPacket(ab, ctrl));
    }
}

