/*
 * Decompiled with CFR 0.152.
 */
package water.api;

import hex.Model;
import water.Key;
import water.api.API;
import water.api.FrameV3;
import water.api.KeyV3;
import water.api.ModelSchema;
import water.api.ModelSchemaBase;
import water.api.ModelSynopsisV3;
import water.api.ModelsHandler;
import water.api.RequestSchema;
import water.api.Schema;

class ModelsBase<I extends ModelsHandler.Models, S extends ModelsBase<I, S>>
extends RequestSchema<I, ModelsBase<I, S>> {
    @API(help="Name of Model of interest", json=false)
    public KeyV3.ModelKeyV3 model_id;
    @API(help="Return potentially abridged model suitable for viewing in a browser", json=false, required=false, direction=API.Direction.INPUT)
    public boolean preview = false;
    @API(help="Find and return compatible frames?", json=false, direction=API.Direction.INPUT)
    public boolean find_compatible_frames = false;
    @API(help="Models", direction=API.Direction.OUTPUT)
    public ModelSchemaBase[] models;
    @API(help="Compatible frames", direction=API.Direction.OUTPUT)
    FrameV3[] compatible_frames;

    ModelsBase() {
    }

    @Override
    public I fillImpl(I m) {
        super.fillImpl(m);
        if (null != this.models) {
            ((ModelsHandler.Models)m).models = new Model[this.models.length];
            int i = 0;
            for (ModelSchemaBase model : this.models) {
                ((ModelsHandler.Models)m).models[i++] = (Model)model.createImpl();
            }
        }
        return m;
    }

    @Override
    public ModelsBase fillFromImpl(ModelsHandler.Models m) {
        this.model_id = new KeyV3.ModelKeyV3((Key<? extends Model>)m.model_id);
        this.find_compatible_frames = m.find_compatible_frames;
        if (null != m.models) {
            this.models = new ModelSchemaBase[m.models.length];
            int i = 0;
            for (Model model : m.models) {
                this.models[i++] = (ModelSchema)Schema.schema(this.getSchemaVersion(), model).fillFromImpl(model);
            }
        }
        return this;
    }

    public ModelsBase fillFromImplWithSynopsis(ModelsHandler.Models m) {
        this.model_id = new KeyV3.ModelKeyV3((Key<? extends Model>)m.model_id);
        if (null != m.models) {
            this.models = new ModelSchemaBase[m.models.length];
            int i = 0;
            for (Model model : m.models) {
                this.models[i++] = new ModelSynopsisV3(model);
            }
        }
        return this;
    }
}

