/*
 * Decompiled with CFR 0.152.
 */
package water.api;

import com.google.code.regexp.Pattern;
import java.lang.reflect.Method;
import java.util.Arrays;
import water.H2O;
import water.Iced;
import water.api.Handler;
import water.api.HandlerFactory;
import water.api.Schema;
import water.util.MarkdownBuilder;

final class Route
extends Iced {
    static final int MIN_VERSION = 1;
    public String _http_method;
    public String _url_pattern_raw;
    public Pattern _url_pattern;
    public String _summary;
    public Class<? extends Handler> _handler_class;
    public Method _handler_method;
    public Method _doc_method;
    public String[] _path_params;
    public Handler _handler;
    final HandlerFactory _handler_factory;

    public Route() {
        this._handler_factory = null;
    }

    public Route(String http_method, String url_pattern_raw, Pattern url_pattern, String summary, Class<? extends Handler> handler_class, Method handler_method, Method doc_method, String[] path_params, HandlerFactory handler_factory) {
        assert (http_method != null && url_pattern != null && handler_class != null && handler_method != null && path_params != null);
        assert (handler_factory != null) : "handler_factory should be not null, caller has to pass it!";
        this._http_method = http_method;
        this._url_pattern_raw = url_pattern_raw;
        this._url_pattern = url_pattern;
        this._summary = summary;
        this._handler_class = handler_class;
        this._handler_method = handler_method;
        this._doc_method = doc_method;
        this._path_params = path_params;
        this._handler_factory = handler_factory;
        try {
            this._handler = this._handler_factory.create(this._handler_class);
        }
        catch (Exception ie) {
            H2O.fail("failed to register handler " + handler_class.getSimpleName() + "." + handler_method.getName(), ie);
        }
    }

    public StringBuffer markdown(Schema sinput, Schema soutput) {
        MarkdownBuilder builder = new MarkdownBuilder();
        builder.comment("Preview with http://jbt.github.io/markdown-editor");
        builder.heading1(this._http_method, this._url_pattern_raw.replace("(?<", "{").replace(">.*)", "}"));
        builder.hline();
        builder.paragraph(this._summary);
        builder.heading1("Input schema: ");
        builder.append(sinput.markdown(true, false));
        builder.heading1("Output schema: ");
        builder.append(soutput.markdown(false, true));
        return builder.stringBuffer();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Route)) {
            return false;
        }
        Route route = (Route)o;
        if (!this._handler_class.equals(route._handler_class)) {
            return false;
        }
        if (!this._handler_method.equals(route._handler_method)) {
            return false;
        }
        if (!this._doc_method.equals(route._doc_method)) {
            return false;
        }
        if (!this._http_method.equals(route._http_method)) {
            return false;
        }
        if (!this._url_pattern_raw.equals(route._url_pattern_raw)) {
            return false;
        }
        return Arrays.equals(this._path_params, route._path_params);
    }

    public int hashCode() {
        long result = this._http_method.hashCode();
        result = 31L * result + (long)this._url_pattern_raw.hashCode();
        result = 31L * result + (long)this._handler_class.hashCode();
        result = 31L * result + (long)this._handler_method.hashCode();
        result = 31L * result + (long)this._doc_method.hashCode();
        result = 31L * result + (long)Arrays.hashCode(this._path_params);
        return (int)result;
    }

    public String toString() {
        return "Route{_http_method='" + this._http_method + '\'' + ", _url_pattern=" + this._url_pattern_raw + ", _summary='" + this._summary + '\'' + ", _handler_class=" + this._handler_class + ", _handler_method=" + this._handler_method + ", _input_schema=" + Handler.getHandlerMethodInputSchema(this._handler_method) + ", _output_schema=" + Handler.getHandlerMethodOutputSchema(this._handler_method) + ", _doc_method=" + this._doc_method + ", _path_params=" + Arrays.toString(this._path_params) + '}';
    }
}

