/*
 * Decompiled with CFR 0.152.
 */
package water.api;

import hex.ModelBuilder;
import java.util.HashMap;
import water.api.API;
import water.api.Schema;
import water.util.Log;
import water.util.PojoUtils;

public class ValidationMessageBase<I extends ModelBuilder.ValidationMessage, S extends ValidationMessageBase<I, S>>
extends Schema<I, S> {
    @API(help="Type of validation message (ERROR, WARN, INFO, HIDE)", direction=API.Direction.OUTPUT)
    public String message_type;
    @API(help="Field to which the message applies", direction=API.Direction.OUTPUT)
    public String field_name;
    @API(help="Message text", direction=API.Direction.OUTPUT)
    public String message;

    public static void mapValidationMessageFieldNames(ValidationMessageBase[] validation_messages, String[] from, String[] to) {
        if (null == from && null == to) {
            return;
        }
        if (null == from || null == to) {
            throw new IllegalArgumentException("Bad parameter name translation arrays; one is null and the other isn't.");
        }
        HashMap<String, String> translations = new HashMap<String, String>();
        for (int i = 0; i < from.length; ++i) {
            translations.put(from[i], to[i]);
        }
        for (ValidationMessageBase vm : validation_messages) {
            if (null == vm) {
                Log.err("Null ValidationMessageBase for ModelBuilderSchema.");
                continue;
            }
            if (null == vm.field_name) {
                Log.err("Null field_name: " + vm);
                continue;
            }
            if (!translations.containsKey(vm.field_name)) continue;
            vm.field_name = (String)translations.get(vm.field_name);
        }
    }

    @Override
    public I createImpl() {
        return (I)new ModelBuilder.ValidationMessage(Log.valueOf(this.message_type), this.field_name, this.message);
    }

    @Override
    public S fillFromImpl(ModelBuilder.ValidationMessage vm) {
        PojoUtils.copyProperties(this, vm, PojoUtils.FieldNaming.ORIGIN_HAS_UNDERSCORES);
        this.message_type = Log.LVLS[vm.log_level()];
        if (this.field_name != null) {
            if (this.field_name.startsWith("_")) {
                this.field_name = this.field_name.substring(1);
            } else {
                Log.warn("Expected all ValidationMessage field_name values to have leading underscores; ignoring: " + this.field_name);
            }
        }
        return (S)this;
    }
}

