/*
 * Decompiled with CFR 0.152.
 */
package water.fvec;

import java.util.Arrays;
import water.fvec.Chunk;
import water.fvec.NewChunk;
import water.util.UnsafeUtils;

public class C0DChunk
extends Chunk {
    private static final int _OFF = 12;
    private double _con;

    public C0DChunk(double con, int len) {
        this._start = -1L;
        this.set_len(len);
        this._mem = new byte[12];
        this._con = con;
        UnsafeUtils.set8d(this._mem, 0, con);
        UnsafeUtils.set4(this._mem, 8, len);
    }

    @Override
    public boolean hasFloat() {
        return true;
    }

    @Override
    protected final long at8_impl(int i) {
        if (Double.isNaN(this._con)) {
            throw new IllegalArgumentException("at8_abs but value is missing");
        }
        return (long)this._con;
    }

    @Override
    protected final double atd_impl(int i) {
        return this._con;
    }

    @Override
    protected final boolean isNA_impl(int i) {
        return Double.isNaN(this._con);
    }

    @Override
    boolean set_impl(int idx, long l) {
        return (double)l == this._con;
    }

    @Override
    boolean set_impl(int i, double d) {
        return d == this._con;
    }

    @Override
    boolean set_impl(int i, float f) {
        return (double)f == this._con;
    }

    @Override
    boolean setNA_impl(int i) {
        return Double.isNaN(this._con);
    }

    @Override
    double min() {
        return this._con;
    }

    @Override
    double max() {
        return this._con;
    }

    @Override
    public NewChunk inflate_impl(NewChunk nc) {
        if (Double.isNaN(this._con)) {
            nc.set_sparseLen(nc.set_len(0));
            nc.set_sparse(0, NewChunk.Compress.NA);
            nc.addNAs(this._len);
        } else if (this._con == 0.0) {
            nc.set_len(nc.set_sparseLen(0));
            nc.set_sparse(0, NewChunk.Compress.ZERO);
            nc.addZeros(this._len);
        } else {
            nc.alloc_doubles(this._len);
            Arrays.fill(nc.doubles(), this._con);
            nc.set_len(nc.set_sparseLen(this._len));
        }
        return nc;
    }

    @Override
    public final void initFromBytes() {
        this._start = -1L;
        this._cidx = -1;
        this._con = UnsafeUtils.get8d(this._mem, 0);
        this.set_len(UnsafeUtils.get4(this._mem, 8));
    }

    @Override
    public boolean isSparseZero() {
        return this._con == 0.0;
    }

    @Override
    public int sparseLenZero() {
        return this._con == 0.0 ? 0 : this._len;
    }

    @Override
    public int nextNZ(int rid) {
        return this._con == 0.0 ? this._len : rid + 1;
    }

    @Override
    public int nonzeros(int[] arr) {
        if (this._con == 0.0) {
            return 0;
        }
        for (int i = 0; i < this._len; ++i) {
            arr[i] = i;
        }
        return this._len;
    }

    @Override
    public boolean isSparseNA() {
        return Double.isNaN(this._con);
    }

    @Override
    public int sparseLenNA() {
        return Double.isNaN(this._con) ? 0 : this._len;
    }

    @Override
    public int nextNNA(int rid) {
        return Double.isNaN(this._con) ? this._len : rid + 1;
    }

    @Override
    public int nonnas(int[] arr) {
        if (Double.isNaN(this._con)) {
            return 0;
        }
        for (int i = 0; i < this._len; ++i) {
            arr[i] = i;
        }
        return this._len;
    }

    @Override
    public int asSparseDoubles(double[] vals, int[] ids, double NA) {
        if (this._con == 0.0) {
            return 0;
        }
        double con = Double.isNaN(this._con) ? NA : this._con;
        for (int i = 0; i < this._len; ++i) {
            vals[i] = con;
            ids[i] = i;
        }
        return this._len;
    }

    @Override
    public double[] getDoubles(double[] vals, int from, int to, double NA) {
        double con = Double.isNaN(this._con) ? NA : this._con;
        for (int i = from; i < to; ++i) {
            vals[i - from] = con;
        }
        return vals;
    }

    @Override
    public double[] getDoubles(double[] vals, int[] ids) {
        int j = 0;
        for (int i : ids) {
            vals[j++] = this._con;
        }
        return vals;
    }
}

