/*
 * Decompiled with CFR 0.152.
 */
package water.fvec;

import com.google.common.base.Charsets;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import water.AutoBuffer;
import water.Futures;
import water.H2O;
import water.MemoryManager;
import water.fvec.AppendableVec;
import water.fvec.C0DChunk;
import water.fvec.C0LChunk;
import water.fvec.C16Chunk;
import water.fvec.C1Chunk;
import water.fvec.C1NChunk;
import water.fvec.C1SChunk;
import water.fvec.C2Chunk;
import water.fvec.C2SChunk;
import water.fvec.C4Chunk;
import water.fvec.C4SChunk;
import water.fvec.C8Chunk;
import water.fvec.C8DChunk;
import water.fvec.CBSChunk;
import water.fvec.CNAXDChunk;
import water.fvec.CNAXIChunk;
import water.fvec.CStrChunk;
import water.fvec.CUDChunk;
import water.fvec.CX0Chunk;
import water.fvec.CXDChunk;
import water.fvec.CXIChunk;
import water.fvec.Chunk;
import water.fvec.Vec;
import water.parser.BufferedString;
import water.util.PrettyPrint;
import water.util.UnsafeUtils;

public class NewChunk
extends Chunk {
    public final int _cidx;
    protected transient Mantissas _ms;
    protected transient BitSet _missing;
    protected transient Exponents _xs;
    private transient int[] _id;
    private transient double[] _ds;
    public transient byte[] _ss;
    private transient int[] _is;
    public boolean _sparseNA = false;
    public int _sslen;
    public int _sparseLen;
    private int _naCnt = -1;
    private int _catCnt;
    private int _strCnt;
    private int _nzCnt;
    private int _uuidCnt;
    public int _timCnt = 0;
    protected static final int MIN_SPARSE_RATIO = 8;
    private int _sparseRatio = 8;
    public boolean _isAllASCII = true;
    private transient BufferedString _bfstr = new BufferedString();
    private static long[] NAS = new long[]{255L, -32768L, Integer.MIN_VALUE, Long.MIN_VALUE};

    public void alloc_mantissa(int sparseLen) {
        this._ms = new Mantissas(sparseLen);
    }

    public void alloc_exponent(int sparseLen) {
        this._xs = new Exponents(sparseLen);
    }

    public int is(int i) {
        return this._is[i];
    }

    public void set_is(int i, int val) {
        this._is[i] = val;
    }

    public void alloc_nums(int len) {
        this._ms = new Mantissas(len);
        this._xs = new Exponents(len);
    }

    int[] alloc_indices(int l) {
        this._id = MemoryManager.malloc4(l);
        return this._id;
    }

    public double[] alloc_doubles(int l) {
        this._ms = null;
        this._xs = null;
        this._missing = null;
        this._ds = MemoryManager.malloc8d(l);
        return this._ds;
    }

    int[] alloc_str_indices(int l) {
        this._ms = null;
        this._xs = null;
        this._missing = null;
        this._ds = null;
        this._is = MemoryManager.malloc4(l);
        return this._is;
    }

    protected final int[] indices() {
        return this._id;
    }

    protected final double[] doubles() {
        return this._ds;
    }

    @Override
    public boolean isSparseZero() {
        return this.sparseZero();
    }

    @Override
    public boolean isSparseNA() {
        return this.sparseNA();
    }

    void setSparseNA() {
        this._sparseNA = true;
    }

    int set_sparseLen(int l) {
        this._sparseLen = l;
        return this._sparseLen;
    }

    @Override
    public int sparseLenZero() {
        return this._sparseNA ? this._len : this._sparseLen;
    }

    @Override
    public int sparseLenNA() {
        return this._sparseNA ? this._sparseLen : this._len;
    }

    protected int naCnt() {
        return this._naCnt;
    }

    public NewChunk(Vec vec, int cidx) {
        this._vec = vec;
        this._cidx = cidx;
        this._ms = new Mantissas(4);
        this._xs = new Exponents(4);
    }

    public NewChunk(Vec vec, int cidx, boolean sparse) {
        this._vec = vec;
        this._cidx = cidx;
        this._ms = new Mantissas(4);
        this._xs = new Exponents(4);
        if (sparse) {
            this._id = new int[4];
        }
    }

    public NewChunk(double[] ds) {
        this._cidx = -1;
        this._vec = null;
        this.setDoubles(ds);
    }

    public NewChunk(Vec vec, int cidx, long[] mantissa, int[] exponent, int[] indices, double[] doubles) {
        this._vec = vec;
        this._cidx = cidx;
        this._ms = new Mantissas(mantissa.length);
        this._xs = new Exponents(exponent.length);
        for (int i = 0; i < mantissa.length; ++i) {
            this._ms.set(i, mantissa[i]);
            this._xs.set(i, exponent[i]);
        }
        this._id = indices;
        this._ds = doubles;
        if (this._ms != null && this._sparseLen == 0) {
            this.set_sparseLen(this.set_len(mantissa.length));
        }
        if (this._ds != null && this._sparseLen == 0) {
            this.set_sparseLen(this.set_len(this._ds.length));
        }
        if (this._id != null && this._sparseLen == 0) {
            this.set_sparseLen(this._id.length);
        }
    }

    public NewChunk(Chunk c) {
        this(c._vec, c.cidx());
        this._start = c._start;
    }

    public NewChunk(Chunk c, double[] vals) {
        this._vec = c._vec;
        this._cidx = c.cidx();
        this._start = c._start;
        this._ds = vals;
        this._sparseLen = this._len = this._ds.length;
    }

    public NewChunk(Vec vec, int cidx, int len) {
        this(vec, cidx);
        this._ds = new double[len];
        Arrays.fill(this._ds, Double.NaN);
        this.set_sparseLen(this.set_len(len));
    }

    public NewChunk setSparseRatio(int s) {
        this._sparseRatio = s;
        return this;
    }

    public void setDoubles(double[] ds) {
        this._ds = ds;
        this._sparseLen = this._len = ds.length;
        this._ms = null;
        this._xs = null;
    }

    public void set_vec(Vec vec) {
        this._vec = vec;
    }

    private void add2Chunk_impl(NewChunk c, int i) {
        if (this.isNA2(i)) {
            c.addNA();
        } else if (this.isUUID()) {
            c.addUUID(this._ms.get(i), Double.doubleToRawLongBits(this._ds[i]));
        } else if (this._ms != null) {
            c.addNum(this._ms.get(i), this._xs.get(i));
        } else if (this._ds != null) {
            c.addNum(this._ds[i]);
        } else if (this._ss != null) {
            int nextNotNAIdx;
            int sidx = this._is[i];
            for (nextNotNAIdx = i + 1; nextNotNAIdx < this._is.length && this._is[nextNotNAIdx] == -1; ++nextNotNAIdx) {
            }
            int slen = nextNotNAIdx < this._is.length ? this._is[nextNotNAIdx] - sidx : this._sslen - sidx;
            BufferedString bStr = sidx == -1 ? null : this._bfstr.set(this._ss, sidx, slen);
            c.addStr(bStr);
        } else {
            throw new IllegalStateException();
        }
    }

    public void add2Chunk(NewChunk c, int i) {
        if (!this.isSparseNA() && !this.isSparseZero()) {
            this.add2Chunk_impl(c, i);
        } else {
            int j = Arrays.binarySearch(this._id, 0, this._sparseLen, i);
            if (j >= 0) {
                this.add2Chunk_impl(c, j);
            } else if (this.isSparseNA()) {
                c.addNA();
            } else {
                c.addNum(0L, 0);
            }
        }
    }

    public Iterator<Value> values() {
        return this.values(0, this._len);
    }

    public Iterator<Value> values(int fromIdx, int toIdx) {
        int gId;
        int lId;
        final int to = Math.min(toIdx, this._len);
        if (this._id != null) {
            int x = Arrays.binarySearch(this._id, 0, this._sparseLen, fromIdx);
            if (x < 0) {
                x = -x - 1;
            }
            lId = x;
            gId = x == this._sparseLen ? this._len : this._id[x];
        } else {
            lId = gId = fromIdx;
        }
        final Value v = new Value(lId, gId);
        final Value next = new Value(lId, gId);
        return new Iterator<Value>(){

            @Override
            public final boolean hasNext() {
                return next._gId < to;
            }

            @Override
            public final Value next() {
                block1: {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    v._gId = next._gId++;
                    v._lId = next._lId++;
                    if (NewChunk.this._id == null) break block1;
                    next._gId = next._lId < NewChunk.this._sparseLen ? NewChunk.this._id[next._lId] : NewChunk.this._len;
                }
                return v;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    byte type() {
        if (this._naCnt == -1) {
            int nas = 0;
            int es = 0;
            int nzs = 0;
            int ss = 0;
            if (this._ds != null && this._ms != null) {
                for (int i = 0; i < this._sparseLen; ++i) {
                    if (this._xs != null && this._xs.get(i) == Integer.MIN_VALUE) {
                        ++nas;
                        continue;
                    }
                    if (this._ds[i] == 0.0 && this._ms.get(i) == 0L) continue;
                    ++nzs;
                }
                this._uuidCnt = this._len - nas;
            } else if (this._ds != null) {
                assert (this._xs == null);
                for (int i = 0; i < this._sparseLen; ++i) {
                    if (Double.isNaN(this._ds[i])) {
                        ++nas;
                        continue;
                    }
                    if (this._ds[i] == 0.0) continue;
                    ++nzs;
                }
            } else {
                int i;
                if (this._ms != null && this._sparseLen > 0) {
                    for (i = 0; i < this._sparseLen; ++i) {
                        if (this.isNA2(i)) {
                            ++nas;
                            continue;
                        }
                        if (this.isCategorical2(i)) {
                            ++es;
                        }
                        if (this._ms.get(i) == 0L) continue;
                        ++nzs;
                    }
                }
                if (this._is != null) {
                    for (i = 0; i < this._sparseLen; ++i) {
                        if (this.isNA2(i)) {
                            ++nas;
                            continue;
                        }
                        ++ss;
                    }
                }
            }
            if (this._sparseNA) {
                nas += this._len - this._sparseLen;
            }
            this._nzCnt = nzs;
            this._catCnt = es;
            this._naCnt = nas;
            this._strCnt = ss;
        }
        if (this._naCnt == this._len) {
            return 0;
        }
        if (this._strCnt > 0) {
            return 2;
        }
        if (this._catCnt > 0 && this._catCnt + this._naCnt == this._len) {
            return 4;
        }
        if (this._uuidCnt > 0) {
            return 1;
        }
        int nums = this._len - this._naCnt - this._timCnt;
        return this._timCnt >= nums ? (byte)5 : 3;
    }

    protected final boolean isNA2(int idx) {
        if (this.isString()) {
            return this._is[idx] == -1;
        }
        if (this.isUUID() || this._ds == null) {
            return this._missing != null && this._missing.get(idx);
        }
        return Double.isNaN(this._ds[idx]);
    }

    protected final boolean isCategorical2(int idx) {
        return this._xs != null && this._xs.isCategorical(idx);
    }

    protected final boolean isCategorical(int idx) {
        if (this._id == null) {
            return this.isCategorical2(idx);
        }
        int j = Arrays.binarySearch(this._id, 0, this._sparseLen, idx);
        return j >= 0 && this.isCategorical2(j);
    }

    public void addCategorical(int e) {
        if (this._ms == null || this._ms.len() == this._sparseLen) {
            this.append2slow();
        }
        this._ms.set(this._sparseLen, e);
        this._xs.setCategorical(this._sparseLen);
        if (this._id != null) {
            this._id[this._sparseLen] = this._len;
        }
        ++this._sparseLen;
        ++this._len;
    }

    public void addNA() {
        if (!this._sparseNA) {
            if (this.isString()) {
                this.addStr(null);
                return;
            }
            if (this.isUUID()) {
                if (this._ms == null || this._ds == null || this._sparseLen >= this._ms.len()) {
                    this.append2slowUUID();
                }
                if (this._missing == null) {
                    this._missing = new BitSet();
                }
                this._missing.set(this._sparseLen);
                if (this._id != null) {
                    this._id[this._sparseLen] = this._len;
                }
                this._ds[this._sparseLen] = Double.NaN;
                ++this._sparseLen;
            } else {
                if (this._ds != null) {
                    this.addNum(Double.NaN);
                    return;
                }
                if (!this._sparseNA && this._sparseLen == this._ms.len()) {
                    this.append2slow();
                }
                if (!this._sparseNA) {
                    if (this._missing == null) {
                        this._missing = new BitSet();
                    }
                    this._missing.set(this._sparseLen);
                    if (this._id != null) {
                        this._id[this._sparseLen] = this._len;
                    }
                    ++this._sparseLen;
                }
            }
        }
        ++this._len;
    }

    public void addNum(long val, int exp) {
        if (this.isUUID() || this.isString()) {
            this.addNA();
        } else if (this._ds != null) {
            assert (this._ms == null);
            this.addNum((double)val * PrettyPrint.pow10(exp));
        } else {
            if (val == 0L) {
                exp = 0;
            }
            if (val != 0L || !this.isSparseZero()) {
                long t;
                if (this._ms == null || this._ms.len() == this._sparseLen) {
                    this.append2slow();
                    this.addNum(val, exp);
                    return;
                }
                int len = this._ms.len();
                int slen = this._sparseLen;
                while (exp < 0 && exp > -9999999 && (t = val / 10L) * 10L == val) {
                    val = t;
                    ++exp;
                }
                this._ms.set(this._sparseLen, val);
                this._xs.set(this._sparseLen, exp);
                assert (this._id == null || this._id.length == this._ms.len()) : "id.len = " + this._id.length + ", ms.len = " + this._ms.len() + ", old ms.len = " + len + ", sparseLen = " + slen;
                if (this._id != null) {
                    this._id[this._sparseLen] = this._len;
                }
                ++this._sparseLen;
            }
            ++this._len;
        }
    }

    public void addNum(double d) {
        boolean predicate;
        if (this.isUUID() || this.isString()) {
            this.addNA();
            return;
        }
        boolean bl = this._sparseNA ? !Double.isNaN(d) : (this.isSparseZero() ? d != 0.0 : (predicate = true));
        if (predicate) {
            if (this._ms != null) {
                if ((double)((long)d) == d) {
                    this.addNum((long)d, 0);
                    return;
                }
                this.switch_to_doubles();
            }
            if (this._sparseLen == this._ds.length) {
                this.append2slowd();
                this.addNum(d);
                assert (this._sparseLen <= this._len);
                return;
            }
            if (this._id != null) {
                this._id[this._sparseLen] = this._len;
            }
            this._ds[this._sparseLen] = d;
            ++this._sparseLen;
        }
        ++this._len;
        assert (this._sparseLen <= this._len);
    }

    private void append_ss(String str) {
        byte[] bytes;
        byte[] byArray = bytes = str == null ? new byte[]{} : str.getBytes(Charsets.UTF_8);
        if (this._ss == null) {
            this._ss = MemoryManager.malloc1((bytes.length + 1) * 4);
        }
        while (this._ss.length < this._sslen + bytes.length + 1) {
            this._ss = MemoryManager.arrayCopyOf(this._ss, this._ss.length << 1);
        }
        for (byte b : bytes) {
            this._ss[this._sslen++] = b;
        }
        this._ss[this._sslen++] = 0;
    }

    private void append_ss(BufferedString str) {
        int strlen = str.length();
        int off = str.getOffset();
        byte[] b = str.getBuffer();
        if (this._ss == null) {
            this._ss = MemoryManager.malloc1((strlen + 1) * 4);
        }
        while (this._ss.length < this._sslen + strlen + 1) {
            this._ss = MemoryManager.arrayCopyOf(this._ss, this._ss.length << 1);
        }
        for (int i = off; i < off + strlen; ++i) {
            this._ss[this._sslen++] = b[i];
        }
        this._ss[this._sslen++] = 0;
    }

    public void addStr(Object str) {
        if (this._id == null || str != null) {
            if (this._is == null || this._sparseLen >= this._is.length) {
                this.append2slowstr();
                this.addStr(str);
                assert (this._sparseLen <= this._len);
                return;
            }
            if (str != null) {
                if (this._id != null) {
                    this._id[this._sparseLen] = this._len;
                }
                this._is[this._sparseLen] = this._sslen;
                ++this._sparseLen;
                if (str instanceof BufferedString) {
                    this.append_ss((BufferedString)str);
                } else {
                    this.append_ss((String)str);
                }
            } else if (this._id == null) {
                this._is[this._sparseLen] = -1;
                this.set_sparseLen(this._sparseLen + 1);
            }
        }
        this.set_len(this._len + 1);
        assert (this._sparseLen <= this._len);
    }

    public void addStr(Chunk c, long row) {
        if (c.isNA_abs(row)) {
            this.addNA();
        } else {
            this.addStr(c.atStr_abs(new BufferedString(), row));
            this._isAllASCII &= ((CStrChunk)c)._isAllASCII;
        }
    }

    public void addStr(Chunk c, int row) {
        if (c.isNA(row)) {
            this.addNA();
        } else {
            this.addStr(c.atStr(new BufferedString(), row));
            this._isAllASCII &= ((CStrChunk)c)._isAllASCII;
        }
    }

    public void addUUID(long lo, long hi) {
        if (this._ms == null || this._ds == null || this._sparseLen >= this._ms.len()) {
            this.append2slowUUID();
        }
        this._ms.set(this._sparseLen, lo);
        this._ds[this._sparseLen] = Double.longBitsToDouble(hi);
        ++this._sparseLen;
        ++this._len;
        assert (this._sparseLen <= this._len);
    }

    public void addUUID(Chunk c, long row) {
        if (c.isNA_abs(row)) {
            this.addUUID(Long.MIN_VALUE, 0L);
        } else {
            this.addUUID(c.at16l_abs(row), c.at16h_abs(row));
        }
    }

    public void addUUID(Chunk c, int row) {
        if (c.isNA(row)) {
            this.addUUID(Long.MIN_VALUE, 0L);
        } else {
            this.addUUID(c.at16l(row), c.at16h(row));
        }
    }

    public final boolean isUUID() {
        return this._ms != null && this._ds != null;
    }

    public final boolean isString() {
        return this._is != null;
    }

    public final boolean sparseZero() {
        return this._id != null && !this._sparseNA;
    }

    public final boolean sparseNA() {
        return this._id != null && this._sparseNA;
    }

    public void addZeros(int n) {
        if (!this.sparseZero()) {
            for (int i = 0; i < n; ++i) {
                this.addNum(0L, 0);
            }
        } else {
            this.set_len(this._len + n);
        }
    }

    public void addNAs(int n) {
        if (!this.sparseNA()) {
            for (int i = 0; i < n; ++i) {
                this.addNA();
                if (!this.sparseNA()) continue;
                this.set_len(this._len + n - i - 1);
                return;
            }
        } else {
            this.set_len(this._len + n);
        }
    }

    public void add(NewChunk nc) {
        int i;
        assert (this._cidx >= 0);
        assert (this._sparseLen <= this._len);
        assert (nc._sparseLen <= nc._len) : "_sparseLen = " + nc._sparseLen + ", _len = " + nc._len;
        if (nc._len == 0) {
            return;
        }
        if (this._len == 0) {
            this._ms = nc._ms;
            nc._ms = null;
            this._xs = nc._xs;
            nc._xs = null;
            this._id = nc._id;
            nc._id = null;
            this._ds = nc._ds;
            nc._ds = null;
            this._is = nc._is;
            nc._is = null;
            this._ss = nc._ss;
            nc._ss = null;
            this.set_sparseLen(nc._sparseLen);
            this.set_len(nc._len);
            return;
        }
        if (nc.sparseZero() != this.sparseZero() || nc.sparseNA() != this.sparseNA()) {
            this.cancel_sparse();
            nc.cancel_sparse();
        }
        if (this._ds != null) {
            throw H2O.fail();
        }
        for (i = 0; i < nc._sparseLen; ++i) {
            this._ms.set(this._sparseLen + i, nc._ms.get(i));
            this._xs.set(this._sparseLen + i, nc._xs.get(i));
        }
        if (this._id != null) {
            assert (nc._id != null);
            this._id = MemoryManager.arrayCopyOf(this._id, this._sparseLen + nc._sparseLen);
            System.arraycopy(nc._id, 0, this._id, this._sparseLen, nc._sparseLen);
            i = this._sparseLen;
            while (i < this._sparseLen + nc._sparseLen) {
                int n = i++;
                this._id[n] = this._id[n] + this._len;
            }
        } else assert (nc._id == null);
        this.set_sparseLen(this._sparseLen + nc._sparseLen);
        this.set_len(this._len + nc._len);
        nc._ms = null;
        nc._xs = null;
        nc._id = null;
        nc.set_sparseLen(nc.set_len(0));
        assert (this._sparseLen <= this._len);
    }

    private void append2slowd() {
        assert (this._ms == null);
        if (this._ds != null && this._ds.length > 0) {
            if (this._id == null) {
                int nzs = 0;
                int nonnas = 0;
                for (double d : this._ds) {
                    if (d != 0.0) {
                        ++nzs;
                    }
                    if (Double.isNaN(d)) continue;
                    ++nonnas;
                }
                if ((nzs + 1) * this._sparseRatio < this._len) {
                    this.set_sparse(nzs, Compress.ZERO);
                    assert (this._sparseLen == 0 || this._sparseLen <= this._ds.length) : "_sparseLen = " + this._sparseLen + ", _ds.length = " + this._ds.length + ", nzs = " + nzs + ", len = " + this._len;
                    assert (this._id.length == this._ds.length);
                    assert (this._sparseLen <= this._len);
                    return;
                }
                if ((nonnas + 1) * this._sparseRatio < this._len) {
                    this.set_sparse(nonnas, Compress.NA);
                    assert (this._sparseLen == 0 || this._sparseLen <= this._ds.length) : "_sparseLen = " + this._sparseLen + ", _ds.length = " + this._ds.length + ", nonnas = " + nonnas + ", len = " + this._len;
                    assert (this._id.length == this._ds.length);
                    assert (this._sparseLen <= this._len);
                    return;
                }
            } else if (this._sparseRatio * this._sparseLen >> 2 > this._len) {
                this.cancel_sparse();
            } else {
                this._id = MemoryManager.arrayCopyOf(this._id, this._sparseLen << 1);
            }
            this._ds = MemoryManager.arrayCopyOf(this._ds, this._sparseLen << 1);
        } else {
            this.alloc_doubles(4);
            if (this._id != null) {
                this.alloc_indices(4);
            }
        }
        assert (this._sparseLen == 0 || this._ds.length > this._sparseLen) : "_ds.length = " + this._ds.length + ", _sparseLen = " + this._sparseLen;
        assert (this._id == null || this._id.length == this._ds.length);
        assert (this._sparseLen <= this._len);
    }

    private void append2slowUUID() {
        if (this._ds == null && this._ms != null) {
            this._xs = null;
            this._ms.switchToLongs();
            this._ds = MemoryManager.malloc8d(this._sparseLen);
            Arrays.fill(this._ms._vals8, Long.MIN_VALUE);
            Arrays.fill(this._ds, Double.longBitsToDouble(0L));
        }
        if (this._ms != null && this._sparseLen > 0) {
            this._ds = MemoryManager.arrayCopyOf(this._ds, this._sparseLen * 2);
            this._ms.resize(this._sparseLen * 2);
        } else {
            this._ms = new Mantissas(4);
            this._xs = null;
            this._ms.switchToLongs();
            this._ds = new double[4];
        }
    }

    private void append2slowstr() {
        if (this._xs != null) {
            this._xs = null;
            this._ms = null;
            this.alloc_str_indices(this._sparseLen);
            Arrays.fill(this._is, -1);
        }
        if (this._is != null && this._is.length > 0) {
            if (this._id == null) {
                int nzs = 0;
                for (int i : this._is) {
                    if (i == -1) continue;
                    ++nzs;
                }
                if ((nzs + 1) * this._sparseRatio < this._len) {
                    this.set_sparse(nzs, Compress.ZERO);
                }
            } else if (this._sparseRatio * this._sparseLen >> 2 > this._len) {
                this.cancel_sparse();
            } else {
                this._id = MemoryManager.arrayCopyOf(this._id, this._sparseLen << 1);
            }
            this._is = MemoryManager.arrayCopyOf(this._is, this._sparseLen << 1);
            for (int i = this._sparseLen; i < this._is.length; ++i) {
                this._is[i] = -1;
            }
        } else {
            this._is = MemoryManager.malloc4(4);
            for (int i = 0; i < this._is.length; ++i) {
                this._is[i] = -1;
            }
            if (this.sparseZero() || this.sparseNA()) {
                this.alloc_indices(4);
            }
        }
        assert (this._sparseLen == 0 || this._is.length > this._sparseLen) : "_ls.length = " + this._is.length + ", _len = " + this._sparseLen;
    }

    private void append2slow() {
        assert (this._ds == null);
        if (this._ms != null && this._sparseLen > 0) {
            if (this._id == null) {
                int nzs = this._ms._nzs + (this._missing != null ? this._missing.cardinality() : 0);
                int nonnas = this._sparseLen - (this._missing != null ? this._missing.cardinality() : 0);
                if ((nonnas + 1) * this._sparseRatio < this._len) {
                    this.set_sparse(nonnas, Compress.NA);
                    assert (this._id.length == this._ms.len()) : "id.len = " + this._id.length + ", ms.len = " + this._ms.len();
                    assert (this._sparseLen <= this._len);
                    return;
                }
                if ((nzs + 1) * this._sparseRatio < this._len) {
                    this.set_sparse(nzs, Compress.ZERO);
                    assert (this._sparseLen <= this._len);
                    assert (this._sparseLen == nzs);
                    return;
                }
            } else if (2 * this._sparseLen > this._len) {
                this.cancel_sparse();
            } else {
                this._id = MemoryManager.arrayCopyOf(this._id, this._id.length * 2);
            }
            this._ms.resize(this._sparseLen * 2);
            this._xs.resize(this._sparseLen * 2);
        } else {
            this._ms = new Mantissas(16);
            this._xs = new Exponents(16);
            if (this._id != null) {
                this._id = new int[16];
            }
        }
        assert (this._sparseLen <= this._len);
    }

    public Chunk new_close() {
        Chunk chk = this.compress();
        if (this._vec instanceof AppendableVec) {
            ((AppendableVec)this._vec).closeChunk(this._cidx, chk._len);
        }
        return chk;
    }

    public void close(Futures fs) {
        this.close(this._cidx, fs);
    }

    private void switch_to_doubles() {
        assert (this._ds == null);
        double[] ds = MemoryManager.malloc8d(this._sparseLen);
        for (int i = 0; i < this._sparseLen; ++i) {
            ds[i] = this.isNA2(i) || this.isCategorical2(i) ? Double.NaN : (double)this._ms.get(i) * PrettyPrint.pow10(this._xs.get(i));
        }
        this._ms = null;
        this._xs = null;
        this._missing = null;
        this._ds = ds;
    }

    protected void set_sparse(int num_noncompressibles, Compress sparsity_type) {
        if (sparsity_type == Compress.ZERO && this.isSparseNA() || sparsity_type == Compress.NA && this.isSparseZero()) {
            this.cancel_sparse();
        }
        if (sparsity_type == Compress.NA) {
            this._sparseNA = true;
        }
        if (this._id != null && this._sparseLen == num_noncompressibles && this._len != 0) {
            return;
        }
        if (this._id != null) {
            this.cancel_sparse();
        }
        assert (this._sparseLen == this._len) : "_sparseLen = " + this._sparseLen + ", _len = " + this._len + ", num_noncompressibles = " + num_noncompressibles;
        int cs = 0;
        if (this._is != null) {
            assert (num_noncompressibles <= this._is.length);
            this._id = MemoryManager.malloc4(this._is.length);
            for (int i = 0; i < this._sparseLen; ++i) {
                if (this._is[i] == -1) {
                    ++cs;
                    continue;
                }
                this._is[i - cs] = this._is[i];
                this._id[i - cs] = i;
            }
        } else if (this._ds == null) {
            if (this._len == 0) {
                this._ms = new Mantissas(0);
                this._xs = new Exponents(0);
                this._id = new int[0];
                this.set_sparseLen(0);
                return;
            }
            assert (num_noncompressibles <= this._sparseLen);
            this._id = MemoryManager.malloc4(this._ms.len());
            for (int i = 0; i < this._sparseLen; ++i) {
                if (this.is_compressible(i)) {
                    ++cs;
                    continue;
                }
                this._ms.move(i - cs, i);
                this._xs.move(i - cs, i);
                this._id[i - cs] = i;
                if (sparsity_type == Compress.NA || this._missing == null) continue;
                this._missing.set(i - cs, this._missing.get(i));
            }
        } else {
            assert (num_noncompressibles <= this._ds.length);
            this._id = this.alloc_indices(this._ds.length);
            for (int i = 0; i < this._sparseLen; ++i) {
                if (this.is_compressible(this._ds[i])) {
                    ++cs;
                    continue;
                }
                this._ds[i - cs] = this._ds[i];
                this._id[i - cs] = i;
            }
        }
        assert (cs == this._sparseLen - num_noncompressibles) : "cs = " + cs + " != " + (this._sparseLen - num_noncompressibles) + ", sparsity type = " + (Object)((Object)sparsity_type);
        assert (sparsity_type == Compress.NA == this._sparseNA);
        if (sparsity_type == Compress.NA && this._missing != null) {
            this._missing.clear();
        }
        this.set_sparseLen(num_noncompressibles);
    }

    private boolean is_compressible(double d) {
        return this._sparseNA ? Double.isNaN(d) : d == 0.0;
    }

    private boolean is_compressible(int x) {
        return this.isNA2(x) ? this._sparseNA : !this._sparseNA && this._ms.get(x) == 0L;
    }

    public void cancel_sparse() {
        if (this._sparseLen != this._len) {
            if (this._is != null) {
                int[] is = MemoryManager.malloc4(this._len);
                Arrays.fill(is, -1);
                for (int i = 0; i < this._sparseLen; ++i) {
                    is[this._id[i]] = this._is[i];
                }
                this._is = is;
            } else if (this._ds == null) {
                Exponents xs = new Exponents(this._len);
                Mantissas ms = new Mantissas(this._len);
                BitSet missing = new BitSet();
                if (this._sparseNA) {
                    missing.set(0, this._len);
                }
                for (int i = 0; i < this._sparseLen; ++i) {
                    xs.set(this._id[i], this._xs.get(i));
                    ms.set(this._id[i], this._ms.get(i));
                    missing.set(this._id[i], this._sparseNA || this._missing == null ? false : this._missing.get(i));
                }
                assert (this._sparseNA || ms._nzs == this._ms._nzs) : this._ms._nzs + " != " + ms._nzs;
                ms._nzs = this._ms._nzs;
                this._xs = xs;
                this._missing = missing;
                this._ms = ms;
            } else {
                double[] ds = MemoryManager.malloc8d(this._len);
                this._missing = new BitSet();
                if (this._sparseNA) {
                    Arrays.fill(ds, Double.NaN);
                }
                for (int i = 0; i < this._sparseLen; ++i) {
                    ds[this._id[i]] = this._ds[i];
                    if (!this._sparseNA) continue;
                    this._missing.set(this._id[i]);
                }
                this._ds = ds;
            }
            this.set_sparseLen(this._len);
        }
        this._id = null;
        this._sparseNA = false;
    }

    public Chunk compress() {
        Chunk res = this.compress2();
        byte type = this.type();
        assert (this._vec == null || type == this._vec._type || type == 0 || type == 3 && this._vec._type == 4 || type == 3 && this._vec._type == 5 && !res.hasFloat()) : "NewChunk has type " + Vec.TYPE_STR[type] + ", but the Vec is of type " + this._vec.get_type_str();
        assert (this._len == res._len) : "NewChunk has length " + this._len + ", compressed Chunk has " + res._len;
        this._id = null;
        this._xs = null;
        this._ds = null;
        this._ms = null;
        this._is = null;
        this._ss = null;
        return res;
    }

    private static long leRange(long lemin, long lemax) {
        if (lemin < 0L && lemax >= Long.MAX_VALUE + lemin) {
            return Long.MAX_VALUE;
        }
        long res = lemax - lemin;
        assert (res >= 0L);
        return res;
    }

    private Chunk compress2() {
        boolean fpoint;
        int i;
        byte mode = this.type();
        if (mode == 0) {
            return new C0DChunk(Double.NaN, this._len);
        }
        if (mode == 2) {
            return new CStrChunk(this._sslen, this._ss, this._sparseLen, this._len, this._is, this._isAllASCII);
        }
        boolean rerun = false;
        if (mode == 4) {
            for (i = 0; i < this._sparseLen; ++i) {
                if (this.isCategorical2(i)) {
                    this._xs.set(i, 0);
                    continue;
                }
                if (this.isNA2(i)) continue;
                this.setNA_impl2(i);
                ++this._naCnt;
            }
        } else if (mode == 3) {
            for (i = 0; i < this._sparseLen; ++i) {
                if (!this.isCategorical2(i)) continue;
                this.setNA_impl2(i);
                rerun = true;
            }
        }
        if (rerun) {
            this._naCnt = -1;
            this.type();
        }
        boolean sparse = false;
        boolean na_sparse = false;
        if (this._sparseRatio * (this._naCnt + this._nzCnt) < this._len) {
            this.set_sparse(this._naCnt + this._nzCnt, Compress.ZERO);
            sparse = true;
        } else if (this._sparseRatio * (this._len - this._naCnt) < this._len) {
            this.set_sparse(this._len - this._naCnt, Compress.NA);
            na_sparse = true;
        } else if (this._sparseLen != this._len) {
            this.cancel_sparse();
        }
        if (this._ds != null && this._ms != null) {
            return this.chunkUUID();
        }
        if (this._naCnt == this._len) {
            return new C0DChunk(Double.NaN, this._len);
        }
        if (this._ds != null) {
            int i2;
            for (i2 = 0; i2 < this._sparseLen && (Double.isNaN(this._ds[i2]) || (double)((long)this._ds[i2]) == this._ds[i2]); ++i2) {
            }
            boolean isInteger = i2 == this._sparseLen;
            boolean isConstant = !sparse && !na_sparse || this._sparseLen == 0;
            double constVal = 0.0;
            if (!sparse && !na_sparse) {
                constVal = this._ds[0];
                for (int j = 1; j < this._len; ++j) {
                    if (this._ds[j] == constVal) continue;
                    isConstant = false;
                    break;
                }
            }
            if (isConstant) {
                return isInteger ? new C0LChunk((long)constVal, this._len) : new C0DChunk(constVal, this._len);
            }
            if (!isInteger) {
                if (sparse) {
                    return new CXDChunk(this._len, 8, this.bufD(8));
                }
                if (na_sparse) {
                    return new CNAXDChunk(this._len, 8, this.bufD(8));
                }
                return this.chunkD();
            }
            this._ms = new Mantissas(this._ds.length);
            this._xs = new Exponents(this._ds.length);
            this._missing = new BitSet();
            double[] ds = this._ds;
            this._ds = null;
            int naCnt = this._naCnt;
            for (i2 = 0; i2 < this._sparseLen; ++i2) {
                if (Double.isNaN(ds[i2])) {
                    this._missing.set(i2);
                    continue;
                }
                this._ms.set(i2, (long)ds[i2]);
                this._xs.set(i2, 0);
            }
            this._naCnt = naCnt;
        }
        int xmin = Integer.MAX_VALUE;
        boolean floatOverflow = false;
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        int p10iLength = PrettyPrint.powers10i.length;
        long llo = Long.MAX_VALUE;
        long lhi = Long.MIN_VALUE;
        int xlo = Integer.MAX_VALUE;
        int xhi = Integer.MIN_VALUE;
        for (int i3 = 0; i3 < this._sparseLen; ++i3) {
            long t;
            if (this.isNA2(i3)) continue;
            long l = this._ms.get(i3);
            int x = this._xs.get(i3);
            if (x == Integer.MIN_VALUE) {
                x = 0;
            }
            assert (l != 0L || x == 0) : "l == 0 while x = " + x + " ms = " + this._ms.toString();
            while (l != 0L && (t = l / 10L) * 10L == l) {
                l = t;
                ++x;
            }
            double d = (double)l * PrettyPrint.pow10(x);
            if (d < min) {
                min = d;
                llo = l;
                xlo = x;
            }
            if (d > max) {
                max = d;
                lhi = l;
                xhi = x;
            }
            floatOverflow = l < -2147483647L || l > Integer.MAX_VALUE;
            xmin = Math.min(xmin, x);
        }
        if (sparse) {
            if (min > 0.0) {
                min = 0.0;
                llo = 0L;
                xlo = 0;
            }
            if (max < 0.0) {
                max = 0.0;
                lhi = 0L;
                xhi = 0;
            }
            xmin = Math.min(xmin, 0);
        }
        if (this._naCnt == 0 && min == max) {
            if (llo == lhi && xlo == 0 && xhi == 0) {
                return new C0LChunk(llo, this._len);
            }
            if ((double)((long)min) == min) {
                return new C0LChunk((long)min, this._len);
            }
            return new C0DChunk(min, this._len);
        }
        boolean overflow = xhi - xmin >= p10iLength || xlo - xmin >= p10iLength;
        long lemax = 0L;
        long lemin = 0L;
        if (!overflow) {
            long pow10lo;
            long pow10 = PrettyPrint.pow10i(xhi - xmin);
            lemax = lhi * pow10;
            if (lemax / pow10 != lhi) {
                overflow = true;
            }
            if ((lemin = llo * (pow10lo = PrettyPrint.pow10i(xlo - xmin))) / pow10lo != llo) {
                overflow = true;
            }
        }
        if (max == 1.0 && min == 0.0 && xmin == 0 && !overflow) {
            if (sparse) {
                return this._naCnt == 0 ? new CX0Chunk(this._len, this.bufS(0)) : new CXIChunk(this._len, 1, this.bufS(1));
            }
            if (na_sparse) {
                return new CNAXIChunk(this._len, 1, this.bufS(1));
            }
            int bpv = this._catCnt + this._naCnt > 0 ? 2 : 1;
            byte[] cbuf = this.bufB(bpv);
            return new CBSChunk(cbuf, cbuf[0], cbuf[1]);
        }
        boolean bl = fpoint = xmin < 0 || min < -9.223372036854776E18 || max > 9.223372036854776E18;
        if (sparse) {
            if (fpoint) {
                return new CXDChunk(this._len, 8, this.bufD(8));
            }
            int sz = 8;
            if (-32768.0 <= min && max <= 32767.0) {
                sz = 2;
            } else if (-2.147483648E9 <= min && max <= 2.147483647E9) {
                sz = 4;
            }
            return new CXIChunk(this._len, sz, this.bufS(sz));
        }
        if (na_sparse) {
            if (fpoint) {
                return new CNAXDChunk(this._len, 8, this.bufD(8));
            }
            int sz = 8;
            if (-32768.0 <= min && max <= 32767.0) {
                sz = 2;
            } else if (-2.147483648E9 <= min && max <= 2.147483647E9) {
                sz = 4;
            }
            return new CNAXIChunk(this._len, sz, this.bufS(sz));
        }
        if (overflow || fpoint && floatOverflow || -35 > xmin || xmin > 35) {
            return this.chunkD();
        }
        long leRange = NewChunk.leRange(lemin, lemax);
        if (fpoint) {
            if ((long)((int)lemin) == lemin && (long)((int)lemax) == lemax) {
                if (leRange < 255L) {
                    return new C1SChunk(this.bufX(lemin, xmin, 16, 0), lemin, PrettyPrint.pow10(xmin));
                }
                if (leRange < 65535L) {
                    long bias = 32767L + lemin;
                    return new C2SChunk(this.bufX(bias, xmin, 16, 1), bias, PrettyPrint.pow10(xmin));
                }
            }
            if (leRange < 0xFFFFFFFFL) {
                long bias = Integer.MAX_VALUE + lemin;
                return new C4SChunk(this.bufX(bias, xmin, 16, 2), bias, PrettyPrint.pow10(xmin));
            }
            return this.chunkD();
        }
        if (xmin == 0 && 0L <= lemin && lemax <= 255L && this._naCnt + this._catCnt == 0) {
            return new C1NChunk(this.bufX(0L, 0, 0, 0));
        }
        if (lemin < Integer.MIN_VALUE) {
            return new C8Chunk(this.bufX(0L, 0, 0, 3));
        }
        if (leRange < 255L) {
            if (0.0 <= min && max < 255.0) {
                return new C1Chunk(this.bufX(0L, 0, 0, 0));
            }
            return new C1SChunk(this.bufX(lemin, xmin, 16, 0), lemin, PrettyPrint.pow10i(xmin));
        }
        if (leRange < 65535L) {
            if (xmin == 0 && -32768L < lemin && lemax <= 32767L) {
                return new C2Chunk(this.bufX(0L, 0, 0, 1));
            }
            long bias = lemin - -32767L;
            return new C2SChunk(this.bufX(bias, xmin, 16, 1), bias, PrettyPrint.pow10i(xmin));
        }
        if (-2.147483648E9 < min && max <= 2.147483647E9) {
            return new C4Chunk(this.bufX(0L, 0, 0, 2));
        }
        return new C8Chunk(this.bufX(0L, 0, 0, 3));
    }

    private byte[] bufS(int valsz) {
        int log = 0;
        while (1 << log < valsz) {
            ++log;
        }
        assert (valsz == 0 || 1 << log == valsz);
        int ridsz = this._len >= 65535 ? 4 : 2;
        int elmsz = ridsz + valsz;
        int off = 6;
        byte[] buf = MemoryManager.malloc1(off + this._sparseLen * elmsz, true);
        int i = 0;
        while (i < this._sparseLen) {
            if (ridsz == 2) {
                UnsafeUtils.set2(buf, off, (short)this._id[i]);
            } else {
                UnsafeUtils.set4(buf, off, this._id[i]);
            }
            if (valsz == 0) {
                assert (this._xs.get(i) == 0 && this._ms.get(i) == 1L);
            } else {
                assert (this.isNA2(i) || this._xs.get(i) >= 0) : "unexpected exponent " + this._xs.get(i);
                long lval = this.isNA2(i) ? NAS[log] : this._ms.get(i) * PrettyPrint.pow10i(this._xs.get(i));
                switch (valsz) {
                    case 1: {
                        buf[off + ridsz] = (byte)lval;
                        break;
                    }
                    case 2: {
                        short sval = (short)lval;
                        UnsafeUtils.set2(buf, off + ridsz, sval);
                        break;
                    }
                    case 4: {
                        int ival = (int)lval;
                        UnsafeUtils.set4(buf, off + ridsz, ival);
                        break;
                    }
                    case 8: {
                        UnsafeUtils.set8(buf, off + ridsz, lval);
                        break;
                    }
                    default: {
                        throw H2O.fail();
                    }
                }
            }
            ++i;
            off += elmsz;
        }
        assert (off == buf.length);
        return buf;
    }

    private byte[] bufD(int valsz) {
        int log = 0;
        while (1 << log < valsz) {
            ++log;
        }
        assert (1 << log == valsz);
        int ridsz = this._len >= 65535 ? 4 : 2;
        int elmsz = ridsz + valsz;
        int off = 6;
        byte[] buf = MemoryManager.malloc1(off + this._sparseLen * elmsz, true);
        int i = 0;
        while (i < this._sparseLen) {
            if (ridsz == 2) {
                UnsafeUtils.set2(buf, off, (short)this._id[i]);
            } else {
                UnsafeUtils.set4(buf, off, this._id[i]);
            }
            double dval = this._ds == null ? (this.isNA2(i) ? Double.NaN : (double)this._ms.get(i) * PrettyPrint.pow10(this._xs.get(i))) : this._ds[i];
            switch (valsz) {
                case 4: {
                    UnsafeUtils.set4f(buf, off + ridsz, (float)dval);
                    break;
                }
                case 8: {
                    UnsafeUtils.set8d(buf, off + ridsz, dval);
                    break;
                }
                default: {
                    throw H2O.fail();
                }
            }
            ++i;
            off += elmsz;
        }
        assert (off == buf.length);
        return buf;
    }

    private byte[] bufX(long bias, int scale, int off, int log) {
        byte[] bs = new byte[(this._len << log) + off];
        int j = 0;
        block6: for (int i = 0; i < this._len; ++i) {
            long le = -bias;
            if (this._id == null || this._id.length == 0 || j < this._id.length && this._id[j] == i) {
                if (this.isNA2(j)) {
                    le = NAS[log];
                } else {
                    int x = (this._xs.get(j) == -2147483647 ? 0 : this._xs.get(j)) - scale;
                    le += x >= 0 ? this._ms.get(j) * PrettyPrint.pow10i(x) : this._ms.get(j) / PrettyPrint.pow10i(-x);
                }
                ++j;
            }
            switch (log) {
                case 0: {
                    bs[i + off] = (byte)le;
                    continue block6;
                }
                case 1: {
                    UnsafeUtils.set2(bs, (i << 1) + off, (short)le);
                    continue block6;
                }
                case 2: {
                    UnsafeUtils.set4(bs, (i << 2) + off, (int)le);
                    continue block6;
                }
                case 3: {
                    UnsafeUtils.set8(bs, (i << 3) + off, le);
                    continue block6;
                }
                default: {
                    throw H2O.fail();
                }
            }
        }
        assert (j == this._sparseLen) : "j = " + j + ", _sparseLen = " + this._sparseLen;
        return bs;
    }

    private Chunk chunkD() {
        HashMap<Long, Byte> hs = new HashMap<Long, Byte>(CUDChunk.MAX_UNIQUES);
        Byte dummy = 0;
        byte[] bs = MemoryManager.malloc1(this._len * 8, true);
        int j = 0;
        boolean fitsInUnique = true;
        for (int i = 0; i < this._len; ++i) {
            double d = 0.0;
            if (this._id == null || this._id.length == 0 || j < this._id.length && this._id[j] == i) {
                d = this._ds != null ? this._ds[j] : (this.isNA2(j) || this.isCategorical(j) ? Double.NaN : (double)this._ms.get(j) * PrettyPrint.pow10(this._xs.get(j)));
                ++j;
            }
            if (fitsInUnique) {
                if (hs.size() < CUDChunk.MAX_UNIQUES) {
                    hs.put(Double.doubleToLongBits(d), dummy);
                } else {
                    fitsInUnique = hs.size() == CUDChunk.MAX_UNIQUES && hs.containsKey(Double.doubleToLongBits(d));
                }
            }
            UnsafeUtils.set8d(bs, 8 * i, d);
        }
        assert (j == this._sparseLen) : "j = " + j + ", _len = " + this._sparseLen;
        if (fitsInUnique && (double)CUDChunk.computeByteSize(hs.size(), this.len()) < 0.8 * (double)bs.length) {
            return new CUDChunk(bs, hs, this.len());
        }
        return new C8DChunk(bs);
    }

    private Chunk chunkUUID() {
        byte[] bs = MemoryManager.malloc1(this._len * 16, true);
        int j = 0;
        for (int i = 0; i < this._len; ++i) {
            long lo = 0L;
            long hi = 0L;
            if (this._id == null || this._id.length == 0 || j < this._id.length && this._id[j] == i) {
                if (this._missing != null && this._missing.get(j)) {
                    lo = Long.MIN_VALUE;
                    hi = 0L;
                } else {
                    lo = this._ms.get(j);
                    hi = Double.doubleToRawLongBits(this._ds[j]);
                }
                ++j;
            }
            UnsafeUtils.set8(bs, 16 * i, lo);
            UnsafeUtils.set8(bs, 16 * i + 8, hi);
        }
        assert (j == this._sparseLen) : "j = " + j + ", _sparselen = " + this._sparseLen;
        return new C16Chunk(bs);
    }

    private byte[] bufB(int bpv) {
        assert (bpv == 1 || bpv == 2) : "Only bit vectors with/without NA are supported";
        int off = 2;
        int clen = 2 + CBSChunk.clen(this._len, bpv);
        byte[] bs = new byte[clen];
        bs[0] = (byte)((this._len * bpv & 7) == 0 ? 0 : 8 - (this._len * bpv & 7));
        bs[1] = (byte)bpv;
        int boff = 0;
        byte b = 0;
        int idx = 2;
        int j = 0;
        for (int i = 0; i < this._len; ++i) {
            byte val = 0;
            if (this._id == null || j < this._id.length && this._id[j] == i) {
                assert (bpv == 2 || !this.isNA2(j));
                val = (byte)(this.isNA2(j) ? 2L : this._ms.get(j));
                ++j;
            }
            b = bpv == 1 ? CBSChunk.write1b(b, val, boff) : CBSChunk.write2b(b, val, boff);
            if ((boff += bpv) <= 8 - bpv) continue;
            assert (boff == 8);
            bs[idx] = b;
            boff = 0;
            b = 0;
            ++idx;
        }
        assert (j == this._sparseLen);
        assert (bs[0] == (byte)(boff == 0 ? 0 : 8 - boff)) : "b[0] = " + bs[0] + ", boff = " + boff + ", bpv = " + bpv;
        if (boff > 0) {
            bs[idx] = b;
        }
        return bs;
    }

    @Override
    boolean set_impl(int i, long l) {
        if (this._ds != null) {
            return this.set_impl(i, (double)l);
        }
        if (this._sparseLen != this._len) {
            int idx = Arrays.binarySearch(this._id, 0, this._sparseLen, i);
            if (idx >= 0) {
                i = idx;
            } else {
                this.cancel_sparse();
            }
        }
        this._ms.set(i, l);
        this._xs.set(i, 0);
        if (this._missing != null) {
            this._missing.clear(i);
        }
        this._naCnt = -1;
        return true;
    }

    @Override
    public boolean set_impl(int i, double d) {
        if (this._ds == null && (double)((long)d) == d) {
            return this.set_impl(i, (long)d);
        }
        if (this._ds == null) {
            if (this._is == null) {
                assert (this._sparseLen == 0 || this._ms != null);
                this.switch_to_doubles();
            } else {
                if (this._is[i] == -1) {
                    return true;
                }
                assert (Double.isNaN(d)) : "can only set strings to <NA>, nothing else";
                this.set_impl(i, null);
                return true;
            }
        }
        if (this._sparseLen != this._len) {
            int idx = Arrays.binarySearch(this._id, 0, this._sparseLen, i);
            if (idx >= 0) {
                i = idx;
            } else {
                this.cancel_sparse();
            }
        }
        assert (i < this._sparseLen);
        this._ds[i] = d;
        this._naCnt = -1;
        return true;
    }

    @Override
    boolean set_impl(int i, float f) {
        return this.set_impl(i, (double)f);
    }

    @Override
    boolean set_impl(int i, String str) {
        if (this._is == null && this._len > 0) {
            assert (this._sparseLen == 0);
            this.alloc_str_indices(this._len);
            Arrays.fill(this._is, -1);
        }
        if (this._sparseLen != this._len) {
            int idx = Arrays.binarySearch(this._id, 0, this._sparseLen, i);
            if (idx >= 0) {
                i = idx;
            } else {
                this.cancel_sparse();
            }
        }
        this._is[i] = this._sslen;
        this.append_ss(str);
        return true;
    }

    protected final boolean setNA_impl2(int i) {
        if (!this.isUUID() && this._ds != null) {
            this._ds[i] = Double.NaN;
            return true;
        }
        if (this.isString()) {
            this._is[i] = -1;
            return true;
        }
        if (this._missing == null) {
            this._missing = new BitSet();
        }
        this._missing.set(i);
        this._ms.set(i, 0L);
        this._naCnt = -1;
        return true;
    }

    @Override
    boolean setNA_impl(int i) {
        if (this.isNA_impl(i)) {
            return true;
        }
        if (this._sparseLen != this._len) {
            int idx = Arrays.binarySearch(this._id, 0, this._sparseLen, i);
            if (idx >= 0) {
                i = idx;
            } else {
                this.cancel_sparse();
            }
        }
        return this.setNA_impl2(i);
    }

    protected final long at8_impl2(int i) {
        if (this.isNA2(i)) {
            throw new RuntimeException("Attempting to access NA as integer value.");
        }
        if (this._ms == null) {
            return (long)this._ds[i];
        }
        return this._ms.get(i) * PrettyPrint.pow10i(this._xs.get(i));
    }

    @Override
    public long at8_impl(int i) {
        if (this._len != this._sparseLen) {
            int idx = Arrays.binarySearch(this._id, 0, this._sparseLen, i);
            if (idx >= 0) {
                i = idx;
            } else {
                if (this._sparseNA) {
                    throw new RuntimeException("Attempting to access NA as integer value.");
                }
                return 0L;
            }
        }
        return this.at8_impl2(i);
    }

    @Override
    public double atd_impl(int i) {
        if (this._len != this._sparseLen) {
            int idx = Arrays.binarySearch(this._id, 0, this._sparseLen, i);
            if (idx >= 0) {
                i = idx;
            } else {
                return this.sparseNA() ? Double.NaN : 0.0;
            }
        }
        if (this.isNA2(i)) {
            return Double.NaN;
        }
        if (this._ds == null) {
            return this._xs.get(i) >= 0 ? (double)this.at8_impl2(i) : (double)this._ms.get(i) * Math.pow(10.0, this._xs.get(i));
        }
        assert (this._xs == null);
        return this._ds[i];
    }

    @Override
    protected long at16l_impl(int idx) {
        if (this._ms.get(idx) == Long.MIN_VALUE) {
            throw new RuntimeException("Attempting to access NA as integer value.");
        }
        return this._ms.get(idx);
    }

    @Override
    protected long at16h_impl(int idx) {
        long hi = Double.doubleToRawLongBits(this._ds[idx]);
        if (hi == 0L) {
            throw new RuntimeException("Attempting to access NA as integer value.");
        }
        return hi;
    }

    @Override
    public boolean isNA_impl(int i) {
        if (this._len != this._sparseLen) {
            int idx = Arrays.binarySearch(this._id, 0, this._sparseLen, i);
            if (idx >= 0) {
                i = idx;
            } else {
                return this.sparseNA();
            }
        }
        return !this.sparseNA() && this.isNA2(i);
    }

    @Override
    public BufferedString atStr_impl(BufferedString bStr, int i) {
        if (this._sparseLen != this._len) {
            int idx = Arrays.binarySearch(this._id, 0, this._sparseLen, i);
            if (idx >= 0) {
                i = idx;
            } else {
                return null;
            }
        }
        if (this._is[i] == -1) {
            return null;
        }
        int len = 0;
        while (this._ss[this._is[i] + len] != 0) {
            ++len;
        }
        return bStr.set(this._ss, this._is[i], len);
    }

    @Override
    protected final void initFromBytes() {
        throw H2O.fail();
    }

    public static AutoBuffer write_impl(NewChunk nc, AutoBuffer bb) {
        throw H2O.fail();
    }

    @Override
    public NewChunk inflate_impl(NewChunk nc) {
        throw H2O.fail();
    }

    @Override
    public String toString() {
        return "NewChunk._sparseLen=" + this._sparseLen;
    }

    @Override
    public int cidx() {
        return this._cidx;
    }

    public static enum Compress {
        ZERO,
        NA;

    }

    public final class Value {
        int _gId;
        int _lId;

        public Value(int lid, int gid) {
            this._lId = lid;
            this._gId = gid;
        }

        public final int rowId0() {
            return this._gId;
        }

        public void add2Chunk(NewChunk c) {
            NewChunk.this.add2Chunk_impl(c, this._lId);
        }
    }

    public static class Mantissas {
        byte[] _vals1;
        int[] _vals4;
        long[] _vals8;
        int _nzs;

        public Mantissas(int cap) {
            this._vals1 = MemoryManager.malloc1(cap);
        }

        public void set(int idx, long l) {
            long old;
            if (this._vals1 != null) {
                byte b = (byte)l;
                if ((long)b == l) {
                    old = this._vals1[idx];
                    this._vals1[idx] = b;
                } else {
                    int i = (int)l;
                    if ((long)i == l) {
                        this.switchToInts();
                        old = this._vals4[idx];
                        this._vals4[idx] = i;
                    } else {
                        this.switchToLongs();
                        old = this._vals8[idx];
                        this._vals8[idx] = l;
                    }
                }
            } else if (this._vals4 != null) {
                int i = (int)l;
                if ((long)i != l) {
                    this.switchToLongs();
                    old = this._vals8[idx];
                    this._vals8[idx] = l;
                } else {
                    old = this._vals4[idx];
                    this._vals4[idx] = i;
                }
            } else {
                old = this._vals8[idx];
                this._vals8[idx] = l;
            }
            if (old != l) {
                if (old == 0L) {
                    ++this._nzs;
                } else if (l == 0L) {
                    --this._nzs;
                }
            }
        }

        public long get(int id) {
            if (this._vals1 != null) {
                return this._vals1[id];
            }
            if (this._vals4 != null) {
                return this._vals4[id];
            }
            return this._vals8[id];
        }

        public void switchToInts() {
            int len = this._vals1.length;
            this._vals4 = MemoryManager.malloc4(len);
            for (int i = 0; i < this._vals1.length; ++i) {
                this._vals4[i] = this._vals1[i];
            }
            this._vals1 = null;
        }

        public void switchToLongs() {
            int len;
            int newlen = len = Math.max(this._vals1 == null ? 0 : this._vals1.length, this._vals4 == null ? 0 : this._vals4.length);
            this._vals8 = MemoryManager.malloc8(newlen);
            if (this._vals1 != null) {
                for (int i = 0; i < this._vals1.length; ++i) {
                    this._vals8[i] = this._vals1[i];
                }
            } else if (this._vals4 != null) {
                for (int i = 0; i < this._vals4.length; ++i) {
                    this._vals8[i] = this._vals4[i];
                }
            }
            this._vals1 = null;
            this._vals4 = null;
        }

        public void move(int to, int from) {
            if (to != from) {
                if (this._vals1 != null) {
                    this._vals1[to] = this._vals1[from];
                    this._vals1[from] = 0;
                } else if (this._vals4 != null) {
                    this._vals4[to] = this._vals4[from];
                    this._vals4[from] = 0;
                } else {
                    this._vals8[to] = this._vals8[from];
                    this._vals8[from] = 0L;
                }
            }
        }

        public int len() {
            return this._vals1 != null ? this._vals1.length : (this._vals4 != null ? this._vals4.length : this._vals8.length);
        }

        public void resize(int len) {
            if (this._vals1 != null) {
                this._vals1 = Arrays.copyOf(this._vals1, len);
            } else if (this._vals4 != null) {
                this._vals4 = Arrays.copyOf(this._vals4, len);
            } else if (this._vals8 != null) {
                this._vals8 = Arrays.copyOf(this._vals8, len);
            }
        }
    }

    public static class Exponents {
        int _len;
        byte[] _vals1;
        int[] _vals4;
        private static byte CATEGORICAL_1 = (byte)-128;
        private static int CATEGORICAL_2 = Integer.MIN_VALUE;

        public Exponents(int cap) {
            this._len = cap;
        }

        private void alloc_data(int val) {
            byte b = (byte)val;
            if (b == val && b != CATEGORICAL_1) {
                this._vals1 = MemoryManager.malloc1(this._len);
            } else {
                this._vals4 = MemoryManager.malloc4(this._len);
            }
        }

        public void set(int idx, int x) {
            if (this._vals1 == null && this._vals4 == null) {
                if (x == 0) {
                    return;
                }
                this.alloc_data(x);
            }
            if (this._vals1 != null) {
                byte b = (byte)x;
                if (x == b && b > -129) {
                    this._vals1[idx] = b;
                } else {
                    int len = this._vals1.length;
                    this._vals4 = MemoryManager.malloc4(len);
                    for (int i = 0; i < this._vals1.length; ++i) {
                        this._vals4[i] = this._vals1[i] == CATEGORICAL_1 ? CATEGORICAL_2 : this._vals1[i];
                    }
                    this._vals1 = null;
                    this._vals4[idx] = x;
                }
            } else {
                this._vals4[idx] = x;
            }
        }

        public int get(int id) {
            if (this._vals1 == null && null == this._vals4) {
                return 0;
            }
            if (this._vals1 != null) {
                int x = this._vals1[id];
                if (x == CATEGORICAL_1) {
                    x = CATEGORICAL_2;
                }
                return x;
            }
            return this._vals4[id];
        }

        public boolean isCategorical(int i) {
            return this._vals1 != null && this._vals1[i] == CATEGORICAL_1 || this._vals4 != null && this._vals4[i] == CATEGORICAL_2;
        }

        public void setCategorical(int idx) {
            if (this._vals1 == null && this._vals4 == null) {
                this.alloc_data(0);
            }
            if (this._vals1 != null) {
                this._vals1[idx] = CATEGORICAL_1;
            } else {
                this._vals4[idx] = CATEGORICAL_2;
            }
        }

        public void move(int to, int from) {
            if (this._vals1 == null && null == this._vals4) {
                return;
            }
            if (this._vals1 != null) {
                this._vals1[to] = this._vals1[from];
            } else {
                this._vals4[to] = this._vals4[from];
            }
        }

        public void resize(int len) {
            if (this._vals1 != null) {
                this._vals1 = Arrays.copyOf(this._vals1, len);
            } else if (this._vals4 != null) {
                this._vals4 = Arrays.copyOf(this._vals4, len);
            }
            this._len = len;
        }
    }
}

